/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import de.uwemock.eur.data.Constants;
import de.uwemock.eur.depreciation.DecliningBalanceDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.gui.AbstractDepreciationEditor;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.guitools.GuiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DecliningBalanceDepreciationEditPanel
extends AbstractDepreciationEditor
implements Observer {
    private DecliningBalanceDepreciationStrategy strategy;
    private int currentYear;
    private int minYearLinear;
    private int maxYearLinear;
    private JSpinner startLinearYearInput;
    private JSpinner percentInput;
    private List<String> yearList;
    private SpinnerListModel startLinearYearModel;

    public DecliningBalanceDepreciationEditPanel(int currentYear, DepreciationStrategy strategy, AbstractReceipt receipt) {
        this.currentYear = currentYear;
        this.strategy = strategy != null ? (DecliningBalanceDepreciationStrategy)strategy.getCopy() : new DecliningBalanceDepreciationStrategy(currentYear, 10, new BigDecimal(25), currentYear + 10, null);
        this.minYearLinear = this.strategy.getStartYear();
        this.maxYearLinear = this.minYearLinear + this.strategy.getNumYears();
        this.yearList = new ArrayList<String>();
        int i = 0;
        while (i <= this.strategy.getNumYears()) {
            this.yearList.add(Integer.toString(this.strategy.getStartYear() + i));
            ++i;
        }
        this.startLinearYearModel = new SpinnerListModel(this.yearList);
        this.createComponentTree();
        this.connectListeners();
        if (this.currentYear > this.strategy.getStartYearLinear()) {
            this.startLinearYearInput.setEnabled(false);
        }
    }

    private void createComponentTree() {
        this.setupNumYearsSpinner(this.currentYear, this.strategy);
        this.startLinearYearInput = new JSpinner(this.startLinearYearModel);
        int startYearLinear = this.strategy.getStartYearLinear();
        if (startYearLinear >= this.minYearLinear && startYearLinear <= this.maxYearLinear) {
            this.startLinearYearModel.setValue(Integer.toString(startYearLinear));
        }
        this.percentInput = new JSpinner(new SpinnerNumberModel(Math.min(this.strategy.getPercent().doubleValue(), this.calculateMaxPercent()), 0.0, this.calculateMaxPercent(), 0.1));
        GridBagLayout gbl = new GridBagLayout();
        JPanel inputPanel = new JPanel(gbl);
        inputPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleDepreciation")));
        GuiTools.addComponent(inputPanel, gbl, new JLabel(TextPool.getString("labelDepreciationPercent")), 0, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, this.percentInput, 1, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, new JLabel(TextPool.getString("labelDepreciationYears")), 0, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, this.numYearsInput, 1, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, new JLabel(TextPool.getString("labelDepreciationStartOfLinear")), 0, 2, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, this.startLinearYearInput, 1, 2, 1, 1, 0.0, 0.0);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleDepreciationButtons")));
        JButton button = new JButton(TextPool.getString("buttonDepreciationCalculateStartOfLinear"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DecliningBalanceDepreciationStrategy strategy = DecliningBalanceDepreciationEditPanel.this.strategy;
                int startYearLinear = strategy.getStartYear() + strategy.getNumYears() - Constants.ONEHUNDRED.divide(strategy.getPercent(), RoundingMode.DOWN).intValue() + 1;
                DecliningBalanceDepreciationEditPanel.this.startLinearYearInput.setValue(Integer.toString(startYearLinear));
                strategy.setStartYearLinear(startYearLinear);
            }
        });
        buttonPanel.add((Component)button, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)inputPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    private void connectListeners() {
        this.startLinearYearInput.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner input = DecliningBalanceDepreciationEditPanel.this.startLinearYearInput;
                int value = Integer.parseInt(input.getValue().toString());
                DecliningBalanceDepreciationEditPanel.this.strategy.setStartYearLinear(value);
            }
        });
        this.numYearsInput.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner input = DecliningBalanceDepreciationEditPanel.this.numYearsInput;
                DecliningBalanceDepreciationStrategy strategy = DecliningBalanceDepreciationEditPanel.this.strategy;
                List yearList = DecliningBalanceDepreciationEditPanel.this.yearList;
                int value = Integer.parseInt(input.getValue().toString());
                if (value > strategy.getNumYears()) {
                    int i = strategy.getNumYears() + 1;
                    while (i <= value) {
                        yearList.add(Integer.toString(strategy.getStartYear() + i));
                        ++i;
                    }
                } else {
                    JSpinner startLinearYearinput = DecliningBalanceDepreciationEditPanel.this.startLinearYearInput;
                    yearList.contains(startLinearYearinput.getValue().toString());
                    while (yearList.size() > value + 1) {
                        if (startLinearYearinput.getValue().toString().equals(yearList.get(yearList.size() - 1))) {
                            startLinearYearinput.setValue(yearList.get(yearList.size() - 2));
                        }
                        yearList.remove(yearList.size() - 1);
                    }
                }
                DecliningBalanceDepreciationEditPanel.this.strategy.setNumYears(value);
                SpinnerNumberModel model = (SpinnerNumberModel)DecliningBalanceDepreciationEditPanel.this.percentInput.getModel();
                double currentValue = ((Number)model.getValue()).doubleValue();
                double newMaxValue = DecliningBalanceDepreciationEditPanel.this.calculateMaxPercent();
                if (currentValue > newMaxValue) {
                    model.setValue(newMaxValue);
                }
                model.setMaximum(Double.valueOf(newMaxValue));
            }
        });
        this.percentInput.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner input = DecliningBalanceDepreciationEditPanel.this.percentInput;
                BigDecimal value = new BigDecimal(input.getValue().toString());
                DecliningBalanceDepreciationEditPanel.this.strategy.setPercent(value);
            }
        });
    }

    private double calculateMaxPercent() {
        BigDecimal maxValue;
        JSpinner input = this.numYearsInput;
        BigDecimal years = new BigDecimal(input.getValue().toString());
        BigDecimal maxFactor = (BigDecimal)DecliningBalanceDepreciationStrategy.getSettingsCluster().getSettingValue("maxFactor");
        BigDecimal linearValue = Constants.ONEHUNDRED.divide(years, RoundingMode.DOWN).multiply(maxFactor).setScale(1, RoundingMode.UP);
        if (linearValue.compareTo(maxValue = (BigDecimal)DecliningBalanceDepreciationStrategy.getSettingsCluster().getSettingValue("maxValue")) < 0) {
            return linearValue.doubleValue();
        }
        return maxValue.doubleValue();
    }

    @Override
    public void saveDialogData() {
        if (this.strategy.getReceipt() != null) {
            this.strategy.getReceipt().setDepreciationStrategy(this.strategy);
        }
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleDepreciation");
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        int firstYear = this.strategy.getStartYear();
        int lastYear = this.strategy.getStartYear() + this.strategy.getNumYears();
        int current = Integer.parseInt(this.startLinearYearInput.getValue().toString());
        if (current > lastYear) {
            current = lastYear;
        }
        this.yearList = new ArrayList<String>();
        int i = firstYear;
        while (i <= lastYear) {
            this.yearList.add(String.valueOf(i));
            ++i;
        }
        this.startLinearYearModel.setList(this.yearList);
        this.startLinearYearInput.setValue(String.valueOf(current));
    }

    @Override
    public DepreciationStrategy getDepreciationStrategy() {
        return this.strategy;
    }
}

