/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.gui;

import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import javax.swing.Action;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public abstract class AbstractDepreciationEditor
extends AbstractStandardDialogPanel {
    protected Action okAction;
    protected JSpinner numYearsInput;

    public void setupNumYearsSpinner(int currentYear, DepreciationStrategy strategy) {
        SpinnerNumberModel snm = new SpinnerNumberModel();
        snm.setMinimum(Integer.valueOf(Math.min(strategy.getNumYears(), currentYear - strategy.getStartYear() + 1)));
        snm.setMaximum(Integer.valueOf(99));
        snm.setStepSize(1);
        snm.setValue(strategy.getNumYears());
        this.numYearsInput = new JSpinner(snm);
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleEditDepreciation");
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }

    public abstract DepreciationStrategy getDepreciationStrategy();
}

