/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.formatter;

import de.uwemock.eur.depreciation.formatter.ValueDepreciationFormatter;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlText;

public class ValueDepreciationLastYearFormatter
extends ValueDepreciationFormatter {
    public ValueDepreciationLastYearFormatter(int businessYear) {
        super(businessYear);
    }

    @Override
    public String getFormattedReceiptContentsAsText(Receipt r) {
        if (this.isLastYear(r)) {
            return super.getFormattedReceiptContentsAsText(r);
        }
        return "";
    }

    @Override
    public HtmlBodyElement getFormattedReceiptContentsAsHtml(Receipt r) {
        if (this.isLastYear(r)) {
            return super.getFormattedReceiptContentsAsHtml(r);
        }
        return new HtmlText("");
    }

    private boolean isLastYear(Receipt r) {
        return !r.getDepreciationStrategy().isDepreciatedInYear(this.getBusinessYear() + 1);
    }
}

