/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.formatter;

import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.depreciation.formatter.DepreciationFormatter;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.formatter.ReceiptContentsFormatter;
import java.math.BigDecimal;

public class ValueAtEndOfYearFormatter
extends DepreciationFormatter
implements ReceiptContentsFormatter {
    public ValueAtEndOfYearFormatter(int businessYear) {
        super(businessYear);
    }

    @Override
    public String getFormattedReceiptContentsAsText(Receipt r) {
        return this.getFormattedReceiptContents(r, false);
    }

    @Override
    protected String getFormattedReceiptContents(Receipt r, boolean addCurrency) {
        BigDecimal amount = this.getDepreciationInfo(r).getAmountEndOfYear();
        return LocalizationManager.amountToCurrencyString(amount, addCurrency);
    }

    @Override
    protected Object getReceiptInfo(Receipt r) {
        return null;
    }
}

