/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation.formatter;

import de.uwemock.eur.depreciation.DepreciationInfoRecord;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.formatter.ReceiptContentsFormatter;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlSimpleElement;

public abstract class DepreciationFormatter
implements ReceiptContentsFormatter {
    private final int businessYear;

    public DepreciationFormatter(int businessYear) {
        this.businessYear = businessYear;
    }

    public int getBusinessYear() {
        return this.businessYear;
    }

    public DepreciationInfoRecord getDepreciationInfo(Receipt r) {
        return r.getDepreciationStrategy().getInfoRecord(this.businessYear);
    }

    @Override
    public HtmlBodyElement getFormattedReceiptContentsAsHtml(Receipt r) {
        return new HtmlSimpleElement("span", null, "amount", null, this.getFormattedReceiptContents(r, true));
    }

    protected abstract String getFormattedReceiptContents(Receipt var1, boolean var2);

    protected Object getReceiptInfo(Receipt r) {
        return null;
    }
}

