/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation;

import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.AbstractDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationInfoRecord;
import de.uwemock.eur.depreciation.DepreciationRecord;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.gui.AbstractDepreciationEditor;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.settings.Setting;
import de.uwemock.settings.SettingsCluster;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class PoolDepreciationStrategy
extends AbstractDepreciationStrategy {
    public static final String XML_DEPRECIATION_ATT_TYPE_ATT = "pool";
    public static final String SETTING_MAX_YEARS = "numYears";
    private List<DepreciationRecord> depreciationChain = new ArrayList<DepreciationRecord>();
    private Map<Integer, DepreciationRecord> recordMap = new HashMap<Integer, DepreciationRecord>();
    private static SettingsCluster settings = new SettingsCluster(PoolDepreciationStrategy.class.getName());

    static {
        settings.addObserver(DataCenter.getInstance());
        settings.putSetting(new Setting<Integer>(SETTING_MAX_YEARS, 0, 100, 5, "Laufzeit ", "Jahre"));
        settings.putSetting(new Setting<Integer>("defaultAccount", null, null, 0, null, null));
    }

    private PoolDepreciationStrategy() {
        super(0, 0, null);
    }

    public PoolDepreciationStrategy(int startYear, int numYears, AbstractReceipt depreciationPool) {
        super(startYear, 0, depreciationPool);
        int i = 0;
        while (i < numYears) {
            this.addDepreciationRecord();
            ++i;
        }
        this.setupPoolDepreciation();
    }

    public PoolDepreciationStrategy(int startYear, AbstractReceipt depreciationPool) {
        super(startYear, 0, depreciationPool);
        int defaultNumYears = (Integer)settings.getSettingValue(SETTING_MAX_YEARS);
        int i = 0;
        while (i < defaultNumYears) {
            this.addDepreciationRecord();
            ++i;
        }
        this.setupPoolDepreciation();
    }

    public void addDepreciationRecord() {
        int year = this.depreciationChain.size() > 0 ? this.depreciationChain.get(this.depreciationChain.size() - 1).getYear() + 1 : this.startYear;
        DepreciationRecord dr = new DepreciationRecord(year, Constants.ZERO, Constants.ZERO);
        this.depreciationChain.add(dr);
        this.recordMap.put(year, dr);
        ++this.numYears;
    }

    private void addDepreciationRecord(DepreciationRecord dr) {
        if (this.depreciationChain.size() == 0 || dr.getYear() < this.startYear) {
            this.startYear = dr.getYear();
        }
        this.depreciationChain.add(dr);
        this.recordMap.put(dr.getYear(), dr);
        ++this.numYears;
    }

    public void removeLastDepreciationRecord() {
        if (this.numYears > 1) {
            DepreciationRecord drLast = this.depreciationChain.get(this.numYears - 1);
            DepreciationRecord drButLast = this.depreciationChain.get(this.numYears - 2);
            drButLast.setPercentAmount(drButLast.getPercentAmount().add(drLast.getPercentAmount()));
            drButLast.setPercentTax(drButLast.getPercentTax().add(drLast.getPercentTax()));
            this.depreciationChain.remove(this.numYears - 1);
            this.recordMap.remove(drLast.getYear());
            --this.numYears;
        }
    }

    public void setupPoolDepreciation() {
        this.setupDefaultAmountDepreciation();
        this.setupDefaultTaxDepreciation();
    }

    public void setupDefaultAmountDepreciation() {
        BigDecimal rest = Constants.ONEHUNDRED;
        BigDecimal perYear = Constants.ONEHUNDRED.divide(new BigDecimal(this.numYears), 2, RoundingMode.DOWN);
        int i = 0;
        while (i < this.numYears - 1) {
            this.depreciationChain.get(i).setPercentAmount(perYear);
            rest = rest.subtract(perYear);
            ++i;
        }
        this.depreciationChain.get(this.numYears - 1).setPercentAmount(rest);
    }

    public void setupDefaultTaxDepreciation() {
        int i = 1;
        while (i < this.numYears) {
            this.depreciationChain.get(i).setPercentTax(Constants.ZERO);
            ++i;
        }
        this.depreciationChain.get(0).setPercentTax(Constants.ONEHUNDRED);
    }

    public void calculateLastYear() {
        BigDecimal restAmount = Constants.ONEHUNDRED;
        BigDecimal restTax = Constants.ONEHUNDRED;
        int i = 0;
        while (i < this.numYears - 1) {
            restAmount = restAmount.subtract(this.depreciationChain.get(i).getPercentAmount());
            restTax = restTax.subtract(this.depreciationChain.get(i).getPercentTax());
            ++i;
        }
        this.depreciationChain.get(this.numYears - 1).setPercentAmount(restAmount);
        this.depreciationChain.get(this.numYears - 1).setPercentTax(restTax);
    }

    public List<DepreciationRecord> getDepreciationChain() {
        return this.depreciationChain;
    }

    public void setPercentAmount(int year, BigDecimal percent) {
        DepreciationRecord dr = this.recordMap.get(year);
        if (dr != null) {
            dr.setPercentAmount(percent);
        }
    }

    public void setPercentTax(int year, BigDecimal percent) {
        DepreciationRecord dr = this.recordMap.get(year);
        if (dr != null) {
            dr.setPercentTax(percent);
        }
    }

    public String toString() {
        String s = "Pool decpreciation\n" + super.toString();
        return s;
    }

    public DepreciationRecord getDepreciationRecord(int index) {
        if (index >= 0 && index < this.depreciationChain.size()) {
            return this.depreciationChain.get(index);
        }
        return null;
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("depreciationplan");
        writer.writeAttribute("type", XML_DEPRECIATION_ATT_TYPE_ATT);
        for (DepreciationRecord dr : this.depreciationChain) {
            dr.writeToXml(writer);
        }
        writer.writeEndElement();
    }

    public static DepreciationStrategy readFromXML(XMLStreamReader reader) throws XMLStreamException {
        if (!(reader.isStartElement() && reader.hasName() && reader.getName().toString().equals("depreciationplan"))) {
            return null;
        }
        if (!XmlTools.getOneSingleAttributeValue(reader, "type").equals(XML_DEPRECIATION_ATT_TYPE_ATT)) {
            return null;
        }
        PoolDepreciationStrategy ds = new PoolDepreciationStrategy();
        while (reader.hasNext()) {
            DepreciationRecord dr;
            reader.next();
            if (XmlTools.isEndElement(reader, "depreciationplan")) break;
            if (!XmlTools.isStartElement(reader, "record") || (dr = DepreciationRecord.readFromXML(reader)) == null) continue;
            ds.addDepreciationRecord(dr);
        }
        if (ds.getNumYears() == 0) {
            return null;
        }
        return ds;
    }

    private BigDecimal getAmountDepreciatedInYear(int year, BigDecimal originalAmount) {
        DepreciationRecord dr = this.recordMap.get(year);
        if (dr == null) {
            return Constants.ZERO;
        }
        BigDecimal percent = dr.getPercentAmount();
        return originalAmount.multiply(percent).divide(Constants.ONEHUNDRED, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_EVEN);
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public static boolean hasXmlTypeAttribute(String attribute) {
        return XML_DEPRECIATION_ATT_TYPE_ATT.equals(attribute);
    }

    @Override
    public boolean hasExtraDepreciation() {
        return false;
    }

    @Override
    public boolean canHaveExtraDepreciation() {
        return false;
    }

    @Override
    public ExtraDepreciation getExtraDepreciation() {
        return null;
    }

    @Override
    public void setExtraDepreciation(ExtraDepreciation extraDepreciation) {
    }

    @Override
    public DepreciationStrategy getCopy() {
        return null;
    }

    @Override
    public DepreciationInfoRecord getInfoRecord(int year) {
        BigDecimal originalAmount;
        BigDecimal amountStartOfYear = originalAmount = (BigDecimal)this.getReceipt().getReceiptInfo(6);
        int i = this.getStartYear();
        while (i < year) {
            amountStartOfYear = amountStartOfYear.subtract(this.getAmountDepreciatedInYear(i, originalAmount));
            ++i;
        }
        BigDecimal extraDepreciation = Constants.ZERO;
        BigDecimal depreciation = this.getAmountDepreciatedInYear(year, originalAmount);
        BigDecimal amountEndOfYear = amountStartOfYear.subtract(depreciation);
        return new DepreciationInfoRecord(year, originalAmount, amountStartOfYear, extraDepreciation, depreciation, amountEndOfYear);
    }

    public static SettingsCluster getSettingsCluster() {
        return settings;
    }

    @Override
    public AbstractDepreciationEditor getDepreciationEditor(int currentYear, AbstractReceipt receipt) {
        return null;
    }
}

