/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation;

import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DepreciationStub;
import de.uwemock.settings.Setting;
import de.uwemock.settings.SettingsCluster;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.Attribute;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ExtraDepreciation
extends DepreciationStub {
    public static final String SETTING_MAX_VALUE = "maxValue";
    public static final String SETTING_MAX_YEARS = "maxYears";
    public static final String XML_EXTRA_DEPRECIATION = "extradepreciation";
    private static final String XML_EXTRA_DEPRECIATION_ACCOUNT_ATT = "account";
    private static final String XML_EXTRA_DEPRECIATION_PERCENT = "percent";
    private static final String XML_EXTRA_DEPRECIATION_YEAR_ATT = "year";
    private static final String XML_EXTRA_DEPRECIATION_RECALCULATE = "recalculate";
    private Map<Integer, BigDecimal> yearMap = new HashMap<Integer, BigDecimal>();
    private int startYear;
    private int numYears;
    private int account;
    private boolean recalculate = true;
    private static SettingsCluster settings = new SettingsCluster(ExtraDepreciation.class.getName());

    static {
        settings.addObserver(DataCenter.getInstance());
        settings.putSetting(new Setting<BigDecimal>(SETTING_MAX_VALUE, Numbers.BIG_DECIMAL_ZERO, Numbers.BIG_DECIMAL_ONEHUNDRED, new BigDecimal(20), "Gesamtprozentsatz maximal:", ""));
        settings.putSetting(new Setting<Integer>(SETTING_MAX_YEARS, 0, 100, 5, "Laufzeit maximal", "Jahre"));
        settings.putSetting(new Setting<Integer>("defaultAccount", null, null, 0, null, null));
    }

    public ExtraDepreciation(int startYear) {
        this.startYear = startYear;
        this.numYears = (Integer)ExtraDepreciation.getSettingsCluster().getSettingValue(SETTING_MAX_YEARS);
        int i = startYear;
        while (i < startYear + this.numYears) {
            this.yearMap.put(i, Constants.ZERO);
            ++i;
        }
    }

    public ExtraDepreciation(XMLStreamReader reader) throws XMLStreamException {
        if (!(reader.isStartElement() && reader.hasName() && reader.getName().toString().equals(XML_EXTRA_DEPRECIATION))) {
            throw new XMLStreamException();
        }
        this.account = Numbers.getIntFromString(XmlTools.getOneSingleAttributeValue(reader, XML_EXTRA_DEPRECIATION_ACCOUNT_ATT), 0);
        if (this.account == 0) {
            this.account = Numbers.getIntFromString(XmlTools.getOneSingleAttributeValue(reader, XML_EXTRA_DEPRECIATION_PERCENT), 0);
        }
        while (reader.hasNext()) {
            reader.next();
            if (XmlTools.isEndElement(reader, XML_EXTRA_DEPRECIATION)) break;
            if (XmlTools.isStartElement(reader, XML_EXTRA_DEPRECIATION_PERCENT)) {
                Integer year = Numbers.getIntFromString(XmlTools.getOneSingleAttributeValue(reader, XML_EXTRA_DEPRECIATION_YEAR_ATT), 0);
                BigDecimal percent = Numbers.getBigDecimalFromString(reader.getElementText(), null);
                ++this.numYears;
                this.yearMap.put(year, percent.setScale(2, RoundingMode.HALF_EVEN));
                if (this.startYear == 0 || year < this.startYear) {
                    this.startYear = year;
                }
            }
            if (!XmlTools.isStartElement(reader, XML_EXTRA_DEPRECIATION_RECALCULATE)) continue;
            this.setRecalculate(Numbers.getBooleanFromString(reader.getElementText(), true));
        }
    }

    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_EXTRA_DEPRECIATION);
        writer.writeAttribute(XML_EXTRA_DEPRECIATION_ACCOUNT_ATT, Integer.toString(this.account));
        Set<Integer> years = this.yearMap.keySet();
        for (Integer year : years) {
            String percent = this.getPercentForYear(year).toPlainString();
            Attribute attr = new Attribute(XML_EXTRA_DEPRECIATION_YEAR_ATT, year);
            XmlTools.writeXmlElement(writer, XML_EXTRA_DEPRECIATION_PERCENT, percent, attr);
        }
        XmlTools.writeXmlElement(writer, XML_EXTRA_DEPRECIATION_RECALCULATE, this.doRecalculate(), null);
        writer.writeEndElement();
    }

    public int getNumYears() {
        return this.numYears;
    }

    public void setNumYears(int numYears) {
        int i;
        if (this.numYears > numYears) {
            i = this.startYear + numYears;
            while (i < this.startYear + this.numYears) {
                this.yearMap.remove(i);
                ++i;
            }
        }
        if (this.numYears < numYears) {
            i = this.startYear + this.numYears;
            while (i < this.startYear + numYears) {
                this.yearMap.put(i, Constants.ZERO);
                ++i;
            }
        }
        this.numYears = numYears;
        this.setChanged();
        this.notifyObservers();
    }

    public BigDecimal getPercentForYear(int year) {
        BigDecimal res = this.yearMap.get(year);
        if (res == null) {
            return Constants.ZERO.setScale(2, RoundingMode.HALF_EVEN);
        }
        return res;
    }

    public void setPercentForYear(int year, BigDecimal percent) {
        percent = percent.setScale(2, RoundingMode.DOWN);
        Integer yearAsInteger = year;
        if (this.yearMap.get(yearAsInteger) != null) {
            this.yearMap.put(yearAsInteger, percent);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public BigDecimal getTotalPercent() {
        BigDecimal res = Constants.ZERO;
        for (Integer year : this.yearMap.keySet()) {
            BigDecimal percent = this.yearMap.get(year);
            res = res.add(percent);
        }
        return res;
    }

    public void removeYear(int year) {
        this.yearMap.remove(year);
        this.setChanged();
        this.notifyObservers();
    }

    public int getStartYear() {
        return this.startYear;
    }

    public int getAccount() {
        return this.account;
    }

    public void setAccount(int account) {
        this.account = account;
    }

    public boolean doRecalculate() {
        return this.recalculate;
    }

    public void setRecalculate(boolean recalculate) {
        this.recalculate = recalculate;
        this.setChanged();
        this.notifyObservers();
    }

    public ExtraDepreciation getCopy() {
        ExtraDepreciation res = new ExtraDepreciation(this.getStartYear());
        Set<Integer> keys = this.yearMap.keySet();
        for (Integer i : keys) {
            res.yearMap.put(i, this.yearMap.get(i));
        }
        res.setAccount(this.getAccount());
        res.setRecalculate(this.doRecalculate());
        res.setNumYears(this.getNumYears());
        return res;
    }

    public static SettingsCluster getSettingsCluster() {
        return settings;
    }
}

