/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation;

import de.uwemock.eur.data.Constants;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DepreciationRecord {
    protected static final String XML_DEPRECIATION_RECORD = "record";
    private static final String XML_DEPRECIATION_RECORD_YEAR = "year";
    private static final String XML_DEPRECIATION_RECORD_AMOUNT = "percentamount";
    private static final String XML_DEPRECIATION_RECORD_TAX = "percenttax";
    private static final String XML_DEPRECIATION_RECORD_MONTHS = "months";
    private int year;
    private BigDecimal percentTax;
    private BigDecimal percentAmount;
    private int months = 12;

    public DepreciationRecord(int year, BigDecimal percentTax, BigDecimal percentAmount) {
        this.year = year;
        this.percentTax = percentTax != null ? percentTax.setScale(2, RoundingMode.HALF_EVEN) : Constants.ZERO.setScale(2, RoundingMode.HALF_EVEN);
        this.percentAmount = percentAmount != null ? percentAmount.setScale(2, RoundingMode.HALF_EVEN) : Constants.ZERO.setScale(2, RoundingMode.HALF_EVEN);
    }

    public DepreciationRecord(int year, int months, BigDecimal percentTax, BigDecimal percentAmount) {
        this(year, percentTax, percentAmount);
        this.setMonths(months);
    }

    public int getYear() {
        return this.year;
    }

    void setYear(int year) {
        this.year = year;
    }

    public BigDecimal getPercentTax() {
        return this.percentTax;
    }

    public void setPercentTax(BigDecimal percentTax) {
        this.percentTax = percentTax.setScale(2, RoundingMode.HALF_EVEN);
    }

    public BigDecimal getPercentAmount() {
        return this.percentAmount;
    }

    public void setPercentAmount(BigDecimal percentAmount) {
        this.percentAmount = percentAmount.setScale(2, RoundingMode.HALF_EVEN);
    }

    public int getMonths() {
        return this.months;
    }

    public void setMonths(int months) {
        if (months >= 0 && months <= 12) {
            this.months = months;
        }
    }

    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_DEPRECIATION_RECORD);
        XmlTools.writeXmlElement(writer, XML_DEPRECIATION_RECORD_YEAR, this.year, null);
        XmlTools.writeXmlElement(writer, XML_DEPRECIATION_RECORD_AMOUNT, this.percentAmount.toPlainString(), null);
        XmlTools.writeXmlElement(writer, XML_DEPRECIATION_RECORD_TAX, this.percentTax.toPlainString(), null);
        XmlTools.writeXmlElement(writer, XML_DEPRECIATION_RECORD_MONTHS, this.months, null);
        writer.writeEndElement();
    }

    public static DepreciationRecord readFromXML(XMLStreamReader reader) throws XMLStreamException {
        if (!(reader.isStartElement() && reader.hasName() && reader.getName().toString().equals(XML_DEPRECIATION_RECORD))) {
            return null;
        }
        int year = -1;
        BigDecimal percentAmount = null;
        BigDecimal percentTax = null;
        int months = -1;
        while (reader.hasNext()) {
            reader.next();
            if (XmlTools.isEndElement(reader, XML_DEPRECIATION_RECORD)) break;
            if (XmlTools.isStartElement(reader, XML_DEPRECIATION_RECORD_YEAR)) {
                year = Numbers.getIntFromString(reader.getElementText(), -1);
            }
            if (XmlTools.isStartElement(reader, XML_DEPRECIATION_RECORD_AMOUNT)) {
                percentAmount = Numbers.getBigDecimalFromString(reader.getElementText(), null);
            }
            if (XmlTools.isStartElement(reader, XML_DEPRECIATION_RECORD_TAX)) {
                percentTax = Numbers.getBigDecimalFromString(reader.getElementText(), null);
            }
            if (!XmlTools.isStartElement(reader, XML_DEPRECIATION_RECORD_MONTHS)) continue;
            months = Numbers.getIntFromString(reader.getElementText(), 12);
        }
        if (year < 0 || percentAmount == null || percentTax == null) {
            return null;
        }
        return new DepreciationRecord(year, months, percentTax, percentAmount);
    }
}

