/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation;

import de.uwemock.eur.depreciation.DecliningBalanceDepreciationStrategy;
import de.uwemock.eur.depreciation.DefaultDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.receipt.ReceiptFactory;
import de.uwemock.tools.LoggingManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DepreciationFactory {
    private static Class[] knownDepreciationTypes = new Class[]{DefaultDepreciationStrategy.class, DecliningBalanceDepreciationStrategy.class, PoolDepreciationStrategy.class};

    private DepreciationFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DepreciationStrategy readFromXml(XMLStreamReader reader, String type) throws XMLStreamException {
        Logger logger = Logger.getLogger(ReceiptFactory.class.getName());
        Class[] classArray = knownDepreciationTypes;
        int n = knownDepreciationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Class depreciationStrategyClass = classArray[n2];
                Method hasXmlTypeAttribute = null;
                try {
                    hasXmlTypeAttribute = depreciationStrategyClass.getMethod("hasXmlTypeAttribute", String.class);
                }
                catch (SecurityException e) {
                    LoggingManager.logException(ReceiptFactory.class, e);
                }
                catch (NoSuchMethodException e) {
                    logger.severe("Class " + depreciationStrategyClass.getName() + " has no hasXmlTypeAttribute() method!");
                }
                if (hasXmlTypeAttribute != null) {
                    try {
                        Boolean isRightClass = (Boolean)hasXmlTypeAttribute.invoke(null, type);
                        if (!isRightClass.booleanValue()) break block12;
                        logger.finer("-> -> depreciation strategy of class " + depreciationStrategyClass.getName());
                        Method readFromXML = null;
                        try {
                            readFromXML = depreciationStrategyClass.getMethod("readFromXML", XMLStreamReader.class);
                            return (DepreciationStrategy)readFromXML.invoke(null, reader);
                        }
                        catch (SecurityException e) {
                            LoggingManager.logException(ReceiptFactory.class, e);
                            return null;
                        }
                        catch (NoSuchMethodException e) {
                            logger.severe("Class " + depreciationStrategyClass.getName() + " has no readFromXML() method!");
                            return null;
                        }
                    }
                    catch (InvocationTargetException e) {
                        Throwable eTarget = e.getTargetException();
                        LoggingManager.logException(ReceiptFactory.class, eTarget);
                        if (eTarget instanceof XMLStreamException) {
                            throw (XMLStreamException)eTarget;
                        }
                    }
                    catch (Exception e) {
                        LoggingManager.logException(ReceiptFactory.class, e);
                    }
                }
            }
            ++n2;
        }
        return null;
    }
}

