/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.AbstractDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationInfoRecord;
import de.uwemock.eur.depreciation.DepreciationRecord;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.gui.AbstractDepreciationEditor;
import de.uwemock.eur.depreciation.gui.DefaultDepreciationEditPanel;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.settings.Setting;
import de.uwemock.settings.SettingsCluster;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DefaultDepreciationStrategy
extends AbstractDepreciationStrategy {
    public static final String XML_DEPRECIATION_ATT_TYPE_ATT = "default";
    private int startMonth;
    private DepreciationRecord extraYearRecord;
    private List<DepreciationRecord> depreciationChain = new ArrayList<DepreciationRecord>();
    private Map<Integer, DepreciationRecord> recordMap = new HashMap<Integer, DepreciationRecord>();
    private Map<Integer, DepreciationInfoRecord> infoRecords = new HashMap<Integer, DepreciationInfoRecord>();
    private static SettingsCluster settings = new SettingsCluster(DefaultDepreciationStrategy.class.getName());

    static {
        settings.addObserver(DataCenter.getInstance());
        settings.putSetting(new Setting<Integer>("defaultAccount", null, null, 0, null, null));
    }

    private DefaultDepreciationStrategy() {
        super(0, 0, null);
    }

    public DefaultDepreciationStrategy(int startYear, int numYears, AbstractReceipt receipt, Date originalReceiptDate) {
        super(startYear, numYears, null);
        if (receipt != null) {
            this.startMonth = receipt.getDate().getMonth();
            this.setReceipt(receipt);
        }
        if (originalReceiptDate != null) {
            this.setStartMonth(originalReceiptDate.getMonth());
        }
        this.setupDefaultDepreciation();
        this.originalReceiptDate = originalReceiptDate;
    }

    public DefaultDepreciationStrategy(int startYear, int numYears, AbstractReceipt receipt) {
        this(startYear, numYears, receipt, receipt.getDate());
    }

    private void createDepreciationChain() {
        this.depreciationChain.clear();
        this.recordMap.clear();
        this.extraYearRecord = null;
        int i = 0;
        int year = this.getOriginalReceiptDate().getYear();
        while (i < this.numYears) {
            DepreciationRecord dr = new DepreciationRecord(year, Constants.ZERO, Constants.ZERO);
            this.depreciationChain.add(dr);
            this.recordMap.put(year, dr);
            ++i;
            ++year;
        }
        this.extraYearRecord = new DepreciationRecord(this.startYear + this.numYears, Constants.ZERO, Constants.ZERO);
        this.depreciationChain.add(this.extraYearRecord);
        this.recordMap.put(this.startYear + this.numYears, this.extraYearRecord);
    }

    public void addDepreciationRecord() {
        if (this.extraYearRecord != null) {
            this.depreciationChain.remove(this.extraYearRecord);
            this.recordMap.remove(this.extraYearRecord.getYear());
        }
        int year = this.depreciationChain.size() > 0 ? this.depreciationChain.get(this.depreciationChain.size() - 1).getYear() + 1 : this.originalReceiptDate.getYear();
        DepreciationRecord dr = new DepreciationRecord(year, Constants.ZERO, Constants.ZERO);
        this.depreciationChain.add(dr);
        this.recordMap.put(year, dr);
        ++this.numYears;
        if (this.extraYearRecord != null) {
            this.extraYearRecord.setYear(year + 1);
            this.depreciationChain.add(this.extraYearRecord);
            this.recordMap.put(year + 1, this.extraYearRecord);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void removeLastDepreciationRecord() {
        if (this.numYears > 1) {
            DepreciationRecord drLast = this.depreciationChain.get(this.numYears - 1);
            DepreciationRecord drButLast = this.depreciationChain.get(this.numYears - 2);
            drButLast.setPercentAmount(drButLast.getPercentAmount().add(drLast.getPercentAmount()));
            drButLast.setPercentTax(drButLast.getPercentTax().add(drLast.getPercentTax()));
            this.depreciationChain.remove(this.numYears - 1);
            this.recordMap.remove(drLast.getYear());
            if (this.extraYearRecord != null) {
                this.recordMap.remove(this.extraYearRecord.getYear());
                this.extraYearRecord.setYear(this.extraYearRecord.getYear() - 1);
                this.extraYearRecord.setPercentAmount(this.depreciationChain.get(0).getPercentAmount());
                this.recordMap.put(this.extraYearRecord.getYear(), this.extraYearRecord);
            }
            --this.numYears;
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void setupDefaultDepreciation() {
        this.createDepreciationChain();
        this.setupDefaultAmountDepreciation();
        this.setupDefaultTaxDepreciation();
    }

    public void setupDefaultAmountDepreciation() {
        if (this.numYears == 0) {
            return;
        }
        BigDecimal rest = Constants.ONEHUNDRED;
        BigDecimal perYear = Constants.ONEHUNDRED.divide(new BigDecimal(this.numYears), 2, RoundingMode.DOWN);
        int i = 0;
        while (i < this.numYears - 1) {
            this.depreciationChain.get(i).setPercentAmount(perYear);
            rest = rest.subtract(perYear);
            ++i;
        }
        this.depreciationChain.get(this.numYears - 1).setPercentAmount(rest);
        this.extraYearRecord.setPercentAmount(this.depreciationChain.get(0).getPercentAmount());
        this.depreciationChain.get(0).setMonths(12 - this.startMonth + 1);
        this.extraYearRecord.setMonths(this.startMonth - 1);
        this.setReceiptChanged();
        this.setChanged();
        this.notifyObservers();
    }

    public void setupLinearTaxDepreciation() {
        BigDecimal rest = Constants.ONEHUNDRED;
        BigDecimal perYear = Constants.ONEHUNDRED.divide(new BigDecimal(this.numYears), 2, RoundingMode.DOWN);
        int i = 0;
        while (i < this.numYears - 1) {
            this.depreciationChain.get(i).setPercentTax(perYear);
            rest = rest.subtract(perYear);
            ++i;
        }
        this.depreciationChain.get(this.numYears - 1).setPercentTax(rest);
        this.extraYearRecord.setPercentTax(Constants.ZERO);
        this.setReceiptChanged();
        this.setChanged();
        this.notifyObservers();
    }

    public void setupDefaultTaxDepreciation() {
        if (this.numYears == 0) {
            return;
        }
        int i = 1;
        while (i < this.numYears) {
            this.depreciationChain.get(i).setPercentTax(Constants.ZERO);
            ++i;
        }
        this.depreciationChain.get(0).setPercentTax(Constants.ONEHUNDRED);
        this.extraYearRecord.setPercentTax(Constants.ZERO);
        this.setReceiptChanged();
        this.setChanged();
        this.notifyObservers();
    }

    public void calculateLastYear() {
        BigDecimal restAmount = Constants.ONEHUNDRED;
        BigDecimal restTax = Constants.ONEHUNDRED;
        int i = 0;
        while (i < this.numYears - 1) {
            restAmount = restAmount.subtract(this.depreciationChain.get(i).getPercentAmount());
            restTax = restTax.subtract(this.depreciationChain.get(i).getPercentTax());
            ++i;
        }
        this.depreciationChain.get(this.numYears - 1).setPercentAmount(restAmount);
        this.depreciationChain.get(this.numYears - 1).setPercentTax(restTax);
    }

    @Override
    public void setOriginalReceiptDate(Date date) {
        super.setOriginalReceiptDate(date);
        this.setStartMonth(date.getMonth());
        this.setupDefaultDepreciation();
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void setOriginalReceiptDate(int year, int month, int day) {
        this.setOriginalReceiptDate(Date.getDate(year, month, day));
    }

    public int getStartMonth() {
        return this.startMonth;
    }

    public void setStartMonth(int startMonth) {
        this.startMonth = startMonth;
        if (this.depreciationChain.size() > 0) {
            this.depreciationChain.get(0).setMonths(12 - startMonth + 1);
            this.depreciationChain.get(this.numYears).setMonths(startMonth - 1);
        }
        this.setReceiptChanged();
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public boolean isDepreciatedInYear(int year) {
        return year >= this.originalReceiptDate.getYear() && year <= this.originalReceiptDate.getYear() + this.numYears;
    }

    public void setPercentTax(int year, BigDecimal percent) {
        DepreciationRecord dr = this.recordMap.get(year);
        if (dr != null) {
            dr.setPercentTax(percent);
            this.setReceiptChanged();
        }
        this.invalidateInfoRecords();
        this.setChanged();
        this.notifyObservers();
    }

    public BigDecimal getPercentTax(int year) {
        return this.recordMap.get(year).getPercentTax();
    }

    public void setPercentAmount(int year, BigDecimal percent) {
        DepreciationRecord dr = this.recordMap.get(year);
        if (dr != null) {
            dr.setPercentAmount(percent);
            this.setReceiptChanged();
        }
        if (year == this.getStartYear() && this.extraYearRecord != null) {
            this.extraYearRecord.setPercentAmount(percent);
        }
        this.invalidateInfoRecords();
    }

    public BigDecimal getPercentAmount(int year) {
        return this.recordMap.get(year).getPercentAmount();
    }

    @Override
    public void setReceipt(AbstractReceipt receipt) {
        super.setReceipt(receipt);
        this.invalidateInfoRecords();
    }

    private void addDepreciationRecord(DepreciationRecord dr) {
        this.depreciationChain.add(dr);
        this.recordMap.put(dr.getYear(), dr);
        this.extraYearRecord = dr;
        ++this.numYears;
        if (this.startYear == 0 || dr.getYear() < this.startYear) {
            this.startYear = dr.getYear();
        }
        this.setReceiptChanged();
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("depreciationplan");
        writer.writeAttribute("type", XML_DEPRECIATION_ATT_TYPE_ATT);
        this.originalReceiptDate.writeToXml(writer);
        for (DepreciationRecord dr : this.depreciationChain) {
            dr.writeToXml(writer);
        }
        if (this.hasExtraDepreciation()) {
            this.getExtraDepreciation().writeToXml(writer);
        }
        writer.writeEndElement();
    }

    public static DepreciationStrategy readFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger(DefaultDepreciationStrategy.class.getName());
        if (!(reader.isStartElement() && reader.hasName() && reader.getName().toString().equals("depreciationplan"))) {
            return null;
        }
        if (!XmlTools.getOneSingleAttributeValue(reader, "type").equals(XML_DEPRECIATION_ATT_TYPE_ATT)) {
            return null;
        }
        DefaultDepreciationStrategy ds = new DefaultDepreciationStrategy();
        while (reader.hasNext()) {
            ExtraDepreciation ed;
            DepreciationRecord dr;
            reader.next();
            if (XmlTools.isEndElement(reader, "depreciationplan")) break;
            if (XmlTools.isStartElement(reader, "date")) {
                ds.originalReceiptDate = Date.readFromXml(reader);
            }
            if (XmlTools.isStartElement(reader, "record") && (dr = DepreciationRecord.readFromXML(reader)) != null) {
                ds.addDepreciationRecord(dr);
            }
            if (!XmlTools.isStartElement(reader, "extradepreciation") || (ed = new ExtraDepreciation(reader)) == null) continue;
            ds.setExtraDepreciation(ed);
        }
        ds.numYears = ds.numYears - 1;
        if (ds.getNumYears() == 0 || ds.getOriginalReceiptDate() == null) {
            String message = "Error reading depreciation from XML: missing";
            if (ds.getNumYears() == 0) {
                message = String.valueOf(message) + " numYears";
            }
            if (ds.getOriginalReceiptDate() == null) {
                message = String.valueOf(message) + " originalReceiptDate";
            }
            logger.fine(message);
            return null;
        }
        return ds;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.originalReceiptDate.getYear() == this.getReceipt().getDate().getYear()) {
            this.originalReceiptDate = this.getReceipt().getDate();
            this.setStartMonth(this.originalReceiptDate.getMonth());
        }
        this.invalidateInfoRecords();
    }

    private BigDecimal getAmountDepreciatedInYear(int year, BigDecimal originalAmount) {
        DepreciationRecord dr = this.recordMap.get(year);
        if (dr == null) {
            return Constants.ZERO;
        }
        if (this.getStartYear() + this.numYears == year) {
            BigDecimal remainingAmount = originalAmount;
            int i = 0;
            while (i < this.numYears) {
                remainingAmount = remainingAmount.subtract(this.getAmountDepreciatedInYear(this.getStartYear() + i, originalAmount));
                ++i;
            }
            return remainingAmount;
        }
        BigDecimal percent = dr.getPercentAmount();
        if (dr.getMonths() != 12) {
            percent = percent.multiply(new BigDecimal(dr.getMonths())).divide(new BigDecimal(12), 4, RoundingMode.HALF_EVEN);
        }
        return originalAmount.multiply(percent).divide(Constants.ONEHUNDRED, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Linear decpreciation " + super.toString() + "\n");
        for (DepreciationRecord dr : this.depreciationChain) {
            s.append(String.format("%d - %d - %f - %f\n", dr.getYear(), dr.getMonths(), dr.getPercentTax(), dr.getPercentAmount()));
        }
        return s.toString();
    }

    public static boolean hasXmlTypeAttribute(String attribute) {
        return XML_DEPRECIATION_ATT_TYPE_ATT.equals(attribute);
    }

    @Override
    public boolean canHaveExtraDepreciation() {
        return true;
    }

    @Override
    public void setExtraDepreciation(ExtraDepreciation extraDepreciation) {
        super.setExtraDepreciation(extraDepreciation);
        this.invalidateInfoRecords();
    }

    public DepreciationRecord getDepreciationRecord(int index) {
        return this.depreciationChain.get(index);
    }

    @Override
    public DepreciationStrategy getCopy() {
        DefaultDepreciationStrategy res = new DefaultDepreciationStrategy();
        res.setReceipt(this.getReceipt());
        res.originalReceiptDate = this.getOriginalReceiptDate();
        for (DepreciationRecord dr : this.depreciationChain) {
            DepreciationRecord newRecord = new DepreciationRecord(dr.getYear(), dr.getMonths(), dr.getPercentTax(), dr.getPercentAmount());
            res.addDepreciationRecord(newRecord);
        }
        res.extraYearRecord = res.getDepreciationRecord(res.numYears - 1);
        res.numYears = res.numYears - 1;
        if (this.hasExtraDepreciation()) {
            res.setExtraDepreciation(this.getExtraDepreciation().getCopy());
        }
        return res;
    }

    private void invalidateInfoRecords() {
        if (this.infoRecords != null) {
            this.infoRecords.clear();
        }
    }

    private void calculateInfoRecords() {
        int year;
        BigDecimal originalAmount = (BigDecimal)this.getReceipt().getReceiptInfo(6);
        BigDecimal amountStartOfYear = Constants.ZERO;
        BigDecimal extraDepreciation = Constants.ZERO;
        BigDecimal depreciation = Constants.ZERO;
        BigDecimal amountEndOfYear = originalAmount;
        BigDecimal totalPercentAfterExtraDepreciation = Constants.ZERO;
        int totalMonthsAfterExtraDepreciation = 0;
        BigDecimal oneYearPercentAfterExtraDepreciation = Constants.ZERO;
        BigDecimal remainingAmountAfterExtraDepreciation = Constants.ZERO;
        if (this.hasExtraDepreciation() && this.getExtraDepreciation().doRecalculate()) {
            year = this.getStartYear() + this.getExtraDepreciation().getNumYears();
            while (year <= this.getStartYear() + this.getNumYears()) {
                totalMonthsAfterExtraDepreciation += this.getDepreciationRecord(year - this.getStartYear()).getMonths();
                totalPercentAfterExtraDepreciation = totalPercentAfterExtraDepreciation.add(this.getPercentAmount(year));
                ++year;
            }
            oneYearPercentAfterExtraDepreciation = totalMonthsAfterExtraDepreciation > 0 ? totalPercentAfterExtraDepreciation.multiply(new BigDecimal(12)).divide(new BigDecimal(totalMonthsAfterExtraDepreciation), RoundingMode.HALF_EVEN) : Constants.ZERO;
        }
        year = this.getStartYear();
        while (year <= this.getStartYear() + this.getNumYears() + 1) {
            amountStartOfYear = amountEndOfYear;
            extraDepreciation = Constants.ZERO.setScale(2, RoundingMode.HALF_EVEN);
            if (this.hasExtraDepreciation()) {
                extraDepreciation = originalAmount.multiply(this.getExtraDepreciation().getPercentForYear(year)).divide(Constants.ONEHUNDRED, 2, RoundingMode.HALF_EVEN);
            }
            depreciation = this.getAmountDepreciatedInYear(year, originalAmount);
            if (this.hasExtraDepreciation() && this.getExtraDepreciation().doRecalculate() && Numbers.isPositive(oneYearPercentAfterExtraDepreciation)) {
                if (year == this.getStartYear() + this.getExtraDepreciation().getNumYears()) {
                    remainingAmountAfterExtraDepreciation = amountStartOfYear;
                }
                if (year >= this.getStartYear() + this.getExtraDepreciation().getNumYears()) {
                    depreciation = remainingAmountAfterExtraDepreciation.multiply(oneYearPercentAfterExtraDepreciation).divide(totalPercentAfterExtraDepreciation, 2, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.DOWN);
                }
            }
            if (depreciation.compareTo(amountStartOfYear) > 0) {
                depreciation = amountStartOfYear;
            }
            amountEndOfYear = amountStartOfYear.subtract(depreciation).subtract(extraDepreciation);
            this.infoRecords.put(year, new DepreciationInfoRecord(year, originalAmount, amountStartOfYear, extraDepreciation, depreciation, amountEndOfYear));
            ++year;
        }
    }

    @Override
    public DepreciationInfoRecord getInfoRecord(int year) {
        DepreciationInfoRecord infoRecord;
        if (this.getReceipt().hasChanged()) {
            this.invalidateInfoRecords();
            this.calculateInfoRecords();
        }
        if ((infoRecord = this.infoRecords.get(year)) == null) {
            this.calculateInfoRecords();
            infoRecord = this.infoRecords.get(year);
        }
        return infoRecord;
    }

    public static SettingsCluster getSettingsCluster() {
        return settings;
    }

    @Override
    public AbstractDepreciationEditor getDepreciationEditor(int currentYear, AbstractReceipt receipt) {
        return new DefaultDepreciationEditPanel(currentYear, this, receipt);
    }
}

