/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.AbstractDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationInfoRecord;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.gui.AbstractDepreciationEditor;
import de.uwemock.eur.depreciation.gui.DecliningBalanceDepreciationEditPanel;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.settings.Setting;
import de.uwemock.settings.SettingsCluster;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DecliningBalanceDepreciationStrategy
extends AbstractDepreciationStrategy {
    public static final String SETTING_MAX_VALUE = "maxValue";
    public static final String SETTING_MAX_FACTOR = "maxFactor";
    public static final String XML_DEPRECIATION_ATT_TYPE_ATT = "declining";
    private static final String XML_DEPRECIATION_START_YEAR = "startyear";
    private static final String XML_DEPRECIATION_START_YEAR_LINEAR = "startyearlinear";
    private static final String XML_DEPRECIATION_NUM_YEARS = "numyears";
    private static final String XML_DEPRECIATION_PERCENT = "percent";
    private int startYearLinear;
    private BigDecimal percent;
    private Map<Integer, DepreciationInfoRecord> infoRecords = new HashMap<Integer, DepreciationInfoRecord>();
    private static SettingsCluster settings = new SettingsCluster(DecliningBalanceDepreciationStrategy.class.getName());

    static {
        settings.addObserver(DataCenter.getInstance());
        settings.putSetting(new Setting<BigDecimal>(SETTING_MAX_VALUE, Numbers.BIG_DECIMAL_ZERO, Numbers.BIG_DECIMAL_ONEHUNDRED, new BigDecimal(25), "Prozentsatz maximal:", ""));
        settings.putSetting(new Setting<BigDecimal>(SETTING_MAX_FACTOR, new BigDecimal(0), new BigDecimal(100), new BigDecimal("2.5"), "Maximal das", "fache der linearen Abschreibung"));
        settings.putSetting(new Setting<Integer>("defaultAccount", null, null, 0, null, null));
    }

    public DecliningBalanceDepreciationStrategy(int startYear, int numYears, BigDecimal percent, int startYearLinear, AbstractReceipt receipt) {
        super(startYear, numYears, receipt);
        this.startYearLinear = startYearLinear;
        this.percent = percent;
        if (receipt != null) {
            this.setReceipt(receipt);
        }
    }

    public BigDecimal getTaxDepreciatedInYear(int year, BigDecimal originalTaxAmount) {
        if (year == this.getStartYear()) {
            return originalTaxAmount;
        }
        return Constants.ZERO;
    }

    @Override
    public boolean isDepreciatedInYear(int year) {
        return year >= this.originalReceiptDate.getYear() && year <= this.originalReceiptDate.getYear() + this.numYears;
    }

    public int getStartYearLinear() {
        return this.startYearLinear;
    }

    public void setStartYearLinear(int startYearLinear) {
        this.startYearLinear = startYearLinear;
        this.invalidateInfoRecords();
        this.setReceiptChanged();
    }

    public void setNumYears(int numYears) {
        this.numYears = numYears;
        this.invalidateInfoRecords();
        this.setReceiptChanged();
    }

    public BigDecimal getPercent() {
        return this.percent;
    }

    public void setPercent(BigDecimal percent) {
        this.percent = percent;
        this.invalidateInfoRecords();
        this.setReceiptChanged();
    }

    @Override
    public void setOriginalReceiptDate(Date date) {
        super.setOriginalReceiptDate(date);
        this.invalidateInfoRecords();
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void setOriginalReceiptDate(int year, int month, int day) {
        super.setOriginalReceiptDate(year, month, day);
        this.invalidateInfoRecords();
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void setReceipt(AbstractReceipt receipt) {
        super.setReceipt(receipt);
        this.invalidateInfoRecords();
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("depreciationplan");
        writer.writeAttribute("type", XML_DEPRECIATION_ATT_TYPE_ATT);
        this.originalReceiptDate.writeToXml(writer);
        XmlTools.writeXmlElement(writer, XML_DEPRECIATION_START_YEAR, this.getStartYear(), null);
        XmlTools.writeXmlElement(writer, XML_DEPRECIATION_START_YEAR_LINEAR, this.getStartYearLinear(), null);
        XmlTools.writeXmlElement(writer, XML_DEPRECIATION_NUM_YEARS, this.getNumYears(), null);
        XmlTools.writeXmlElement(writer, XML_DEPRECIATION_PERCENT, this.getPercent().toPlainString(), null);
        if (this.hasExtraDepreciation()) {
            this.getExtraDepreciation().writeToXml(writer);
        }
        writer.writeEndElement();
    }

    public static DepreciationStrategy readFromXML(XMLStreamReader reader) throws XMLStreamException {
        if (!(reader.isStartElement() && reader.hasName() && reader.getName().toString().equals("depreciationplan"))) {
            return null;
        }
        if (!XmlTools.getOneSingleAttributeValue(reader, "type").equals(XML_DEPRECIATION_ATT_TYPE_ATT)) {
            return null;
        }
        int startYear = 0;
        int startYearLinear = 0;
        int numYears = 0;
        Date originalReceiptDate = null;
        BigDecimal percent = null;
        ExtraDepreciation extraDepreciation = null;
        while (reader.hasNext()) {
            reader.next();
            if (XmlTools.isEndElement(reader, "depreciationplan")) break;
            if (XmlTools.isStartElement(reader, "date")) {
                originalReceiptDate = Date.readFromXml(reader);
            }
            if (XmlTools.isStartElement(reader, XML_DEPRECIATION_START_YEAR)) {
                startYear = Numbers.getIntFromString(reader.getElementText(), 0);
            }
            if (XmlTools.isStartElement(reader, XML_DEPRECIATION_START_YEAR_LINEAR)) {
                startYearLinear = Numbers.getIntFromString(reader.getElementText(), 0);
            }
            if (XmlTools.isStartElement(reader, XML_DEPRECIATION_NUM_YEARS)) {
                numYears = Numbers.getIntFromString(reader.getElementText(), 0);
            }
            if (XmlTools.isStartElement(reader, XML_DEPRECIATION_PERCENT)) {
                percent = Numbers.getBigDecimalFromString(reader.getElementText(), null);
            }
            if (!XmlTools.isStartElement(reader, "extradepreciation")) continue;
            extraDepreciation = new ExtraDepreciation(reader);
        }
        DecliningBalanceDepreciationStrategy ds = null;
        if (startYear > 0 && startYearLinear > 0 && numYears > 0 && percent != null) {
            ds = new DecliningBalanceDepreciationStrategy(startYear, numYears, percent, startYearLinear, null);
            if (originalReceiptDate != null) {
                ds.setOriginalReceiptDate(originalReceiptDate);
            } else {
                ds.setOriginalReceiptDate(startYear, 1, 1);
            }
            if (extraDepreciation != null) {
                ds.setExtraDepreciation(extraDepreciation);
            }
        }
        if (ds == null) {
            Logger logger = Logger.getLogger(DecliningBalanceDepreciationStrategy.class.getName());
            String message = "Error reading depreciation from XML: missing ";
            if (startYear <= 0) {
                message = String.valueOf(message) + "startyear ";
            }
            if (startYearLinear <= 0) {
                message = String.valueOf(message) + "startyearlinear ";
            }
            if (numYears <= 0) {
                message = String.valueOf(message) + "numyears ";
            }
            if (percent == null) {
                message = String.valueOf(message) + XML_DEPRECIATION_PERCENT;
            }
            logger.fine(message);
        }
        return ds;
    }

    public String toString() {
        String s = "Declining balance decpreciation\n" + super.toString();
        return s;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (this.originalReceiptDate.getYear() == this.getReceipt().getDate().getYear()) {
            this.originalReceiptDate = this.getReceipt().getDate();
        }
        this.invalidateInfoRecords();
    }

    public static boolean hasXmlTypeAttribute(String attribute) {
        return XML_DEPRECIATION_ATT_TYPE_ATT.equals(attribute);
    }

    @Override
    public boolean canHaveExtraDepreciation() {
        return true;
    }

    @Override
    public void setExtraDepreciation(ExtraDepreciation extraDepreciation) {
        super.setExtraDepreciation(extraDepreciation);
        this.invalidateInfoRecords();
    }

    @Override
    public DepreciationStrategy getCopy() {
        DecliningBalanceDepreciationStrategy res = new DecliningBalanceDepreciationStrategy(this.getStartYear(), this.getNumYears(), this.percent, this.startYearLinear, this.getReceipt());
        res.setOriginalReceiptDate(this.getOriginalReceiptDate());
        if (this.hasExtraDepreciation()) {
            res.setExtraDepreciation(this.getExtraDepreciation().getCopy());
        }
        return res;
    }

    private void invalidateInfoRecords() {
        if (this.infoRecords != null) {
            this.infoRecords.clear();
        }
    }

    private void calculateInfoRecords() {
        BigDecimal originalAmount = (BigDecimal)this.getReceipt().getReceiptInfo(6);
        BigDecimal startOfLinearAmount = Constants.ZERO;
        BigDecimal linearDepreciationAmount = Constants.ZERO;
        BigDecimal amountStartOfYear = Constants.ZERO;
        BigDecimal extraDepreciation = Constants.ZERO;
        BigDecimal depreciation = Constants.ZERO;
        BigDecimal amountEndOfYear = originalAmount;
        int year = this.getStartYear();
        while (year <= this.getStartYear() + this.getNumYears() + 1) {
            amountStartOfYear = amountEndOfYear;
            if (year == this.getStartYearLinear()) {
                startOfLinearAmount = amountStartOfYear;
                int months = this.getOriginalReceiptDate().getMonth() - 1 + 12 * (this.getNumYears() - this.getStartYearLinear() + this.getStartYear());
                linearDepreciationAmount = months > 0 ? startOfLinearAmount.multiply(new BigDecimal(12)).divide(new BigDecimal(months), RoundingMode.DOWN).setScale(2, RoundingMode.DOWN) : Constants.ZERO;
            }
            extraDepreciation = Constants.ZERO;
            if (this.hasExtraDepreciation()) {
                extraDepreciation = originalAmount.multiply(this.getExtraDepreciation().getPercentForYear(year)).divide(Constants.ONEHUNDRED, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.DOWN);
            }
            depreciation = year >= this.getStartYearLinear() ? linearDepreciationAmount : amountStartOfYear.multiply(this.percent).divide(Constants.ONEHUNDRED, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.DOWN);
            if (year == this.getStartYear() && this.getOriginalReceiptDate().getMonth() > 1) {
                depreciation = depreciation.multiply(new BigDecimal(13 - this.getOriginalReceiptDate().getMonth())).divide(new BigDecimal(12), RoundingMode.DOWN);
            }
            if (this.getOriginalReceiptDate().getMonth() == 1 && year == this.getStartYear() + this.getNumYears() - 1 || this.getOriginalReceiptDate().getMonth() > 1 && year == this.getStartYear() + this.getNumYears()) {
                depreciation = amountStartOfYear;
            }
            if (depreciation.compareTo(amountStartOfYear) > 0) {
                depreciation = amountStartOfYear;
            }
            amountEndOfYear = amountStartOfYear.subtract(depreciation).subtract(extraDepreciation);
            this.infoRecords.put(year, new DepreciationInfoRecord(year, originalAmount, amountStartOfYear, extraDepreciation, depreciation, amountEndOfYear));
            ++year;
        }
    }

    @Override
    public DepreciationInfoRecord getInfoRecord(int year) {
        DepreciationInfoRecord infoRecord;
        if (this.getReceipt().hasChanged()) {
            this.invalidateInfoRecords();
            this.calculateInfoRecords();
        }
        if ((infoRecord = this.infoRecords.get(year)) == null) {
            this.calculateInfoRecords();
            infoRecord = this.infoRecords.get(year);
        }
        return infoRecord;
    }

    public static SettingsCluster getSettingsCluster() {
        return settings;
    }

    @Override
    public AbstractDepreciationEditor getDepreciationEditor(int currentYear, AbstractReceipt receipt) {
        return new DecliningBalanceDepreciationEditPanel(currentYear, this, receipt);
    }
}

