/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.depreciation;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.depreciation.DepreciationInfoRecord;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationStub;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.PaymentFactory;
import de.uwemock.eur.receipt.ReceiptSupplement;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.htmltools.HtmlTools;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;

public abstract class AbstractDepreciationStrategy
extends DepreciationStub
implements DepreciationStrategy,
ReceiptSupplement {
    public static final String SETTING_DEPRECIATION_DEFAULT_ACCOUNT = "defaultAccount";
    protected int startYear;
    protected int numYears;
    private AbstractReceipt receipt;
    protected Date originalReceiptDate;
    private ExtraDepreciation extraDepreciation;

    public AbstractDepreciationStrategy(int startYear, int numYears, AbstractReceipt receipt) {
        this.startYear = startYear;
        this.numYears = numYears;
        this.setReceipt(receipt);
    }

    @Override
    public void setReceipt(AbstractReceipt receipt) {
        if (this.getReceipt() != null) {
            this.getReceipt().deleteObserver(this);
        }
        this.receipt = receipt;
        if (receipt != null && (this.originalReceiptDate == null || this.originalReceiptDate.getYear() == receipt.getDate().getYear())) {
            this.originalReceiptDate = receipt.getDate();
        }
        if (receipt != null) {
            receipt.addObserver(this);
        }
    }

    public AbstractReceipt getReceipt() {
        return this.receipt;
    }

    @Override
    public int getNumYears() {
        return this.numYears;
    }

    public int getMinNumYears(int currentYear) {
        if (this.getOriginalReceiptDate() == null) {
            return 1;
        }
        return currentYear - this.getStartYear() + 1;
    }

    @Override
    public Date getOriginalReceiptDate() {
        return this.originalReceiptDate;
    }

    @Override
    public void setOriginalReceiptDate(Date date) {
        this.originalReceiptDate = date;
        this.startYear = date.getYear();
        this.setReceiptChanged();
    }

    @Override
    public void setOriginalReceiptDate(int year, int month, int day) {
        this.originalReceiptDate = Date.getDate(year, month, day);
        this.startYear = year;
        this.setReceiptChanged();
    }

    @Override
    public int getStartYear() {
        return this.startYear;
    }

    @Override
    public boolean isDepreciatedInYear(int year) {
        return year >= this.startYear && year <= this.startYear + this.numYears - 1;
    }

    protected void setReceiptChanged() {
        if (this.receipt != null) {
            this.receipt.setChanged();
        }
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public boolean hasExtraDepreciation() {
        return this.extraDepreciation != null;
    }

    @Override
    public boolean canHaveExtraDepreciation() {
        return false;
    }

    @Override
    public ExtraDepreciation getExtraDepreciation() {
        return this.extraDepreciation;
    }

    @Override
    public void setExtraDepreciation(ExtraDepreciation extraDepreciation) {
        this.extraDepreciation = extraDepreciation;
        this.setReceiptChanged();
    }

    @Override
    public void addToPayments(Collection<Payment> payments) {
        Payment payment;
        int year = DataCenter.getInstance().getBusinessYear();
        DepreciationInfoRecord info = this.getInfoRecord(year);
        if (info == null) {
            return;
        }
        LinkedList<Payment> newPayments = new LinkedList<Payment>();
        if (payments.size() > 0) {
            int account = payments.iterator().next().getAccount();
            if (year == this.startYear) {
                for (Payment p : payments) {
                    Payment newPayment = PaymentFactory.createPaymentFromAmountExcludingTaxAndTaxAmount(p.getAccount(), Constants.ZERO, p.getAmountTax(), p.getPercentTax(), p.getTaxKey(), p.getText());
                    newPayments.add(newPayment);
                }
            }
            payment = PaymentFactory.createPaymentFromAmountExcludingTaxAndTaxAmount(account, info.getDepreciation(), Constants.ZERO, Constants.ZERO, null, null);
            newPayments.add(payment);
        }
        if (this.hasExtraDepreciation()) {
            payment = PaymentFactory.createPaymentFromAmountExcludingTaxAndTaxAmount(this.getExtraDepreciation().getAccount(), info.getExtraDepreciation(), Constants.ZERO, Constants.ZERO, null, null);
            newPayments.add(payment);
        }
        payments.clear();
        payments.addAll(newPayments);
    }

    @Override
    public void addToAccountNumbers(Set<Integer> accountNumbers) {
        if (this.hasExtraDepreciation()) {
            int account = this.getExtraDepreciation().getAccount();
            accountNumbers.add(account);
        }
    }

    public HtmlTable getDepreciationTableAsHTML() {
        HtmlTable depreciationTable = new HtmlTable();
        depreciationTable.addCssClass("minitable");
        depreciationTable.setCellspacing("0px");
        depreciationTable.setCellpadding("1px");
        depreciationTable.setRowAsHeader(0, true);
        String[] COLUMNS_DEPRECIATION_MINITABLE = TextPool.getArray("COLUMNS_DEPRECIATION_MINITABLE");
        int j = 0;
        while (j < COLUMNS_DEPRECIATION_MINITABLE.length) {
            depreciationTable.setContents(j, 0, HtmlTools.bold(COLUMNS_DEPRECIATION_MINITABLE[j]));
            depreciationTable.setAlign(j, 0, "center");
            switch (j) {
                case 0: {
                    depreciationTable.setCssClass(j, 0, "leftcell");
                    break;
                }
                case 2: {
                    depreciationTable.setCssClass(j, 0, "rightcell");
                    break;
                }
                default: {
                    depreciationTable.setCssClass(j, 0, "midcell");
                }
            }
            ++j;
        }
        int row = 1;
        int year = this.getStartYear();
        while (year < this.getStartYear() + this.getNumYears() + 1) {
            DepreciationInfoRecord infoRecord = this.getInfoRecord(year);
            if (infoRecord != null && this.isDepreciatedInYear(infoRecord.getYear())) {
                int j2 = 0;
                while (j2 < COLUMNS_DEPRECIATION_MINITABLE.length) {
                    if (j2 > 0) {
                        depreciationTable.setAlign(j2, row, "right");
                    }
                    switch (j2) {
                        case 0: {
                            depreciationTable.setCssClass(j2, row, "leftcell");
                            break;
                        }
                        case 2: {
                            depreciationTable.setCssClass(j2, row, "rightcell amount");
                            break;
                        }
                        default: {
                            depreciationTable.setCssClass(j2, row, "midcell amount");
                        }
                    }
                    ++j2;
                }
                depreciationTable.setContents(0, row, Integer.toString(infoRecord.getYear()));
                depreciationTable.setContents(1, row, "&nbsp;" + LocalizationManager.amountToCurrencyString(infoRecord.getDepreciation()));
                depreciationTable.setContents(2, row, "&nbsp;" + LocalizationManager.amountToCurrencyString(infoRecord.getExtraDepreciation()));
                if (year == DataCenter.getInstance().getBusinessYear()) {
                    int col = 0;
                    while (col < 3) {
                        depreciationTable.setCssStyle(col, row, "font-weight:bold;");
                        ++col;
                    }
                }
                ++row;
            }
            ++year;
        }
        return depreciationTable;
    }
}

