/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.data.gui;

import de.uwemock.eur.data.Tax;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.data.gui.TaxRenderer;
import de.uwemock.eur.gui.TextPool;
import java.math.BigDecimal;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class TaxComboBox
extends JComboBox {
    private TaxList taxList;
    private boolean allAllowed = false;

    public TaxComboBox() {
        this.initComponent();
    }

    public TaxComboBox(TaxList taxList) {
        super(new DefaultComboBoxModel<Object>(taxList.toArray()));
        this.taxList = taxList;
        this.initComponent();
    }

    public TaxComboBox(TaxList taxList, boolean allAllowed) {
        this(taxList);
        this.allAllowed = allAllowed;
        this.addAllTaxesItem();
    }

    private void initComponent() {
        this.setRenderer(new TaxRenderer());
        this.setToolTipText(TextPool.getString("tooltipInputTax"));
    }

    public void setTaxList(TaxList taxList) {
        this.setModel(new DefaultComboBoxModel<Object>(taxList.toArray()));
        this.taxList = taxList;
        this.addAllTaxesItem();
    }

    public Tax getSelectedTax() {
        if (this.allAllowed && this.getSelectedIndex() == 0) {
            return null;
        }
        return (Tax)this.getSelectedItem();
    }

    public BigDecimal getSelectedTaxPercent() {
        if (this.allAllowed && this.getSelectedIndex() == 0) {
            return null;
        }
        return this.getSelectedTax().getPercent();
    }

    public String getSelectedTaxReadable() {
        if (this.allAllowed && this.getSelectedIndex() == 0) {
            return this.getSelectedItem().toString();
        }
        return this.getSelectedTax().getReadable();
    }

    public void setSelectedTax(Tax tax) {
        if (tax == null) {
            this.setSelectedIndex(0);
        }
        if (this.taxList.contains(tax)) {
            this.setSelectedItem(tax);
        }
    }

    public void setSelectedTax(String taxKey) {
        if (taxKey == null) {
            this.setSelectedIndex(0);
        }
        for (Tax tax : this.taxList) {
            if (!tax.getTaxKey().equals(taxKey)) continue;
            this.setSelectedTax(tax);
            break;
        }
    }

    private void addAllTaxesItem() {
        if (this.allAllowed) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
            model.insertElementAt(TextPool.getString("labelAllTaxes"), 0);
        }
    }

    public void setSelectedTax(Integer taxID) {
        for (Tax tax : this.taxList) {
            if (!tax.getID().equals(taxID)) continue;
            this.setSelectedTax(tax);
            break;
        }
    }
}

