/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.data;

import de.uwemock.eur.data.Tax;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.idbuilder.IDPool;
import de.uwemock.xmltools.XmlTools;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class TaxList
extends ArrayList<Tax> {
    public static final String XML_TAXLIST_TAXLIST = "taxlist";
    private String taxListTitle;
    private final IDPool<Tax> idPool = new IDPool();

    public TaxList() {
        this.taxListTitle = TextPool.getString("titleUnnamedTaxList");
    }

    public TaxList(String title) {
        this.setTaxListTitle(title);
    }

    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_TAXLIST_TAXLIST);
        int i = 0;
        while (i < this.size()) {
            ((Tax)super.get(i)).writeToXML(writer);
            ++i;
        }
        writer.writeEndElement();
    }

    public static TaxList readFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger(TaxList.class.getName());
        boolean loggerIsLoggingFinest = logger.isLoggable(Level.FINEST);
        TaxList result = new TaxList();
        while (!XmlTools.isEndElement(reader, XML_TAXLIST_TAXLIST)) {
            if (XmlTools.isStartElement(reader, "tax")) {
                logger.finer("-> Found a tax data set");
                Tax newTax = Tax.readFromXML(reader, result);
                if (newTax != null) {
                    if (loggerIsLoggingFinest) {
                        logger.finest("-> -> " + newTax.toString());
                    }
                    result.add(newTax);
                }
            }
            reader.next();
        }
        return result;
    }

    public String getTaxListTitle() {
        return this.taxListTitle;
    }

    public void setTaxListTitle(String taxListTitle) {
        this.taxListTitle = taxListTitle;
    }

    public Tax getTaxFromID(Integer id) {
        return this.idPool.find(id);
    }

    IDPool<Tax> getIDPool() {
        return this.idPool;
    }

    @Override
    public boolean remove(Object t) {
        if (!(t instanceof Tax)) {
            return false;
        }
        if (super.remove(t)) {
            this.idPool.remove((Tax)t);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getTaxListTitle();
    }

    @Override
    public Object clone() {
        TaxList res = new TaxList();
        for (Tax tax : this) {
            res.add((Tax)tax.clone(res));
        }
        return res;
    }
}

