/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.data;

import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.TaxList;
import de.uwemock.idbuilder.IDPool;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Tax {
    public static final String XML_TAX_TAX = "tax";
    private static final String XML_TAX_PERCENT = "percent";
    private static final String XML_TAX_KEY = "key";
    private static final String XML_TAX_ID = "id";
    private String key;
    private String percentText;
    private BigDecimal percent;
    private BigDecimal multiplier;
    private IDPool<Tax> idPool;

    private Tax(IDPool<Tax> idPool) {
        if (idPool == null) {
            throw new IllegalArgumentException("IDPool is null");
        }
        this.idPool = idPool;
    }

    public Tax(TaxList taxList, String description, double percent) {
        this(taxList.getIDPool());
        this.key = description;
        this.percentText = String.valueOf(Double.toString(percent)) + "%";
        this.percent = new BigDecimal(percent);
        this.multiplier = this.percent.scaleByPowerOfTen(-2).add(Constants.ONE);
    }

    public Tax(TaxList taxList, String description, BigDecimal percent) {
        this(taxList.getIDPool());
        this.key = description;
        this.percentText = String.valueOf(percent.toPlainString()) + "%";
        this.percent = percent;
        this.multiplier = this.percent.scaleByPowerOfTen(-2).add(Constants.ONE);
    }

    private Tax(String description, String percent) {
        this.key = description;
        this.percentText = String.valueOf(percent) + "%";
        this.percent = Numbers.getBigDecimalFromString(percent, Constants.ZERO);
        this.multiplier = this.percent.scaleByPowerOfTen(-2).add(Constants.ONE);
    }

    public Tax(TaxList taxList, String description, String percent) {
        this(taxList.getIDPool());
        this.key = description;
        this.percentText = String.valueOf(percent) + "%";
        this.percent = Numbers.getBigDecimalFromString(percent, Constants.ZERO);
        this.multiplier = this.percent.scaleByPowerOfTen(-2).add(Constants.ONE);
    }

    public BigDecimal getPercent() {
        return this.percent;
    }

    public BigDecimal getMultiplier() {
        return this.multiplier;
    }

    public String getReadable() {
        return String.valueOf(this.key) + " (" + this.percentText + ")";
    }

    public String getTaxKey() {
        return String.valueOf(this.key) + " (" + this.percentText + ")";
    }

    public String getText() {
        return this.key;
    }

    public String getPercentText() {
        return this.percentText;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(this.idPool.getID(this));
        res.append(": ");
        res.append(this.key);
        res.append(", ");
        res.append(this.percentText);
        return res.toString();
    }

    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_TAX_TAX);
        writer.writeAttribute(XML_TAX_ID, this.idPool.getID(this).toString());
        XmlTools.writeXmlElement(writer, XML_TAX_PERCENT, this.getPercent().toPlainString(), null);
        XmlTools.writeXmlElement(writer, XML_TAX_KEY, this.getText(), null);
        writer.writeEndElement();
    }

    public static Tax readFromXML(XMLStreamReader reader, TaxList taxList) throws XMLStreamException {
        if (!XmlTools.isStartElement(reader, XML_TAX_TAX)) {
            return null;
        }
        String taxPercent = null;
        String taxDescription = null;
        String id = XmlTools.getOneSingleAttributeValue(reader, XML_TAX_ID);
        while (reader.hasNext()) {
            reader.next();
            if (XmlTools.isEndElement(reader, XML_TAX_TAX)) break;
            if (XmlTools.isStartElement(reader, XML_TAX_PERCENT)) {
                taxPercent = reader.getElementText();
            }
            if (!XmlTools.isStartElement(reader, XML_TAX_KEY)) continue;
            taxDescription = reader.getElementText();
        }
        if (taxPercent == null || taxDescription == null) {
            return null;
        }
        Tax tax = new Tax(taxDescription, taxPercent);
        tax.idPool = taxList.getIDPool();
        if (id != null && id.length() > 0) {
            taxList.getIDPool().add(tax, Integer.parseInt(id));
        }
        return tax;
    }

    public Integer getID() {
        return this.idPool.getID(this);
    }

    Object clone(TaxList taxList) {
        Tax result = new Tax(taxList, this.getText(), this.getPercent());
        this.idPool.add(this, this.idPool.getID(this));
        return result;
    }
}

