/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.data;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.DirectoryManager;
import de.uwemock.guitools.CurrentFileListener;
import de.uwemock.guitools.LastFilesListener;
import de.uwemock.tools.LoggingManager;
import de.uwemock.tools.Numbers;
import de.uwemock.tools.Version;
import de.uwemock.tools.VersionManager;
import de.uwemock.xmltools.Attribute;
import de.uwemock.xmltools.XmlTools;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SettingsManager {
    private static volatile SettingsManager instance;
    private String currentFilename = null;
    private List<String> lastFilenames = new LinkedList<String>();
    private int maxLastFilenames = 5;
    private boolean useDesktopBrowser = true;
    private String browserPath = "firefox";
    private boolean createLog = false;
    private String logFile = String.valueOf(DirectoryManager.homeDir) + DirectoryManager.fileSeparator + "jes-protocol.log";
    private String logScope = "de.uwemock.eur";
    private Level logLevel = Level.OFF;
    private boolean createBackup = true;
    private boolean lookForUpdates = true;
    private boolean useYearTable = false;
    private boolean usePoolTable = true;
    private boolean autoScroll = false;
    private boolean useDepreciationAssistant = true;
    private boolean netbookMode;
    private boolean attachmentsAllowed;
    private List<LastFilesListener> lastFilesListeners;
    private List<CurrentFileListener> currentFileListeners;
    private String lastDirectoryUsed;
    private int autoSaveDelay;
    private AutoSaveMode autoSaveMode;
    private ReceiptInputDefaultButton receiptInputDefaultButton;
    private Date.DateFormat dateFormat;
    private int attachmentWarningSize;
    private final String oldSettingsFileName;
    private final String newSettingsFileName;
    private String fileTypeAssociationCommand;
    private Dimension mainWindowSize;
    private Point mainWindowPos;
    private String columnOrder;
    private String toolbarPos;
    private String toolbarIconSize;
    private String lookAndFeel;
    private static final String XML_SETTINGS_SETTINGS = "settings";
    private static final String XML_SETTINGS_WINDOW_POSITION = "windowpos";
    private static final String XML_SETTINGS_WINDOW_SIZE = "windowsize";
    private static final String XML_SETTINGS_TOOLBAR_POSITION = "toolbarpos";
    private static final String XML_SETTINGS_TOOLBAR_ICON_SIZE = "toolbariconsize";
    private static final String XML_SETTINGS_LAST_FILES = "lastfiles";
    private static final String XML_SETTINGS_LAST_FILES_FILE = "file";
    private static final String XML_SETTINGS_MAX_LAST_FILES = "maxlastfiles";
    private static final String XML_SETTINGS_LAST_DIRECTORY_USED = "lastdir";
    private static final String XML_SETTINGS_CREATE_BACKUP_FILES = "createbackup";
    private static final String XML_SETTINGS_LOOK_FOR_UPDATES = "lookforupdates";
    private static final String XML_SETTINGS_YEARTABLE = "yeartable";
    private static final String XML_SETTINGS_POOLTABLE = "pooltable";
    private static final String XML_SETTINGS_AUTOSCROLL = "autoscroll";
    private static final String XML_SETTINGS_AUTOSAVE = "autosave";
    private static final String XML_SETTINGS_RECEIPT_INPUT_DEFAULT_BUTTON = "receiptinputdefaultbutton";
    private static final String XML_SETTINGS_AUTOSAVE_MODE = "mode";
    private static final String XML_SETTINGS_DATEFORMAT = "dateformat";
    private static final String XML_SETTINGS_ATTACHMENT_WARNING_SIZE = "maxattachmentsize";
    private static final String XML_SETTINGS_NETBOOK_MODE = "netbookmode";
    private static final String XML_SETTINGS_ATTACHMENTS_ALLOWED = "attachmentsallowed";
    private static final String XML_SETTINGS_USE_DEPRECIATION_ASSISTANT = "usedepreciationassistant";
    private static final String XML_SETTINGS_BROWSER = "browser";
    private static final String XML_SETTINGS_BROWSER_DESKTOP = "desktop";
    private static final String XML_SETTINGS_BROWSER_DESKTOP_YES = "yes";
    private static final String XML_SETTINGS_LOOK_AND_FEEL = "lookandfeel";
    private static final String XML_SETTINGS_LOGGING = "logging";
    private static final String XML_SETTINGS_LOG_ACTIVE = "active";
    private static final String XML_SETTINGS_LOG_ACTIVE_YES = "yes";
    private static final String XML_SETTINGS_LOG_FILE = "logfile";
    private static final String XML_SETTINGS_LOG_SCOPE = "scope";
    private static final String XML_SETTINGS_LOG_LEVEL = "level";
    private static final String XML_SETTINGS_MAINTABLE_COLUMN_ORDER = "columnorder";
    private static final String XML_SETTINGS_FILE_TYPE_ASSOCIATION_COMMAND = "filetypeassociationcommand";

    private SettingsManager() {
        this.netbookMode = Toolkit.getDefaultToolkit().getScreenSize().height < 700;
        this.attachmentsAllowed = false;
        this.lastFilesListeners = new ArrayList<LastFilesListener>();
        this.currentFileListeners = new ArrayList<CurrentFileListener>();
        this.lastDirectoryUsed = DirectoryManager.homeDir;
        this.autoSaveDelay = 0;
        this.autoSaveMode = AutoSaveMode.REAL_SAVE;
        this.receiptInputDefaultButton = ReceiptInputDefaultButton.NONE;
        this.dateFormat = Date.DateFormat.ISO;
        this.attachmentWarningSize = 0x100000;
        this.oldSettingsFileName = String.valueOf(DirectoryManager.homeDir) + DirectoryManager.fileSeparator + ".eursettings.xml";
        this.newSettingsFileName = String.valueOf(DirectoryManager.jesDir) + DirectoryManager.fileSeparator + "settings.xml";
        this.fileTypeAssociationCommand = "";
    }

    public static SettingsManager getInstance() {
        if (instance == null) {
            instance = new SettingsManager();
        }
        return instance;
    }

    /*
     * Loose catch block
     */
    public void readSettings() {
        String[] size;
        String[] pos;
        File oldSettings;
        String browserPath;
        boolean useDesktopBrowser;
        boolean useDesktopBrowserSettingAppeared;
        LinkedList<String> lastFilenames;
        String lastDirectoryUsed;
        String lookAndFeel;
        String toolbarIconSize;
        String toolbarPos;
        String columnOrder;
        String mainWindowSize;
        String mainWindowPos;
        block60: {
            Logger logger = Logger.getLogger(this.getClass().getName());
            mainWindowPos = null;
            mainWindowSize = null;
            columnOrder = null;
            toolbarPos = null;
            toolbarIconSize = null;
            lookAndFeel = null;
            lastDirectoryUsed = null;
            lastFilenames = new LinkedList<String>();
            useDesktopBrowserSettingAppeared = false;
            useDesktopBrowser = this.useDesktopBrowser;
            browserPath = null;
            XMLStreamReader reader = null;
            oldSettings = new File(this.oldSettingsFileName);
            String settingsFileName = oldSettings.exists() ? this.oldSettingsFileName : this.newSettingsFileName;
            try {
                boolean hasNext;
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                reader = inputFactory.createXMLStreamReader(new FileInputStream(settingsFileName), "UTF-8");
                do {
                    if (reader.hasName() && reader.isStartElement() && reader.getName().toString().equals(XML_SETTINGS_SETTINGS)) {
                        logger.finer("Found settings data");
                        block15: while (reader.hasNext()) {
                            reader.next();
                            if (XmlTools.isEndElement(reader, XML_SETTINGS_SETTINGS)) break;
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_WINDOW_POSITION)) {
                                mainWindowPos = reader.getElementText();
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_WINDOW_SIZE)) {
                                mainWindowSize = reader.getElementText();
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_MAINTABLE_COLUMN_ORDER)) {
                                columnOrder = reader.getElementText();
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_TOOLBAR_POSITION)) {
                                toolbarPos = reader.getElementText();
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_TOOLBAR_ICON_SIZE)) {
                                toolbarIconSize = reader.getElementText();
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_LOOK_AND_FEEL)) {
                                lookAndFeel = reader.getElementText();
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_LAST_FILES)) {
                                while (reader.hasNext()) {
                                    reader.next();
                                    if (XmlTools.isEndElement(reader, XML_SETTINGS_LAST_FILES)) break;
                                    if (!XmlTools.isStartElement(reader, XML_SETTINGS_LAST_FILES_FILE)) continue;
                                    lastFilenames.add(reader.getElementText());
                                }
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_LAST_DIRECTORY_USED)) {
                                lastDirectoryUsed = reader.getElementText();
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_FILE_TYPE_ASSOCIATION_COMMAND)) {
                                this.fileTypeAssociationCommand = reader.getElementText();
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_MAX_LAST_FILES)) {
                                this.setMaxLastFilenames(Numbers.getIntFromString(reader.getElementText(), this.getMaxLastFilenames()));
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_CREATE_BACKUP_FILES)) {
                                this.createBackup = Numbers.getBooleanFromString(reader.getElementText(), true);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_LOOK_FOR_UPDATES)) {
                                this.lookForUpdates = Numbers.getBooleanFromString(reader.getElementText(), true);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_YEARTABLE)) {
                                this.useYearTable = Numbers.getBooleanFromString(reader.getElementText(), false);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_POOLTABLE)) {
                                this.usePoolTable = Numbers.getBooleanFromString(reader.getElementText(), true);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_AUTOSCROLL)) {
                                this.autoScroll = Numbers.getBooleanFromString(reader.getElementText(), false);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_AUTOSAVE)) {
                                String mode = XmlTools.getOneSingleAttributeValue(reader, XML_SETTINGS_AUTOSAVE_MODE);
                                this.autoSaveMode = mode == null ? AutoSaveMode.REAL_SAVE : AutoSaveMode.getModeFromNumber(Numbers.getIntFromString(mode, AutoSaveMode.REAL_SAVE.getModeNumber()));
                                this.autoSaveDelay = Numbers.getIntFromString(reader.getElementText(), 0);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_RECEIPT_INPUT_DEFAULT_BUTTON)) {
                                String nr = XmlTools.getOneSingleAttributeValue(reader, XML_SETTINGS_RECEIPT_INPUT_DEFAULT_BUTTON);
                                this.receiptInputDefaultButton = nr == null ? ReceiptInputDefaultButton.NONE : ReceiptInputDefaultButton.getButtonFromNumber(Numbers.getIntFromString(nr, ReceiptInputDefaultButton.NONE.getButtonNumber()));
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_DATEFORMAT)) {
                                int numberCode = Numbers.getIntFromString(reader.getElementText(), 0);
                                this.dateFormat = Date.DateFormat.dateFormatFromNumberCode(numberCode);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_ATTACHMENT_WARNING_SIZE)) {
                                this.attachmentWarningSize = Numbers.getIntFromString(reader.getElementText(), this.attachmentWarningSize);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_NETBOOK_MODE)) {
                                this.netbookMode = Numbers.getBooleanFromString(reader.getElementText(), this.netbookMode);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_ATTACHMENTS_ALLOWED)) {
                                this.attachmentsAllowed = Numbers.getBooleanFromString(reader.getElementText(), this.attachmentsAllowed);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_USE_DEPRECIATION_ASSISTANT)) {
                                this.useDepreciationAssistant = Numbers.getBooleanFromString(reader.getElementText(), true);
                            }
                            if (XmlTools.isStartElement(reader, "version")) {
                                Version version = Version.readFromXML(reader);
                                VersionManager.setServerProgramVersion(version);
                            }
                            if (XmlTools.isStartElement(reader, XML_SETTINGS_BROWSER)) {
                                String browserDesktopAtt = XmlTools.getOneSingleAttributeValue(reader, XML_SETTINGS_BROWSER_DESKTOP);
                                useDesktopBrowser = browserDesktopAtt == null ? false : browserDesktopAtt.equals("yes");
                                browserPath = reader.getElementText();
                                useDesktopBrowserSettingAppeared = true;
                            }
                            if (!XmlTools.isStartElement(reader, XML_SETTINGS_LOGGING)) continue;
                            String logActiveAtt = XmlTools.getOneSingleAttributeValue(reader, XML_SETTINGS_LOG_ACTIVE);
                            this.createLog = logActiveAtt == null ? false : logActiveAtt.equals("yes");
                            while (reader.hasNext()) {
                                reader.next();
                                if (XmlTools.isEndElement(reader, XML_SETTINGS_LOGGING)) continue block15;
                                if (XmlTools.isStartElement(reader, XML_SETTINGS_LOG_FILE)) {
                                    this.logFile = reader.getElementText();
                                }
                                if (XmlTools.isStartElement(reader, XML_SETTINGS_LOG_SCOPE)) {
                                    this.logScope = reader.getElementText();
                                }
                                if (!XmlTools.isStartElement(reader, XML_SETTINGS_LOG_LEVEL)) continue;
                                String level = reader.getElementText();
                                this.logLevel = LoggingManager.getLogLevelFromName(level);
                            }
                        }
                    }
                    if (!(hasNext = reader.hasNext())) continue;
                    reader.next();
                } while (hasNext);
            }
            catch (XMLStreamException inputFactory) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException ex) {
                        ex.printStackTrace();
                    }
                }
                break block60;
            }
            catch (FileNotFoundException inputFactory) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException ex) {
                        ex.printStackTrace();
                    }
                }
                break block60;
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException ex) {
                            ex.printStackTrace();
                        }
                    }
                    throw throwable;
                }
            }
            if (reader == null) break block60;
            try {
                reader.close();
            }
            catch (XMLStreamException ex) {
                ex.printStackTrace();
            }
        }
        if (mainWindowPos != null && (pos = mainWindowPos.split(",")).length == 2) {
            Point newWindowPos;
            this.mainWindowPos = newWindowPos = new Point(Numbers.getIntFromString(pos[0], 0), Numbers.getIntFromString(pos[1], 0));
        }
        if (mainWindowSize != null && (size = mainWindowSize.split(",")).length == 2) {
            Dimension newWindowSize;
            this.mainWindowSize = newWindowSize = new Dimension(Numbers.getIntFromString(size[0], 400), Numbers.getIntFromString(size[1], 300));
        }
        if (columnOrder != null) {
            this.columnOrder = columnOrder;
        }
        if (toolbarPos != null) {
            this.toolbarPos = toolbarPos;
        }
        if (toolbarIconSize != null) {
            this.toolbarIconSize = toolbarIconSize;
        }
        if (lookAndFeel != null) {
            this.lookAndFeel = lookAndFeel;
        }
        if (lastFilenames != null) {
            this.lastFilenames = lastFilenames;
        }
        if (lastDirectoryUsed != null) {
            this.lastDirectoryUsed = lastDirectoryUsed;
        }
        if (this.lookForUpdates) {
            VersionManager.checkForUpdate(false);
        }
        if (useDesktopBrowserSettingAppeared) {
            this.useDesktopBrowser = useDesktopBrowser;
        }
        if (browserPath != null) {
            this.browserPath = browserPath;
        }
        this.setLoggingActive(this.createLog);
        if (oldSettings.exists() && !oldSettings.delete()) {
            System.out.println("Could not delete old settings file");
        }
    }

    public void writeSettings() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            Version version;
            XMLStreamWriter writer = factory.createXMLStreamWriter(new FileOutputStream(this.newSettingsFileName), "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(XML_SETTINGS_SETTINGS);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_WINDOW_POSITION, String.valueOf((int)this.mainWindowPos.getX()) + "," + (int)this.mainWindowPos.getY(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_WINDOW_SIZE, String.valueOf((int)this.mainWindowSize.getWidth()) + "," + (int)this.mainWindowSize.getHeight(), null);
            if (this.columnOrder != null) {
                XmlTools.writeXmlElement(writer, XML_SETTINGS_MAINTABLE_COLUMN_ORDER, this.columnOrder, null);
            }
            if (this.toolbarPos != null) {
                XmlTools.writeXmlElement(writer, XML_SETTINGS_TOOLBAR_POSITION, this.toolbarPos, null);
            }
            XmlTools.writeXmlElement(writer, XML_SETTINGS_TOOLBAR_ICON_SIZE, this.toolbarIconSize, null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_LOOK_AND_FEEL, UIManager.getLookAndFeel().getClass().getName(), null);
            writer.writeStartElement(XML_SETTINGS_LAST_FILES);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Last files: " + this.lastFilenames);
            }
            int i = 0;
            for (String name : this.lastFilenames) {
                if (i++ >= this.maxLastFilenames) break;
                if (name == null) continue;
                XmlTools.writeXmlElement(writer, XML_SETTINGS_LAST_FILES_FILE, name, null);
            }
            writer.writeEndElement();
            XmlTools.writeXmlElement(writer, XML_SETTINGS_MAX_LAST_FILES, this.getMaxLastFilenames(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_CREATE_BACKUP_FILES, this.doCreateBackup(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_BROWSER, this.getBrowserPath(), new Attribute(XML_SETTINGS_BROWSER_DESKTOP, this.doUseDesktopBrowser()));
            XmlTools.writeXmlElement(writer, XML_SETTINGS_LOOK_FOR_UPDATES, this.doLookForUpdates(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_YEARTABLE, this.doUseYearTable(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_POOLTABLE, this.doUsePoolsTable(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_AUTOSCROLL, this.doAutoScroll(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_AUTOSAVE, this.getAutoSaveDelay(), new Attribute(XML_SETTINGS_AUTOSAVE_MODE, this.autoSaveMode.getModeNumber()));
            XmlTools.writeXmlElement(writer, XML_SETTINGS_DATEFORMAT, this.getDateFormat().getNumberCode(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_ATTACHMENT_WARNING_SIZE, this.getAttachmentWarningSize(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_NETBOOK_MODE, this.useNetbookMode(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_ATTACHMENTS_ALLOWED, this.attachmentsAllowed(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_USE_DEPRECIATION_ASSISTANT, this.useDepreciationAssistant(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_LAST_DIRECTORY_USED, this.getLastDirectoryUsed(), null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_FILE_TYPE_ASSOCIATION_COMMAND, this.getFileTypeAssociationCommand(), null);
            writer.writeEmptyElement(XML_SETTINGS_RECEIPT_INPUT_DEFAULT_BUTTON);
            writer.writeAttribute(XML_SETTINGS_RECEIPT_INPUT_DEFAULT_BUTTON, Integer.toString(this.receiptInputDefaultButton.getButtonNumber()));
            if (VersionManager.isUpdateAvailable() && (version = VersionManager.getServerProgramVersion()) != null) {
                version.writeToXml(writer);
            }
            writer.writeStartElement(XML_SETTINGS_LOGGING);
            if (this.createLog) {
                writer.writeAttribute(XML_SETTINGS_LOG_ACTIVE, "yes");
            }
            XmlTools.writeXmlElement(writer, XML_SETTINGS_LOG_FILE, this.logFile, null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_LOG_SCOPE, this.logScope, null);
            XmlTools.writeXmlElement(writer, XML_SETTINGS_LOG_LEVEL, this.logLevel.getName(), null);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException e) {
            LoggingManager.logException(this.getClass(), e);
        }
        catch (XMLStreamException e) {
            LoggingManager.logException(this.getClass(), e);
            File f = new File(this.newSettingsFileName);
            logger.finest("name = " + this.newSettingsFileName);
            logger.finest("canWrite = " + f.canWrite());
            logger.finest("parentDir.canWrite = " + f.getParentFile().canWrite());
        }
    }

    public String[] getLastFilenames() {
        String[] filenames = new String[this.lastFilenames.size()];
        int i = 0;
        for (String filename : this.lastFilenames) {
            filenames[i++] = filename;
        }
        return filenames;
    }

    public int getMaxLastFilenames() {
        return this.maxLastFilenames;
    }

    public void setMaxLastFilenames(int maxLastFilenames) {
        this.maxLastFilenames = maxLastFilenames;
    }

    public String getLastOpenFile() {
        int i = 0;
        while (i < this.lastFilenames.size()) {
            String filename = this.lastFilenames.get(i);
            File f = new File(filename);
            if (f.exists()) {
                return filename;
            }
            ++i;
        }
        return null;
    }

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    public void setCurrentFilename(String newFilename) {
        this.currentFilename = newFilename;
        if (this.lastFilenames.contains(newFilename)) {
            this.lastFilenames.remove(this.lastFilenames.indexOf(newFilename));
        }
        this.lastFilenames.add(0, newFilename);
        this.fireLastFilesChanged();
        this.fireCurrentFileChanged(newFilename);
    }

    public boolean doCreateBackup() {
        return this.createBackup;
    }

    public void setCreateBackup(boolean createBackup) {
        this.createBackup = createBackup;
    }

    public boolean doUseDesktopBrowser() {
        return this.useDesktopBrowser;
    }

    public void setUseDesktopBrowser(boolean useDesktopBrowser) {
        this.useDesktopBrowser = useDesktopBrowser;
    }

    public String getBrowserPath() {
        return this.browserPath;
    }

    public void setBrowserPath(String browserPath) {
        this.browserPath = browserPath;
    }

    public boolean doLookForUpdates() {
        return this.lookForUpdates;
    }

    public void setLookForUpdates(boolean lookForUpdates) {
        this.lookForUpdates = lookForUpdates;
    }

    public boolean doUsePoolsTable() {
        return this.usePoolTable;
    }

    public void setUsePoolsTable(boolean poolTable) {
        this.usePoolTable = poolTable;
    }

    public boolean doUseYearTable() {
        return this.useYearTable;
    }

    public void setUseYearTable(boolean yearTable) {
        this.useYearTable = yearTable;
    }

    public boolean doAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public void addLastFilesChangedListener(LastFilesListener listener) {
        this.lastFilesListeners.add(listener);
    }

    public void removeLastFilesChangedListener(LastFilesListener listener) {
        this.lastFilesListeners.add(listener);
    }

    public void fireLastFilesChanged() {
        String[] param = new String[this.lastFilenames.size()];
        int i = 0;
        for (String filename : this.lastFilenames) {
            param[i++] = filename;
        }
        for (LastFilesListener listener : this.lastFilesListeners) {
            listener.lastFilesChanged(param);
        }
    }

    public void addCurrentFileListener(CurrentFileListener listener) {
        this.currentFileListeners.add(listener);
    }

    public void removeCurrentFileListener(CurrentFileListener listener) {
        this.currentFileListeners.add(listener);
    }

    public void fireCurrentFileChanged(String currentFile) {
        for (CurrentFileListener listener : this.currentFileListeners) {
            listener.updateCurrentFileInfo(currentFile);
        }
    }

    public boolean isLoggingActive() {
        return this.createLog;
    }

    public void setLoggingActive(boolean loggingActive) {
        this.createLog = loggingActive;
        if (this.createLog) {
            LoggingManager.setupLogging(SettingsManager.getInstance().getLogFile(), SettingsManager.getInstance().getLogLevel(), SettingsManager.getInstance().getLogScope());
        } else {
            LoggingManager.stopLogging();
        }
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getLogScope() {
        return this.logScope;
    }

    public void setLogScope(String logScope) {
        this.logScope = logScope;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public boolean useDepreciationAssistant() {
        return this.useDepreciationAssistant;
    }

    public void setUseDepreciationAssistant(boolean useDepreciationAssistant) {
        this.useDepreciationAssistant = useDepreciationAssistant;
    }

    public boolean useNetbookMode() {
        return this.netbookMode;
    }

    public void setNetbookMode(boolean netbookMode) {
        this.netbookMode = netbookMode;
    }

    public boolean attachmentsAllowed() {
        return this.attachmentsAllowed;
    }

    public void setAttachmentsAllowed(boolean attachmentsAllowed) {
        this.attachmentsAllowed = attachmentsAllowed;
    }

    public int getAutoSaveDelay() {
        return this.autoSaveDelay;
    }

    public void setAutoSaveDelay(int autoSaveDelay) {
        this.autoSaveDelay = autoSaveDelay;
    }

    public Date.DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(Date.DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public int getAttachmentWarningSize() {
        return this.attachmentWarningSize;
    }

    public void setAttachmentWarningSize(int attachmentWarningSize) {
        this.attachmentWarningSize = attachmentWarningSize;
    }

    public AutoSaveMode getAutoSaveMode() {
        return this.autoSaveMode;
    }

    public void setAutoSaveMode(AutoSaveMode mode) {
        this.autoSaveMode = mode;
    }

    public ReceiptInputDefaultButton getReceiptInputDefaultButton() {
        return this.receiptInputDefaultButton;
    }

    public void setReceiptInputDefaultButton(ReceiptInputDefaultButton button) {
        this.receiptInputDefaultButton = button;
    }

    public String getLastDirectoryUsed() {
        return this.lastDirectoryUsed;
    }

    public void setLastDirectoryUsed(String lastDirectoryUsed) {
        this.lastDirectoryUsed = lastDirectoryUsed;
    }

    public String getFileTypeAssociationCommand() {
        return this.fileTypeAssociationCommand;
    }

    public void setFileTypeAssociationCommand(String fileTypeAssociationCommand) {
        this.fileTypeAssociationCommand = fileTypeAssociationCommand;
    }

    public Dimension getMainWindowSize() {
        return this.mainWindowSize;
    }

    public void setMainWindowSize(Dimension mainWindowSize) {
        this.mainWindowSize = mainWindowSize;
    }

    public Point getMainWindowPos() {
        return this.mainWindowPos;
    }

    public void setMainWindowPos(Point mainWindowPos) {
        this.mainWindowPos = mainWindowPos;
    }

    public String getColumnOrder() {
        return this.columnOrder;
    }

    public void setColumnOrder(String columnOrder) {
        this.columnOrder = columnOrder;
    }

    public String getToolbarPos() {
        return this.toolbarPos;
    }

    public void setToolbarPos(String toolbarPos) {
        this.toolbarPos = toolbarPos;
    }

    public String getToolbarIconSize() {
        return this.toolbarIconSize;
    }

    public void setToolbarIconSize(int toolbarIconSize) {
        this.toolbarIconSize = Integer.toString(toolbarIconSize);
    }

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public static enum AutoSaveMode {
        REAL_SAVE(0),
        RECOVERY_ONLY(1);

        private int modeNumber;

        private AutoSaveMode(int modeNumber) {
            this.modeNumber = modeNumber;
        }

        public int getModeNumber() {
            return this.modeNumber;
        }

        public static AutoSaveMode getModeFromNumber(int modeNumber) {
            switch (modeNumber) {
                default: {
                    return REAL_SAVE;
                }
                case 1: 
            }
            return RECOVERY_ONLY;
        }
    }

    public static enum ReceiptInputDefaultButton {
        NONE(0),
        SAVE_DONE(1),
        SAVE_NEXT(2);

        private int buttonNumber;

        private ReceiptInputDefaultButton(int nr) {
            this.buttonNumber = nr;
        }

        public int getButtonNumber() {
            return this.buttonNumber;
        }

        public static ReceiptInputDefaultButton getButtonFromNumber(int nr) {
            switch (nr) {
                default: {
                    return NONE;
                }
                case 1: {
                    return SAVE_DONE;
                }
                case 2: 
            }
            return SAVE_NEXT;
        }
    }
}

