/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.data;

import de.uwemock.tools.LRUCache;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalizationManager {
    private static String currency = "EUR";
    private static String moneyFormat = "%.2f " + currency;
    private static final char decimalSeparator = new DecimalFormatSymbols().getDecimalSeparator();
    private static final LRUCache<BigDecimal, String> numberCache;
    private static final LRUCache<BigDecimal, String> moneyCache;

    static {
        Logger logger = Logger.getLogger(LocalizationManager.class.getName());
        boolean logging = logger.isLoggable(Level.FINE);
        numberCache = new LRUCache(512, logging);
        numberCache.setCacheTitle("LocalizationManager.numberCache");
        moneyCache = new LRUCache(512, logging);
        numberCache.setCacheTitle("LocalizationManager.moneyCache");
    }

    public static String amountToPlainString(BigDecimal b) {
        long fraction;
        String cachedValue = numberCache.get(b);
        if (cachedValue != null) {
            return cachedValue;
        }
        StringBuilder s = new StringBuilder();
        long whole = b.longValue();
        if (b.signum() < 0) {
            s.append('-');
            whole = -whole;
            fraction = -b.scaleByPowerOfTen(2).longValue() - whole * 100L;
        } else {
            fraction = b.scaleByPowerOfTen(2).longValue() - whole * 100L;
        }
        s.append(whole);
        s.append(decimalSeparator);
        if (fraction < 10L) {
            s.append('0');
        }
        s.append(fraction);
        numberCache.put(b, s.toString());
        return s.toString();
    }

    public static String amountToCurrencyString(BigDecimal b, boolean addCurrency) {
        if (!addCurrency) {
            return LocalizationManager.amountToPlainString(b);
        }
        String cachedValue = moneyCache.get(b);
        if (cachedValue != null) {
            return cachedValue;
        }
        StringBuilder s = new StringBuilder(LocalizationManager.amountToPlainString(b));
        s.append(' ');
        s.append(currency);
        return s.toString();
    }

    public static String amountToCurrencyString(BigDecimal b) {
        return LocalizationManager.amountToCurrencyString(b, true);
    }

    public static String getCurrency() {
        return currency;
    }

    public static String getMoneyFormat() {
        return moneyFormat;
    }

    static void setCurrency(String currency) {
        LocalizationManager.currency = currency;
        moneyFormat = "%.2f " + currency;
        moneyCache.clear();
    }
}

