/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.data;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.AttachmentInZip;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.tools.LoggingManager;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class FileContext {
    private static final int XML_STREAM_BUFFER_SIZE = 102400;
    public static final String XML_FILENAME = "data.xml";
    private static final int DEFAULT_COMPRESSION = 1;
    private static final int BUFFER_SIZE = 16384;
    private static final String fileSeparator = System.getProperty("file.separator");
    private File tempZipFile;
    private Thread fileGuardThread;
    private final Object synchronizer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileContext() throws IOException {
        Object object = this.synchronizer = new Object();
        synchronized (object) {
            this.tempZipFile = FileContext.createTempZipFile();
            this.fileGuardThread = new TempFileGuard();
            this.fileGuardThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileContext(String filename) throws FileNotFoundException, IOException {
        this();
        Object object = this.synchronizer;
        synchronized (object) {
            if (FileContext.isZipFile(filename)) {
                FileInputStream in = new FileInputStream(filename);
                FileOutputStream out = new FileOutputStream(this.tempZipFile);
                FileContext.copy(in, out);
                in.close();
                out.close();
            } else {
                InputStream in = new FileInputStream(filename);
                if (filename.endsWith(".gz")) {
                    in = new GZIPInputStream(in);
                }
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.tempZipFile));
                out.setLevel(1);
                ZipEntry entry = new ZipEntry(XML_FILENAME);
                out.putNextEntry(entry);
                FileContext.copy(in, out);
                out.closeEntry();
                out.close();
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getXMLDataStream() throws ZipException, IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            int read;
            ZipFile zip = this.openTempZipFile();
            ZipEntry entry = zip.getEntry(XML_FILENAME);
            InputStreamReader in = new InputStreamReader(zip.getInputStream(entry), "UTF-8");
            long builderSize = entry.getSize();
            StringBuilder contents = builderSize > 0L && builderSize < Integer.MAX_VALUE ? new StringBuilder((int)builderSize) : new StringBuilder(102400);
            char[] buffer = new char[16384];
            while ((read = in.read(buffer, 0, buffer.length)) != -1) {
                contents.append(buffer, 0, read);
            }
            in.close();
            zip.close();
            StringReader result = new StringReader(contents.toString());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putXMLData(ByteArrayOutputStream buffer) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            ZipInputStream in = this.openTempZipInputStream();
            File newTempZipFile = FileContext.createTempZipFile();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(newTempZipFile));
            out.setLevel(1);
            ZipEntry entry = new ZipEntry(XML_FILENAME);
            out.putNextEntry(entry);
            buffer.writeTo(out);
            out.closeEntry();
            byte[] copybuffer = new byte[16384];
            entry = in.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (!XML_FILENAME.equals(name)) {
                    out.putNextEntry(new ZipEntry(name));
                    FileContext.copy(in, out, copybuffer);
                    out.closeEntry();
                }
                entry = in.getNextEntry();
            }
            in.close();
            out.close();
            if (!this.tempZipFile.delete()) {
                Logger logger = Logger.getLogger(this.getClass().getName());
                logger.fine("Could not delete temporary ZIP file after adding XML data file");
            }
            this.tempZipFile = newTempZipFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Attachment> addAttachments(List<File> files) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            byte[] copybuffer = new byte[16384];
            LinkedList<Attachment> result = new LinkedList<Attachment>();
            ZipInputStream in = this.openTempZipInputStream();
            File newTempZipFile = FileContext.createTempZipFile();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(newTempZipFile));
            out.setLevel(1);
            LinkedList<String> filenamesInZip = new LinkedList<String>();
            LinkedList<File> filesReallyAdded = new LinkedList<File>();
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                filenamesInZip.add(name);
                out.putNextEntry(new ZipEntry(name));
                FileContext.copy(in, out, copybuffer);
                entry = in.getNextEntry();
            }
            in.close();
            for (File file : files) {
                String filenameInZipPrefix;
                if (!file.isFile() || !file.canRead()) continue;
                String filename = file.getAbsolutePath();
                String filenameInZip = filenameInZipPrefix = filename.substring(filename.lastIndexOf(fileSeparator) + 1);
                boolean isUnique = true;
                int uniquenessSuffix = 0;
                do {
                    isUnique = true;
                    for (String s : filenamesInZip) {
                        if (!filenameInZip.equals(s)) continue;
                        isUnique = false;
                        break;
                    }
                    if (isUnique) continue;
                    filenameInZip = String.valueOf(filenameInZipPrefix) + "." + Integer.toHexString(++uniquenessSuffix);
                } while (!isUnique);
                try {
                    entry = new ZipEntry(filenameInZip);
                    out.putNextEntry(entry);
                    FileInputStream newFileIn = new FileInputStream(filename);
                    FileContext.copy(newFileIn, out, copybuffer);
                    newFileIn.close();
                    out.closeEntry();
                    result.add(new AttachmentInZip(filename, filenameInZip));
                    filesReallyAdded.add(file);
                    filenamesInZip.add(filenameInZip);
                }
                catch (Exception e) {
                    LoggingManager.logException(FileContext.class, e);
                    e.printStackTrace();
                }
            }
            out.close();
            if (!this.tempZipFile.delete()) {
                Logger logger = Logger.getLogger(this.getClass().getName());
                logger.fine("Could not delete temporary ZIP file after adding attachments");
            }
            this.tempZipFile = newTempZipFile;
            for (File addedFile : filesReallyAdded) {
                files.remove(addedFile);
            }
            return result;
        }
    }

    Collection<Attachment> addAttachments(File[] files) throws IOException {
        ArrayList<File> filesList = new ArrayList<File>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            filesList.add(f);
            ++n2;
        }
        Collection<Attachment> result = this.addAttachments(filesList);
        int i = 0;
        while (i < files.length) {
            if (!filesList.contains(files[i])) {
                files[i] = null;
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAttachment(Attachment attachment) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            ZipInputStream in = this.openTempZipInputStream();
            File newTempZipFile = FileContext.createTempZipFile();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(newTempZipFile));
            out.setLevel(1);
            byte[] copybuffer = new byte[16384];
            String filenameToDelete = attachment.getStorageFilename();
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (!filenameToDelete.equals(name)) {
                    out.putNextEntry(new ZipEntry(name));
                    FileContext.copy(in, out, copybuffer);
                    out.closeEntry();
                }
                entry = in.getNextEntry();
            }
            in.close();
            out.closeEntry();
            out.close();
            if (!this.tempZipFile.delete()) {
                Logger logger = Logger.getLogger(this.getClass().getName());
                logger.fine("Could not delete temporary ZIP file after deleting attachments");
            }
            this.tempZipFile = newTempZipFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractAttachment(Attachment attachment, String targetFilename) throws ZipException, IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            ZipFile zip = this.openTempZipFile();
            ZipEntry entry = zip.getEntry(attachment.getStorageFilename());
            InputStream in = zip.getInputStream(entry);
            FileOutputStream out = new FileOutputStream(targetFilename);
            FileContext.copy(in, out);
            in.close();
            out.close();
            zip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(String filename, boolean createBackup) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            File origFile = new File(filename);
            String canonicalFilename = origFile.getCanonicalPath();
            String tempFilename = String.valueOf(canonicalFilename) + ".new";
            Logger logger = Logger.getLogger(this.getClass().getName());
            File file = new File(tempFilename);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("About to write file " + filename + " as " + file.getCanonicalPath());
            }
            if (file.exists()) {
                logger.finest("Deleting file as it already exists...");
                if (file.delete()) {
                    logger.finest("Deleted...");
                } else {
                    logger.finest("Could not delete file!");
                }
            }
            logger.finest("About to create streams...");
            FileInputStream in = this.openTempFileInputStream();
            FileOutputStream out = new FileOutputStream(tempFilename);
            logger.finest("Copying...");
            FileContext.copy(in, out);
            logger.finest("Closing streams...");
            in.close();
            out.close();
            logger.finest("Prepare to rename temp file...");
            File oldFile = new File(canonicalFilename);
            if (oldFile.exists()) {
                logger.finest("File exists.");
                if (createBackup) {
                    logger.finest("Backup requested; trying to rename old file to backup file.");
                    File fileBackup = new File(String.valueOf(canonicalFilename) + "~");
                    if (fileBackup.exists() && !fileBackup.delete()) {
                        logger.finest("Deleting the backup file failed");
                    }
                    if (!fileBackup.exists() && !oldFile.renameTo(fileBackup)) {
                        logger.finest("Renaming the previous file failed");
                    }
                } else {
                    logger.finest("Backup not requested; trying to delete old file.");
                    if (!oldFile.delete()) {
                        logger.finest("Deleting the backup file failed");
                    }
                }
            }
            logger.finest("Renaming temp file...");
            if (!file.renameTo(new File(canonicalFilename))) {
                logger.finest("Renaming temp file failed...");
                throw new IOException(TextPool.getString("msgRenamingNewFileFailed"));
            }
            logger.finest("Done...");
        }
    }

    public static boolean isZipFile(String filename) {
        boolean result;
        block12: {
            result = true;
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(filename);
                }
                catch (Exception e) {
                    result = false;
                    if (zip == null) break block12;
                    try {
                        zip.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    private ZipInputStream openTempZipInputStream() throws FileNotFoundException {
        return new ZipInputStream(this.openTempFileInputStream());
    }

    private FileInputStream openTempFileInputStream() throws FileNotFoundException {
        try {
            return new FileInputStream(this.tempZipFile);
        }
        catch (FileNotFoundException e) {
            FileNotFoundException exception = new FileNotFoundException(TextPool.getString("msgTempZipFileNotFound"));
            exception.initCause(e);
            throw exception;
        }
    }

    private ZipFile openTempZipFile() throws IOException {
        try {
            return new ZipFile(this.tempZipFile);
        }
        catch (FileNotFoundException e) {
            FileNotFoundException exception = new FileNotFoundException(TextPool.getString("msgTempZipFileNotFound"));
            exception.initCause(e);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.tempZipFile != null) {
                if (!this.tempZipFile.delete()) {
                    Logger logger = Logger.getLogger(this.getClass().getName());
                    logger.fine("Could not delete temporary ZIP file after closing FileContext");
                }
                this.tempZipFile = null;
            }
        }
    }

    private static File createTempZipFile() throws IOException {
        File tempZipFile = File.createTempFile("jes", ".zip");
        tempZipFile.deleteOnExit();
        return tempZipFile;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] data = new byte[16384];
        FileContext.copy(in, out, data);
    }

    private static void copy(InputStream in, OutputStream out, byte[] data) throws IOException {
        int read;
        int buffersize = data.length;
        BufferedInputStream buffer = new BufferedInputStream(in, buffersize);
        while ((read = buffer.read(data, 0, buffersize)) != -1) {
            out.write(data, 0, read);
        }
    }

    class TempFileGuard
    extends Thread {
        private final long ONE_SECOND = 1000L;
        private final long ONE_HOUR = 3600000L;
        private final long MAX_ZIP_AGE = 18000000L;
        private long lastAccess = System.currentTimeMillis();

        TempFileGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger logger = Logger.getLogger(FileContext.class.getName());
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = FileContext.this.synchronizer;
                synchronized (object) {
                    if (FileContext.this.tempZipFile == null) {
                        return;
                    }
                    long now = System.currentTimeMillis();
                    if (now - this.lastAccess >= 18000000L) {
                        if (FileContext.this.tempZipFile.exists()) {
                            block21: {
                                byte[] copybuffer = new byte[16384];
                                ZipInputStream in = null;
                                File newTempZipFile = null;
                                ZipOutputStream out = null;
                                try {
                                    in = FileContext.this.openTempZipInputStream();
                                    if (in.getNextEntry() != null) {
                                        in.close();
                                        in = FileContext.this.openTempZipInputStream();
                                        newTempZipFile = FileContext.createTempZipFile();
                                        out = new ZipOutputStream(new FileOutputStream(newTempZipFile));
                                        out.setLevel(1);
                                        if (logger.isLoggable(Level.FINEST)) {
                                            logger.finest("About to refresh temp file " + FileContext.this.tempZipFile + " to " + newTempZipFile.getCanonicalPath());
                                        }
                                        ZipEntry entry = in.getNextEntry();
                                        while (entry != null) {
                                            String name = entry.getName();
                                            out.putNextEntry(new ZipEntry(name));
                                            FileContext.copy(in, out, copybuffer);
                                            entry = in.getNextEntry();
                                        }
                                        in.close();
                                        out.closeEntry();
                                        out.close();
                                        if (!FileContext.this.tempZipFile.delete()) {
                                            logger.fine("Could not delete temporary ZIP file after refreshing temporary ZIP file");
                                        }
                                        FileContext.this.tempZipFile = newTempZipFile;
                                        logger.finest("Refreshed temporary ZIP file");
                                    }
                                }
                                catch (IOException e) {
                                    LoggingManager.logException(this.getClass(), e);
                                    if (in != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    if (out == null) break block21;
                                    try {
                                        out.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.lastAccess = now;
                        } else {
                            logger.finest("File does not exist");
                            return;
                        }
                    }
                }
            }
        }
    }
}

