/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.data;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.PluginLoader;
import de.uwemock.eur.data.Tax;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.depreciation.DecliningBalanceDepreciationStrategy;
import de.uwemock.eur.depreciation.DefaultDepreciationStrategy;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import java.util.ArrayList;

public class DataProvider {
    public static final ArrayList<TaxList> taxListCollection;
    public static final TaxList taxListGermanyStandard;
    public static final TaxList taxListGermanyZero;
    public static final ArrayList<AccountList> accountListCollection;
    public static final AccountList accountListSimple;
    public static final ArrayList<PluginLoader> pluginCollection;
    public static final PluginLoader pluginAccountsSimpleCompanyNormal2010;
    public static final PluginLoader pluginAccountsSimpleCompanySmall2010;
    public static final PluginLoader pluginAccountsSimpleCompanyNormal2011;
    public static final PluginLoader pluginAccountsSimpleCompanySmall2011;
    public static final PluginLoader pluginAccountsSimpleCompanyNormal2012;
    public static final PluginLoader pluginAccountsSimpleCompanySmall2012;

    static {
        Account[] tempAccounts;
        taxListCollection = new ArrayList();
        taxListGermanyStandard = new TaxList("D - Standardsteuers\u00e4tze");
        taxListGermanyZero = new TaxList("D - Kleinunternehmer (\u00a719 UStG)");
        taxListGermanyStandard.add(new Tax(taxListGermanyStandard, "Allgemeiner Steuersatz", 19.0));
        taxListGermanyStandard.add(new Tax(taxListGermanyStandard, "Erm\u00e4\u00dfigter Steuersatz", 7.0));
        taxListGermanyStandard.add(new Tax(taxListGermanyStandard, "Umsatzsteuerfrei", 0.0));
        taxListCollection.add(taxListGermanyStandard);
        taxListGermanyZero.add(new Tax(taxListGermanyStandard, "Umsatzsteuerfrei", 0.0));
        taxListCollection.add(taxListGermanyZero);
        accountListCollection = new ArrayList();
        accountListSimple = new AccountList("Einfacher Kontenrahmen (aus OOo E\u00dcR)");
        Account[] accountArray = tempAccounts = new Account[]{new Account(100, "Allgemeines Ausgabenkonto (kein passenderes Konto?)", true), new Account(110, "Waren, Rohstoffe und Hilfsstoffe", true), new Account(111, "B\u00fcrobedarf", true), new Account(112, "Fortbildung, Fachliteratur", true), new Account(113, "Verbrauchsmaterial (bitte auf Konto 110 buchen)", true), new Account(114, "Rechts- und Steuerberatung, Buchf\u00fchrung", true), new Account(120, "Bezogene Leistungen f\u00fcr unmittelbaren Betriebszweck", true), new Account(121, "Porto (USt 0% setzen!)", true), new Account(122, "Telekommunikation", true), new Account(123, "Energie", true), new Account(130, "Geh\u00e4lter, L\u00f6hne, Versicherungsbeitr\u00e4ge f\u00fcr Arbeitnehmer", true), new Account(140, "Aufwendungen f\u00fcr geringwertige Wirtschaftsg\u00fcter (GWG)", true), new Account(150, "Miete / Pacht f\u00fcr Gesch\u00e4ftsr\u00e4ume", true), new Account(160, "Aufwendungen f\u00fcr Grundst\u00fccke", true), new Account(170, "Aufwendungen f\u00fcr ein h\u00e4usl. Arbeitszimmer", true), new Account(180, "Verpflegungsmehraufwendungen", true), new Account(181, "Fahrtkosten \u00f6ffentlich (Bahn, \u00d6PNV, Taxi)", true), new Account(182, "Hotelkosten", true), new Account(183, "Privat-PKW f\u00fcr betriebliche Fahrten", true), new Account(184, "Laufende und feste KFZ-Kosten ohne AFA und Zinsen", true), new Account(185, "Miete / Aufwendungen f\u00fcr doppelte Haushaltsf\u00fchrung", true), new Account(190, "Geschenke \u2013 abziehbar", true), new Account(195, "Geschenke \u2013 nicht abziehbar", true), new Account(200, "Bewirtung \u2013 abziehbar", true), new Account(205, "Bewirtung \u2013 nicht abziehbar", true), new Account(210, "Sonstige abziehbare Betriebsausgaben", true), new Account(215, "Sonstige nicht abziehbare Betriebsausgaben", true), new Account(220, "Instandhaltung und Reparaturen", true), new Account(230, "Betriebsausgabenpauschale f\u00fcr bestimmte Berufsgruppen", true), new Account(235, "Freibetrag nach \u00a73 Nr.26 und 26a EStG", true), new Account(240, "Schuldzinsen (Finanzierung von Anschaffungs-/Herstellungskosten von Wirtschaftsg\u00fctern)", true), new Account(245, "\u00dcbrige Schuldzinsen (nicht abziehbar)", true), new Account(246, "\u00dcbrige Schuldzinsen (abziehbar)", true), new Account(300, "AfA auf unbewegliche Wirtschaftsg\u00fcter", true), new Account(310, "AfA auf immaterielle Wirtschaftsg\u00fcter", true), new Account(320, "AfA auf bewegliche Wirtschaftsg\u00fcter", true), new Account(330, "Sonderabschreibungen nach \u00a77g EStG", true), new Account(340, "Herabsetzungsbetr\u00e4ge nach \u00a77g Abs. 2 EStG", true), new Account(350, "Aufl\u00f6sung Sammelposten nach \u00a76 Abs. 2a EStG", true), new Account(360, "Restbuchwert der im Kalenderjahr/Wirtschaftsjahr ausgeschiedenen Anlageg\u00fcter", true), new Account(497, "Gewerbesteuer", true), new Account(498, "Vorsteuerbetr\u00e4ge", true), new Account(499, "An das FA gezahlte Umsatzsteuer", true), new Account(500, "Allgemeines Einnahmenkonto", true), new Account(510, "Einnahmen Kunde 1", true), new Account(511, "Einnahmen Kunde 2", true), new Account(512, "Einnahmen Kunde 3", true), new Account(513, "Einnahmen Kunde 4", true), new Account(514, "Einnahmen Kunde 5", true), new Account(600, "Sachentnahmen", true), new Account(610, "Nutzungs- und Leistungsentnahmen", true), new Account(620, "Private KFZ-Nutzung", true), new Account(630, "Private Telefonnutzung", true), new Account(998, "Vereinnahmte Umsatzsteuer", true), new Account(999, "Vom FA erstattete Umsatzsteuer", true)};
        int n = tempAccounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account k = accountArray[n2];
            if (k.getAccountNumber() < 500) {
                k.setAccountType(1);
            }
            if (k.getAccountNumber() >= 500) {
                k.setAccountType(2);
            }
            if (k.getAccountNumber() == 498) {
                k.setAccountType(5);
            }
            if (k.getAccountNumber() == 499) {
                k.setAccountType(5);
            }
            if (k.getAccountNumber() == 998) {
                k.setAccountType(6);
            }
            if (k.getAccountNumber() == 999) {
                k.setAccountType(6);
            }
            accountListSimple.add(k);
            ++n2;
        }
        accountListSimple.putDefaultAccount(DefaultDepreciationStrategy.class, accountListSimple.getByAccountNumber(320));
        accountListSimple.putDefaultAccount(DecliningBalanceDepreciationStrategy.class, accountListSimple.getByAccountNumber(320));
        accountListSimple.putDefaultAccount(PoolDepreciationStrategy.class, accountListSimple.getByAccountNumber(350));
        accountListSimple.putDefaultAccount(ExtraDepreciation.class, accountListSimple.getByAccountNumber(330));
        accountListCollection.add(accountListSimple);
        pluginCollection = new ArrayList();
        pluginAccountsSimpleCompanyNormal2010 = new PluginLoader("D 2010 - E\u00dcR f\u00fcr einfachen Kontenrahmen (2010)", "/de/uwemock/eur/calculation/plugins/standardplugins/eur_simpleaccounts_normal_2010.html");
        pluginAccountsSimpleCompanySmall2010 = new PluginLoader("D 2010 - E\u00dcR f\u00fcr einfachen Kontenrahmen, Kleinunternehmer (2010)", "/de/uwemock/eur/calculation/plugins/standardplugins/eur_simpleaccounts_small_2010.html");
        pluginAccountsSimpleCompanyNormal2011 = new PluginLoader("D 2011 - E\u00dcR f\u00fcr einfachen Kontenrahmen (2011)", "/de/uwemock/eur/calculation/plugins/standardplugins/eur_simpleaccounts_normal_2011.eup");
        pluginAccountsSimpleCompanySmall2011 = new PluginLoader("D 2011 - E\u00dcR f\u00fcr einfachen Kontenrahmen, Kleinunternehmer (2011)", "/de/uwemock/eur/calculation/plugins/standardplugins/eur_simpleaccounts_small_2011.eup");
        pluginAccountsSimpleCompanyNormal2012 = new PluginLoader("D 2012 - E\u00dcR f\u00fcr einfachen Kontenrahmen (2012)", "/de/uwemock/eur/calculation/plugins/standardplugins/eur_simpleaccounts_normal_2012.eup");
        pluginAccountsSimpleCompanySmall2012 = new PluginLoader("D 2012 - E\u00dcR f\u00fcr einfachen Kontenrahmen, Kleinunternehmer (2012)", "/de/uwemock/eur/calculation/plugins/standardplugins/eur_simpleaccounts_small_2012.eup");
        pluginCollection.add(pluginAccountsSimpleCompanyNormal2012);
        pluginCollection.add(pluginAccountsSimpleCompanySmall2012);
        pluginCollection.add(pluginAccountsSimpleCompanyNormal2011);
        pluginCollection.add(pluginAccountsSimpleCompanySmall2011);
        pluginCollection.add(pluginAccountsSimpleCompanyNormal2010);
        pluginCollection.add(pluginAccountsSimpleCompanySmall2010);
    }

    private DataProvider() {
    }
}

