/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.data;

import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.AbstractEurPlugin;
import de.uwemock.eur.calculation.plugins.PluginsListListener;
import de.uwemock.eur.data.DataProvider;
import de.uwemock.eur.data.DirectoryManager;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.data.UnsavedDataListener;
import de.uwemock.eur.data.XMLReadException;
import de.uwemock.eur.depreciation.DecliningBalanceDepreciationStrategy;
import de.uwemock.eur.depreciation.DefaultDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.gui.AccountListListener;
import de.uwemock.eur.gui.GeneralDataListener;
import de.uwemock.eur.gui.TaxListListener;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.ThinkingComboBoxModel;
import de.uwemock.eur.gui.TooltipCenter;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.kernels.KernelReadEuxFile;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.DataChangeListener;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.eur.receipt.OldDepreciationPool;
import de.uwemock.eur.receipt.PaymentTemplate;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.guitools.BareBonesBrowserLaunch;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlContainer;
import de.uwemock.htmltools.HtmlFactory;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.htmltools.HtmlText;
import de.uwemock.htmltools.HtmlTools;
import de.uwemock.settings.Setting;
import de.uwemock.settings.SettingsCluster;
import de.uwemock.tools.LoggingManager;
import de.uwemock.xmltools.Attribute;
import de.uwemock.xmltools.XmlTools;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class DataCenter
implements DataChangeListener,
Observer {
    private static volatile DataCenter instance = null;
    private int maxLastReceiptDescriptions = 5;
    private volatile boolean dataChanged;
    private boolean dataEditable = true;
    private TaxList taxList = (TaxList)DataProvider.taxListGermanyStandard.clone();
    private AccountList accountList;
    private ArrayList<AbstractEurPlugin> pluginList = new ArrayList();
    private ThinkingComboBoxModel receiptDescriptionList = new ThinkingComboBoxModel(this.maxLastReceiptDescriptions);
    private DefaultComboBoxModel paymentTemplateList = new DefaultComboBoxModel();
    private FileContext fileContext;
    private List<GeneralDataListener> generalDataListeners = new ArrayList<GeneralDataListener>();
    private List<TaxListListener> taxListListeners = new ArrayList<TaxListListener>();
    private List<AccountListListener> accountListListeners = new ArrayList<AccountListListener>();
    private List<PluginsListListener> pluginListListeners = new ArrayList<PluginsListListener>();
    private List<UnsavedDataListener> unsavedDataListeners = new ArrayList<UnsavedDataListener>();
    private String ownerName;
    private String ownerCompany;
    private String ownerAddress;
    private String ownerTaxId;
    private int businessYear = Calendar.getInstance().get(1);
    public static final String XML_EUR = "eur";
    public static final String XML_EUR_ATT_EDITABLE = "editable";
    public static final String XML_EUR_ATT_EDITABLE_YES = "yes";
    public static final String XML_EUR_ATT_EDITABLE_NO = "no";
    public static final String XML_GENERAL_GENERAL = "general";
    public static final String XML_GENERAL_NAME = "name";
    public static final String XML_GENERAL_COMPANY = "company";
    public static final String XML_GENERAL_ADDRESS = "address";
    public static final String XML_GENERAL_TAX_ID = "taxid";
    public static final String XML_GENERAL_YEAR = "businessyear";
    public static final String XML_GENERAL_CURRENCY = "currency";
    public static final String XML_GENERAL_MAX_RECEIPT_DESCRIPTIONS = "maxreceiptdescriptions";
    public static final String XML_DESCRIPTIONS_DESCRIPTIONS = "receipttext";
    public static final String XML_DESCRIPTIONS_ITEM = "item";
    public static final String XML_DESCRIPTIONS_ATT_FIXED = "fixed";
    public static final String XML_DESCRIPTIONS_ATT_FIXED_YES = "yes";
    public static final String XML_TEMPLATES_TEMPLATES = "receipttemplates";
    public static final String XML_PLUGINS_PLUGINS = "plugins";
    private final ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream(150000);

    private DataCenter() {
    }

    public static synchronized DataCenter getInstance() {
        if (instance == null) {
            instance = new DataCenter();
            DataCenter.instance.accountList = (AccountList)DataProvider.accountListSimple.clone();
            DataCenter.instance.accountList.setDefaultAccounts();
            ReceiptGroupManager.getInstance().addDataChangeListener(instance);
            PoolManager.getInstance().addDataChangeListener(instance);
            try {
                DataCenter.instance.fileContext = new FileContext();
            }
            catch (IOException e) {
                LoggingManager.logException(DataCenter.class, e);
                e.printStackTrace();
            }
            Thread autoSaveThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        ByteArrayOutputStream byteArrayOutputStream = instance.outputBuffer;
                        synchronized (byteArrayOutputStream) {
                            try {
                                instance.outputBuffer.wait();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                            if (instance.isOutputBufferFilled()) {
                                SettingsManager sm = SettingsManager.getInstance();
                                try {
                                    boolean recovery = sm.getAutoSaveMode() == SettingsManager.AutoSaveMode.RECOVERY_ONLY;
                                    boolean createBackup = sm.doCreateBackup() && !recovery;
                                    String filename = recovery ? DirectoryManager.recoveryFileName : sm.getCurrentFilename();
                                    if (filename != null && !filename.isEmpty()) {
                                        instance.writeOutputBuffer(filename, createBackup, recovery);
                                    }
                                }
                                catch (Exception e) {
                                    LoggingManager.logException(this.getClass(), e);
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
            };
            autoSaveThread.start();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFillOutputBuffer() {
        ByteArrayOutputStream byteArrayOutputStream = this.outputBuffer;
        synchronized (byteArrayOutputStream) {
            if (this.dataHasChanged()) {
                this.fillOutputBuffer();
                this.outputBuffer.notify();
            }
        }
    }

    public void setDataChanged() {
        this.setDataChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDataChanged(boolean changed) {
        ByteArrayOutputStream byteArrayOutputStream = this.outputBuffer;
        synchronized (byteArrayOutputStream) {
            boolean notifyListeners = changed ^ this.dataChanged;
            this.dataChanged = changed;
            if (changed && this.outputBuffer.size() > 0) {
                this.fillOutputBuffer();
            }
            if (notifyListeners) {
                this.fireUnsavedDataListener(this.dataHasChanged());
            }
        }
    }

    public boolean dataHasChanged() {
        return this.dataChanged;
    }

    public boolean isDataEditable() {
        return this.dataEditable;
    }

    public void setDataEditable(boolean dataEditable) {
        this.dataEditable = dataEditable;
        this.setDataChanged();
        this.fireGeneralDataListeners();
    }

    public TaxList getTaxList() {
        return this.taxList;
    }

    public void setTaxList(TaxList taxList) {
        this.taxList = taxList;
        this.fireTaxListListeners();
        this.setDataChanged(true);
    }

    public AccountList getAccountList() {
        return this.accountList;
    }

    public void setAccountList(AccountList accountList) {
        this.accountList = accountList;
        this.fireAccountListListeners();
        this.setDataChanged(true);
    }

    public ThinkingComboBoxModel getReceiptDescriptionList() {
        return this.receiptDescriptionList;
    }

    public DefaultComboBoxModel getPaymentTemplateList() {
        return this.paymentTemplateList;
    }

    public String getOwnerCompany() {
        return this.ownerCompany;
    }

    public void setOwnerCompany(String ownerCompany) {
        this.ownerCompany = ownerCompany;
        this.setDataChanged(true);
        this.fireGeneralDataListeners();
    }

    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
        this.setDataChanged(true);
        this.fireGeneralDataListeners();
    }

    public int getBusinessYear() {
        return this.businessYear;
    }

    public void setBusinessYear(int businessYear) {
        this.businessYear = businessYear;
        this.setDataChanged(true);
        this.fireGeneralDataListeners();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
        this.setDataChanged(true);
        this.fireGeneralDataListeners();
    }

    public String getOwnerTaxId() {
        return this.ownerTaxId;
    }

    public void setOwnerTaxId(String ownerTaxId) {
        this.ownerTaxId = ownerTaxId;
        this.setDataChanged(true);
        this.fireGeneralDataListeners();
    }

    public String getCurrency() {
        return LocalizationManager.getCurrency();
    }

    public void setCurrency(String currency) {
        LocalizationManager.setCurrency(currency);
        this.setDataChanged(true);
        this.fireGeneralDataListeners();
    }

    public int getMaxLastReceiptDescriptions() {
        return this.maxLastReceiptDescriptions;
    }

    public void setMaxLastReceiptDescriptions(int maxLastReceiptDescriptions) {
        this.maxLastReceiptDescriptions = maxLastReceiptDescriptions;
        this.receiptDescriptionList.setMaxItems(maxLastReceiptDescriptions);
    }

    public void setLastReceiptDescriptions(ThinkingComboBoxModel lastReceiptDescriptions) {
        this.receiptDescriptionList = lastReceiptDescriptions;
        this.receiptDescriptionList.setMaxItems(this.getMaxLastReceiptDescriptions());
    }

    public FileContext getFileContext() {
        return this.fileContext;
    }

    public ArrayList<AbstractEurPlugin> getPluginList() {
        return this.pluginList;
    }

    public void setPluginList(ArrayList<AbstractEurPlugin> pluginList) {
        this.pluginList = pluginList;
        this.firePluginsListListeners(pluginList);
        this.setDataChanged(true);
    }

    public HtmlTable createGeneralDataHtmlTable() {
        HtmlTable generalTable = new HtmlTable();
        generalTable.setContents(0, 0, TextPool.getString("htmlTextName"));
        generalTable.setCssClass(0, 0, "general_label");
        generalTable.setContents(1, 0, "&nbsp;");
        generalTable.setContents(2, 0, DataCenter.getInstance().getOwnerName());
        generalTable.setCssClass(2, 0, "general_contents");
        generalTable.setContents(0, 1, TextPool.getString("htmlTextCompany"));
        generalTable.setCssClass(0, 1, "general_label");
        generalTable.setContents(2, 1, DataCenter.getInstance().getOwnerCompany());
        generalTable.setCssClass(2, 1, "general_contents");
        generalTable.setContents(0, 2, TextPool.getString("htmlTextAddress"));
        generalTable.setCssClass(0, 2, "general_label");
        generalTable.setContents(2, 2, DataCenter.getInstance().getOwnerAddress());
        generalTable.setCssClass(2, 2, "general_contents");
        generalTable.setContents(0, 3, TextPool.getString("htmlTextTaxId"));
        generalTable.setCssClass(0, 3, "general_label");
        generalTable.setContents(2, 3, DataCenter.getInstance().getOwnerTaxId());
        generalTable.setCssClass(2, 3, "general_contents");
        return generalTable;
    }

    public HtmlBodyElement createGeneralInfoHtml() {
        Calendar c = Calendar.getInstance();
        HtmlContainer container = new HtmlContainer("p");
        container.addHtmlElement(new HtmlText(String.valueOf(TextPool.getString("htmlTextCalcDate")) + String.format("%4d-%02d-%02d", c.get(1), c.get(2) + 1, c.get(5))));
        container.addHtmlElement(HtmlFactory.BR);
        container.addHtmlElement(new HtmlText(String.valueOf(TextPool.getString("htmlTextCalcNumReceipts")) + Integer.toString(ReceiptGroupManager.getInstance().getReceiptCount())));
        return container;
    }

    private void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        SettingsCluster[] clusterList;
        writer.writeStartElement(XML_GENERAL_GENERAL);
        XmlTools.writeXmlElement(writer, XML_GENERAL_NAME, this.getOwnerName(), null);
        XmlTools.writeXmlElement(writer, XML_GENERAL_ADDRESS, this.getOwnerAddress(), null);
        XmlTools.writeXmlElement(writer, XML_GENERAL_COMPANY, this.getOwnerCompany(), null);
        XmlTools.writeXmlElement(writer, XML_GENERAL_TAX_ID, this.getOwnerTaxId(), null);
        XmlTools.writeXmlElement(writer, XML_GENERAL_YEAR, this.getBusinessYear(), null);
        XmlTools.writeXmlElement(writer, XML_GENERAL_CURRENCY, this.getCurrency(), null);
        XmlTools.writeXmlElement(writer, XML_GENERAL_MAX_RECEIPT_DESCRIPTIONS, this.getMaxLastReceiptDescriptions(), null);
        writer.writeStartElement(XML_DESCRIPTIONS_DESCRIPTIONS);
        int i = 0;
        while (i < this.receiptDescriptionList.getSize()) {
            XmlTools.writeXmlElement(writer, XML_DESCRIPTIONS_ITEM, this.receiptDescriptionList.getElementAt(i).toString(), new Attribute(XML_DESCRIPTIONS_ATT_FIXED, this.receiptDescriptionList.isItemFixed(i)));
            ++i;
        }
        writer.writeEndElement();
        writer.writeStartElement(XML_TEMPLATES_TEMPLATES);
        i = 0;
        while (i < this.paymentTemplateList.getSize()) {
            PaymentTemplate template = (PaymentTemplate)this.paymentTemplateList.getElementAt(i);
            template.writeToXML(writer);
            ++i;
        }
        writer.writeEndElement();
        SettingsCluster[] settingsClusterArray = clusterList = new SettingsCluster[]{DefaultDepreciationStrategy.getSettingsCluster(), DecliningBalanceDepreciationStrategy.getSettingsCluster(), PoolDepreciationStrategy.getSettingsCluster(), ExtraDepreciation.getSettingsCluster()};
        int n = clusterList.length;
        int n2 = 0;
        while (n2 < n) {
            SettingsCluster cluster = settingsClusterArray[n2];
            cluster.writeToXml(writer);
            ++n2;
        }
        writer.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillOutputBuffer() {
        ByteArrayOutputStream byteArrayOutputStream = this.outputBuffer;
        synchronized (byteArrayOutputStream) {
            long timeStart = Calendar.getInstance().getTimeInMillis();
            Logger logger = Logger.getLogger("de.uwemock.eur.DataCenter");
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this.outputBuffer.reset();
            try {
                XMLStreamWriter writer = factory.createXMLStreamWriter(this.outputBuffer, "UTF-8");
                logger.finest("Starting to write on XML stream...");
                writer.writeStartDocument("UTF-8", "1.0");
                writer.writeStartElement(XML_EUR);
                writer.writeAttribute(XML_EUR_ATT_EDITABLE, this.isDataEditable() ? "yes" : XML_EUR_ATT_EDITABLE_NO);
                logger.finest("Writing general data...");
                this.writeToXML(writer);
                logger.finest("Writing taxes...");
                this.getTaxList().writeToXML(writer);
                logger.finest("Writing accounts...");
                this.getAccountList().writeToXml(writer);
                logger.finest("Writing plugins...");
                writer.writeStartElement(XML_PLUGINS_PLUGINS);
                for (AbstractEurPlugin p : this.pluginList) {
                    p.writeToXML(writer);
                }
                writer.writeEndElement();
                logger.finest("Writing receipts...");
                ReceiptGroupManager.getInstance().writeToXML(writer);
                logger.finest("Writing pools...");
                PoolManager.getInstance().writeToXML(writer);
                logger.finest("Done writing.");
                writer.writeEndDocument();
                writer.flush();
                writer.close();
            }
            catch (XMLStreamException e) {
                logger.severe("Failed writing to the output buffer:");
                LoggingManager.logException(this.getClass(), e);
            }
            if (logger.isLoggable(Level.FINER)) {
                long timeEnd = Calendar.getInstance().getTimeInMillis();
                logger.finer("fillBuffer() took " + (timeEnd - timeStart) + "ms");
            }
        }
    }

    public synchronized boolean isOutputBufferFilled() {
        return this.outputBuffer.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutputBuffer(String filename, boolean createBackup, boolean recoveryFile) throws FileNotFoundException, IOException, XMLStreamException {
        if (filename == null || filename.isEmpty()) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = this.outputBuffer;
        synchronized (byteArrayOutputStream) {
            try {
                this.fileContext.putXMLData(this.outputBuffer);
                this.fileContext.writeToFile(filename, createBackup);
            }
            finally {
                this.outputBuffer.reset();
            }
            if (!recoveryFile) {
                SettingsManager.getInstance().setCurrentFilename(filename);
                this.setDataChanged(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAllData(String filename, boolean createBackup) throws FileNotFoundException, IOException, XMLStreamException {
        ByteArrayOutputStream byteArrayOutputStream = this.outputBuffer;
        synchronized (byteArrayOutputStream) {
            this.fillOutputBuffer();
            this.writeOutputBuffer(filename, createBackup, false);
        }
    }

    public void readAllData(String filename) throws Exception {
        KernelReadEuxFile k = new KernelReadEuxFile(filename, null);
        try {
            k.executeWork();
        }
        catch (FileNotFoundException e) {
            LoggingManager.logException(this.getClass(), e);
            throw e;
        }
        catch (Exception e) {
            LoggingManager.logException(this.getClass(), e);
            throw e;
        }
        this.getAllDataFromKernel(k);
    }

    /*
     * WARNING - void declaration
     */
    public void getAllDataFromKernel(KernelReadEuxFile k) throws XMLReadException, FileNotFoundException {
        Logger logger = Logger.getLogger("de.uwemock.eur.DataCenter");
        boolean loggerIsLoggingFine = logger.isLoggable(Level.FINE);
        String filename = (String)k.get("FILENAME");
        AccountList newAccountList = (AccountList)k.get("ACCOUNT_LIST");
        LinkedList newReceiptsList = (LinkedList)k.get("RECEIPTS_LIST");
        LinkedList newPoolsList = (LinkedList)k.get("DEPRECIATION_POOLS");
        HashMap newReceiptGroupsList = (HashMap)k.get("RECEIPT_GROUPS");
        TaxList newTaxList = (TaxList)k.get("TAX_LIST");
        ArrayList newPluginsList = (ArrayList)k.get("PLUGINS_LIST");
        ThinkingComboBoxModel receiptDescriptions = (ThinkingComboBoxModel)k.get("RECEIPT_DESCRIPTIONS");
        DefaultComboBoxModel paymentTemplates = (DefaultComboBoxModel)k.get("RECEIPT_TEMPLATES");
        FileContext newFileContext = (FileContext)k.get("FILE_CONTEXT");
        Map settingsClusters = (Map)k.get("SETTINGS_CLUSTERS");
        boolean attachmentDBError = (Boolean)k.get("ATTACHMENT_DB_ERROR");
        boolean newEditableState = (Boolean)k.get("EDITABLE");
        String newOwnerName = (String)k.get("OWNER_NAME");
        String newOwnerCompany = (String)k.get("OWNER_COMPANY");
        String newOwnerAddress = (String)k.get("OWNER_ADDRESS");
        String newOwnerTaxId = (String)k.get("OWNER_TAX_ID");
        int newBusinessYear = (Integer)k.get("BUSINESS_YEAR");
        String newCurrency = (String)k.get("CURRENCY");
        int newMaxReceiptDescriptions = (Integer)k.get("MAX_DESCRIPTIONS");
        if (newOwnerName == null || newOwnerAddress == null || newOwnerCompany == null || newOwnerTaxId == null || newBusinessYear == 0 || newCurrency == null) {
            throw new XMLReadException(TextPool.getString("msgGeneralDataReadError"));
        }
        if (newAccountList == null) {
            throw new XMLReadException(TextPool.getString("msgAccountListReadError"));
        }
        if (newTaxList == null) {
            throw new XMLReadException(TextPool.getString("msgTaxListReadError"));
        }
        if (newReceiptsList == null) {
            throw new XMLReadException(TextPool.getString("msgReceiptsListReadError"));
        }
        if (filename.equals(DirectoryManager.recoveryFileName)) {
            SettingsManager.getInstance().setCurrentFilename(null);
        } else {
            SettingsManager.getInstance().setCurrentFilename(filename);
        }
        this.setOwnerName(newOwnerName);
        this.setOwnerAddress(newOwnerAddress);
        this.setOwnerCompany(newOwnerCompany);
        this.setOwnerTaxId(newOwnerTaxId);
        this.setBusinessYear(newBusinessYear);
        this.setCurrency(newCurrency);
        this.setLastReceiptDescriptions(receiptDescriptions);
        this.paymentTemplateList = paymentTemplates;
        this.setMaxLastReceiptDescriptions(newMaxReceiptDescriptions);
        this.setAccountList(newAccountList);
        this.setTaxList(newTaxList);
        if (newPluginsList != null) {
            this.setPluginList(newPluginsList);
        }
        boolean autoScrollState = SettingsManager.getInstance().doAutoScroll();
        SettingsManager.getInstance().setAutoScroll(false);
        ReceiptGroupManager.getInstance().startBulkInsert();
        ReceiptGroupManager.getInstance().resetCollections();
        PoolManager.getInstance().removeAllPools();
        for (AbstractReceipt abstractReceipt : newReceiptsList) {
            if (abstractReceipt instanceof OldDepreciationPool) {
                int year = abstractReceipt.getDate().getYear();
                if (loggerIsLoggingFine) {
                    logger.fine("Found old depreciation pool for year " + year);
                }
                logger.finest("Adjusting depreciation strategy...");
                DepreciationPool pool = PoolManager.getInstance().getDepreciationPoolForYear(year);
                Object ds = abstractReceipt.getDepreciationStrategy();
                if (!(ds instanceof PoolDepreciationStrategy)) {
                    ds = new PoolDepreciationStrategy(ds.getStartYear(), ds.getNumYears() + 1, pool);
                }
                pool.setDepreciationStrategy((DepreciationStrategy)ds);
                if (loggerIsLoggingFine) {
                    logger.fine("Adding receipts from old depreciation pool for year " + year);
                }
                for (AbstractReceipt abstractReceipt2 : ((OldDepreciationPool)abstractReceipt).getReceiptList()) {
                    int newReceiptNumber = ReceiptNumberManager.getInstance().getNextReceiptNumber();
                    abstractReceipt2.setNumber(newReceiptNumber);
                    PoolManager.getInstance().add(abstractReceipt2);
                }
                logger.fine("Done!");
            } else {
                ReceiptGroupManager.getInstance().add(abstractReceipt);
            }
            abstractReceipt.addObserver(this);
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("Added " + abstractReceipt);
        }
        if (newPoolsList != null) {
            PoolManager poolManager = PoolManager.getInstance();
            for (DepreciationPool pool : newPoolsList) {
                for (AbstractReceipt r : pool.getReceiptList()) {
                    poolManager.add(r);
                }
            }
        }
        if (newReceiptGroupsList != null) {
            for (Map.Entry entry : newReceiptGroupsList.entrySet()) {
                String groupName = (String)entry.getKey();
                LinkedList itemsList = (LinkedList)entry.getValue();
                for (Integer i : itemsList) {
                    ReceiptGroupManager.getInstance().add(i, groupName);
                }
            }
        }
        if (settingsClusters != null) {
            for (Map.Entry entry : settingsClusters.entrySet()) {
                void var30_45;
                String className = (String)entry.getKey();
                Map settingsValues = (Map)entry.getValue();
                SettingsCluster cluster = null;
                Object var30_43 = null;
                try {
                    Class<?> clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                if (var30_45 != null) {
                    Method m = null;
                    try {
                        m = var30_45.getMethod("getSettingsCluster", null);
                    }
                    catch (Exception e) {
                        LoggingManager.logException(this.getClass(), e);
                    }
                    if (m != null) {
                        try {
                            cluster = (SettingsCluster)m.invoke(null, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            LoggingManager.logException(this.getClass(), e.getTargetException());
                        }
                        catch (Exception e) {
                            LoggingManager.logException(this.getClass(), e);
                        }
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Put settings cluster from kernel to class " + className);
                }
                if (cluster != null) {
                    for (Map.Entry setting : settingsValues.entrySet()) {
                        Setting<?> settingInCluster;
                        String settingName = (String)setting.getKey();
                        String settingValue = (String)setting.getValue();
                        if (settingName == null) continue;
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(String.valueOf(settingName) + " -> " + settingValue);
                        }
                        if ((settingInCluster = cluster.getSetting(settingName)) == null) continue;
                        settingInCluster.setCurrentValue(settingValue);
                        logger.finest("Success!");
                    }
                }
                logger.finer("Done.");
            }
        }
        ReceiptGroupManager.getInstance().endBulkInsert();
        SettingsManager.getInstance().setAutoScroll(autoScrollState);
        this.setDataEditable(newEditableState);
        JesUndoManager.getInstance().discardAllEdits();
        TooltipCenter.getInstance().removeAllTooltips();
        if (!attachmentDBError) {
            logger.fine("Closing old file context and setting new one.");
            this.fileContext.close();
            this.fileContext = newFileContext;
        }
        if (filename.equals(DirectoryManager.recoveryFileName)) {
            this.setDataChanged(true);
        } else {
            this.setDataChanged(false);
        }
        logger.fine("Done reading.");
    }

    public void showHTML(StringBuffer html) {
        Logger logger = Logger.getLogger("de.uwemock.eur.DataCenter");
        boolean loggerIsLoggingFiner = logger.isLoggable(Level.FINER);
        File file = null;
        OutputStreamWriter writer = null;
        String filename = null;
        try {
            try {
                file = File.createTempFile(XML_EUR, ".html");
                file.deleteOnExit();
                writer = new FileWriter(file);
                HtmlTools.useEntities(html);
                writer.write(html.toString());
                writer.flush();
                filename = file.getCanonicalPath();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, TextPool.getString("msgTempFileProblem"), TextPool.getString("titleErrorMessage"), 0);
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (loggerIsLoggingFiner) {
            logger.finer("About to start browser on file " + filename);
        }
        if (SettingsManager.getInstance().doUseDesktopBrowser()) {
            logger.finer("Trying desktop browser...");
            try {
                BareBonesBrowserLaunch.openURL("file://" + filename);
                logger.finer("Dektop browser call succeeded!");
                return;
            }
            catch (Exception e) {
                logger.finer("Desktop browser call failed!");
                SettingsManager.getInstance().setUseDesktopBrowser(false);
            }
        }
        if (loggerIsLoggingFiner) {
            logger.finer("Trying other browser (" + SettingsManager.getInstance().getBrowserPath() + ")");
        }
        try {
            Runtime.getRuntime().exec(String.valueOf(SettingsManager.getInstance().getBrowserPath()) + " file://" + file.getCanonicalPath().replace(" ", "%20"));
            logger.finer("Other browser call succeeded!");
            return;
        }
        catch (Exception e) {
            logger.finer("Other browser call failed!");
            JOptionPane.showMessageDialog(null, TextPool.getString("msgBrowserError"), TextPool.getString("titleErrorMessage"), 0);
            return;
        }
    }

    @Override
    public void dataChanged() {
        this.setDataChanged(true);
    }

    public void addPluginsListListener(PluginsListListener listener) {
        this.pluginListListeners.add(listener);
    }

    public void removePluginsListListener(PluginsListListener listener) {
        this.pluginListListeners.remove(listener);
    }

    public void firePluginsListListeners(ArrayList<AbstractEurPlugin> plugins) {
        for (PluginsListListener listener : this.pluginListListeners) {
            listener.pluginsListHasChanged(plugins);
        }
    }

    public void addUnsavedDataListener(UnsavedDataListener listener) {
        this.unsavedDataListeners.add(listener);
    }

    public void removeUnsavedDataListener(UnsavedDataListener listener) {
        this.unsavedDataListeners.remove(listener);
    }

    public void fireUnsavedDataListener(boolean dataChanged) {
        for (UnsavedDataListener listener : this.unsavedDataListeners) {
            listener.dataSaveStateChanged(dataChanged);
        }
    }

    public void addTaxListListener(TaxListListener listener) {
        this.taxListListeners.add(listener);
    }

    public void removeTaxListListener(TaxListListener listener) {
        this.taxListListeners.remove(listener);
    }

    public void fireTaxListListeners() {
        for (TaxListListener listener : this.taxListListeners) {
            listener.taxListHasChanged(this.getTaxList());
        }
    }

    public void addAccountListListener(AccountListListener listener) {
        this.accountListListeners.add(listener);
    }

    public void removeAccountListListener(AccountListListener listener) {
        this.accountListListeners.remove(listener);
    }

    public void fireAccountListListeners() {
        for (AccountListListener listener : this.accountListListeners) {
            listener.accountListHasChanged(this.getAccountList());
        }
    }

    public void addGeneralDataListener(GeneralDataListener listener) {
        this.generalDataListeners.add(listener);
    }

    public void removeGeneralDataListener(GeneralDataListener listener) {
        this.generalDataListeners.remove(listener);
    }

    public void fireGeneralDataListeners() {
        for (GeneralDataListener listener : this.generalDataListeners) {
            listener.generalDataChanged();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setDataChanged(true);
    }

    public void reset() {
        this.setAccountList((AccountList)DataProvider.accountListSimple.clone());
        this.setTaxList((TaxList)DataProvider.taxListGermanyStandard.clone());
        this.setBusinessYear(Calendar.getInstance().get(1));
        this.setCurrency("EUR");
        this.setOwnerAddress(null);
        this.setOwnerCompany(null);
        this.setOwnerName(null);
        this.setOwnerTaxId(null);
        this.setPluginList(new ArrayList<AbstractEurPlugin>());
        ReceiptGroupManager.getInstance().resetCollections();
        this.fileContext.close();
        try {
            this.fileContext = new FileContext();
        }
        catch (IOException e) {
            e.printStackTrace();
            LoggingManager.logException(DataCenter.class, e);
        }
        JesUndoManager.getInstance().discardAllEdits();
        this.setDataChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecoveryFile() {
        Logger logger = Logger.getLogger("de.uwemock.eur.DataCenter");
        ByteArrayOutputStream byteArrayOutputStream = DataCenter.instance.outputBuffer;
        synchronized (byteArrayOutputStream) {
            File recoveryFile = new File(DirectoryManager.recoveryFileName);
            if (recoveryFile.exists() && !recoveryFile.delete()) {
                logger.fine("Could not delete recovery file!");
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("name = " + DirectoryManager.recoveryFileName);
                    logger.finest("canWrite = " + recoveryFile.canWrite());
                    logger.finest("parentDir.canWrite = " + recoveryFile.getParentFile().canWrite());
                }
            }
        }
    }

    public void closeFileContext() {
        this.fileContext.close();
    }

    public static boolean recoveryFilePresent() {
        File recoveryFile = new File(DirectoryManager.recoveryFileName);
        return recoveryFile.exists();
    }

    public static boolean recoveryFileRecoverable() {
        KernelReadEuxFile k = new KernelReadEuxFile(DirectoryManager.recoveryFileName);
        try {
            k.executeWork();
        }
        catch (Exception e) {
            return false;
        }
        AccountList newAccountList = (AccountList)k.get("ACCOUNT_LIST");
        LinkedList newReceiptsList = (LinkedList)k.get("RECEIPTS_LIST");
        TaxList newTaxList = (TaxList)k.get("TAX_LIST");
        String newOwnerName = (String)k.get("OWNER_NAME");
        String newOwnerCompany = (String)k.get("OWNER_COMPANY");
        String newOwnerAddress = (String)k.get("OWNER_ADDRESS");
        String newOwnerTaxId = (String)k.get("OWNER_TAX_ID");
        int newBusinessYear = (Integer)k.get("BUSINESS_YEAR");
        String newCurrency = (String)k.get("CURRENCY");
        return newOwnerName != null && newOwnerAddress != null && newOwnerCompany != null && newOwnerTaxId != null && newBusinessYear != 0 && newCurrency != null && newAccountList != null && newTaxList != null && newReceiptsList != null;
    }
}

