/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.data;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.FileContext;
import de.uwemock.tools.LoggingManager;
import de.uwemock.xmltools.XmlTools;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class AttachmentInZip
implements Attachment {
    public static final String NO_DIGEST = "NONE";
    private static final String fileSeparator = System.getProperty("file.separator");
    private String filename;
    private String filenameInZip;
    private String checksum;
    private String digestType;

    public AttachmentInZip(String filename, String filenameInZip) throws IOException {
        this.filename = filename.substring(filename.lastIndexOf(fileSeparator) + 1);
        this.filenameInZip = filenameInZip;
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA1");
            this.digestType = "SHA1";
        }
        catch (NoSuchAlgorithmException e) {
            LoggingManager.logException(this.getClass(), e);
        }
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("MD5");
                this.digestType = "MD5";
            }
            catch (NoSuchAlgorithmException e) {
                // empty catch block
            }
        }
        if (digest != null) {
            FileInputStream fis = new FileInputStream(filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            DigestInputStream dis = new DigestInputStream(bis, digest);
            while (dis.read() != -1) {
            }
            byte[] hash = digest.digest();
            dis.close();
            bis.close();
            fis.close();
            this.checksum = String.valueOf(this.digestType) + ":" + this.formatDigest(hash);
        } else {
            this.checksum = "";
            this.digestType = NO_DIGEST;
        }
    }

    public AttachmentInZip(String filename, String filenameInZip, String checksum) {
        this.filename = filename;
        this.filenameInZip = filenameInZip;
        this.checksum = checksum;
        this.digestType = checksum != null && checksum.indexOf(":") > 0 ? checksum.substring(0, checksum.indexOf(":")) : NO_DIGEST;
    }

    private String formatDigest(byte[] digest) {
        Formatter formatter = new Formatter();
        byte[] byArray = digest;
        int n = digest.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        return formatter.toString();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getStorageFilename() {
        return this.filenameInZip;
    }

    @Override
    public String getOriginalChecksum() {
        return this.checksum;
    }

    @Override
    public String getCurrentChecksum(FileContext context) {
        Logger logger = Logger.getLogger("de.uwemock.eur.data.AttachmentInZip");
        boolean loggerIsLoggingFine = logger.isLoggable(Level.FINE);
        if (loggerIsLoggingFine) {
            logger.fine("About to calculate checksum for " + this.filenameInZip);
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(this.digestType);
        }
        catch (NoSuchAlgorithmException e) {
            if (loggerIsLoggingFine) {
                logger.fine("Digest type " + this.digestType + " not available. Exit.");
            }
            return NO_DIGEST;
        }
        if (digest != null) {
            File tempFile = null;
            BufferedInputStream buffer = null;
            try {
                int read;
                logger.fine("Creating temporary file");
                tempFile = File.createTempFile("attachment", this.filename.substring(this.filename.lastIndexOf(".")));
                logger.fine("Extracting from ZIP to temporary file");
                this.saveAs(context, tempFile.getAbsolutePath());
                logger.fine("Done. Now calculating digest.");
                byte[] bytes = new byte[4096];
                buffer = new BufferedInputStream(new FileInputStream(tempFile));
                while ((read = buffer.read(bytes, 0, bytes.length)) != -1) {
                    digest.update(bytes, 0, read);
                }
                byte[] hash = digest.digest();
                String result = String.valueOf(this.digestType) + ":" + this.formatDigest(hash);
                if (loggerIsLoggingFine) {
                    logger.fine("Done. Result = " + result);
                }
                String string = result;
                return string;
            }
            catch (IOException e) {
                LoggingManager.logException(this.getClass(), e);
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException e) {
                        LoggingManager.logException(this.getClass(), e);
                    }
                }
                if (tempFile != null && !tempFile.delete()) {
                    logger.fine("Could not delete temporary file");
                }
            }
        }
        return NO_DIGEST;
    }

    @Override
    public void save(FileContext context) throws IOException {
        this.saveAs(context, this.filename);
    }

    @Override
    public void saveAs(FileContext context, String filename) throws IOException {
        context.extractAttachment(this, filename);
    }

    @Override
    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEmptyElement("attachment");
        writer.writeAttribute("checksum", this.checksum);
        writer.writeAttribute("filename", this.filename);
        writer.writeAttribute("storagename", this.filenameInZip);
    }

    public static AttachmentInZip readFromXml(XMLStreamReader reader) throws XMLStreamException {
        if (!XmlTools.isStartElement(reader, "attachment") || reader.getAttributeCount() == 0) {
            return null;
        }
        Map<String, String> atts = XmlTools.getAttributes(reader);
        String filename = atts.get("filename");
        String filenameInZip = atts.get("storagename");
        String checksum = atts.get("checksum");
        if (filename != null && filenameInZip != null && checksum != null) {
            return new AttachmentInZip(filename, filenameInZip, checksum);
        }
        return null;
    }
}

