/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.data;

import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptFactory;
import de.uwemock.eur.receipt.ReceiptNumberListener;
import de.uwemock.eur.receipt.ReceiptOwner;
import de.uwemock.xmltools.XmlTools;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractReceiptOwner
implements ReceiptOwner {
    public static final String XML_RECEIPTS_RECEIPTS = "receipts";
    private ArrayList<ReceiptNumberListener> receiptNumberListener = new ArrayList();

    public void addReceiptNumberListener(ReceiptNumberListener l) {
        this.receiptNumberListener.add(l);
    }

    public void removeReceiptNumberListener(ReceiptNumberListener l) {
        this.receiptNumberListener.remove(l);
    }

    public void fireReceiptNumberChanged(int newNumber) {
        for (ReceiptNumberListener l : this.receiptNumberListener) {
            l.setCurrentReceiptNumber(newNumber);
        }
    }

    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        Logger logger = Logger.getLogger("de.uwemock.eur.AbstractReceiptOwner");
        writer.writeStartElement(XML_RECEIPTS_RECEIPTS);
        for (Receipt receipt : this.getReceiptList()) {
            logger.fine("Calling write");
            receipt.writeToXML(writer);
        }
        writer.writeEndElement();
    }

    public static LinkedList<AbstractReceipt> readFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger("de.uwemock.eur.AbstractReceiptOwner");
        LinkedList<AbstractReceipt> result = new LinkedList<AbstractReceipt>();
        while (!reader.isEndElement() || !reader.getName().toString().equals(XML_RECEIPTS_RECEIPTS)) {
            if (reader.isStartElement() && reader.hasName() && reader.getName().toString().equals("receipt")) {
                AbstractReceipt r;
                logger.finer("-> Found a receipt");
                String type = XmlTools.getOneSingleAttributeValue(reader, "type");
                if (type != null && (r = ReceiptFactory.readFromXml(reader, type)) != null) {
                    result.add(r);
                }
            }
            reader.next();
        }
        return result;
    }
}

