/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins.gui;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.AbstractXMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.NameContainsIllegalCharactersException;
import de.uwemock.eur.calculation.plugins.NameStartsWithNumberException;
import de.uwemock.eur.calculation.plugins.XMLPlugin;
import de.uwemock.eur.calculation.plugins.XMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.XMLPluginSnippet;
import de.uwemock.eur.calculation.plugins.XMLPluginSnippetAsCalculationElement;
import de.uwemock.eur.calculation.plugins.gui.XMLPluginCalculationElementEditor;
import de.uwemock.eur.calculation.plugins.gui.XMLPluginCalculationElementFromSnippetSelector;
import de.uwemock.eur.calculation.plugins.gui.XMLPluginSettingsPanel;
import de.uwemock.eur.calculation.plugins.gui.XMLPluginSnippetTreeModel;
import de.uwemock.eur.calculation.plugins.gui.XMLPluginTreeCellRenderer;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.StandardDialog;
import de.uwemock.guitools.validators.Validator;
import de.uwemock.guitools.validators.ValidatorContext;
import de.uwemock.guitools.validators.ValidatorException;
import de.uwemock.guitools.validators.ValidatorHook;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.TreePath;

public class XMLPluginTree
extends JTree
implements MouseListener,
TreeSelectionListener {
    private static ImageIcon imagePlugin = new ImageIcon(XMLPluginTreeCellRenderer.class.getResource("/icons/plugin.png"));
    private static ImageIcon imageSnippet = new ImageIcon(XMLPluginTreeCellRenderer.class.getResource("/icons/calc.png"));
    private static ImageIcon imageCalcElement = new ImageIcon(XMLPluginTreeCellRenderer.class.getResource("/icons/calcelement.png"));
    private static ImageIcon imageSnippetAsCalcElement = new ImageIcon(XMLPluginTreeCellRenderer.class.getResource("/icons/calcascalcelement.png"));
    private Frame parent;
    private XMLPlugin plugin;
    private XMLPluginSnippetTreeModel model;
    private Action editPluginSettings;
    private Action addSnippetAction;
    private Action addElementAction;
    private Action addSnippetAsElementAction;
    private Action deleteSnippetAction;
    private Action deleteElementAction;
    private Action editSnippetAction;
    private Action editElementAction;
    private TreePath selectedItem;
    private boolean pluginHasChanged = false;

    public XMLPluginTree(Frame parent, XMLPlugin plugin, AccountList accountList) {
        this.parent = parent;
        this.plugin = plugin;
        for (XMLPluginSnippet snippet : this.plugin.getSnippetsList()) {
            for (AbstractXMLPluginCalculationElement element : snippet.getXMLPluginCalculationElementList()) {
                if (!(element instanceof XMLPluginCalculationElement)) continue;
                XMLPluginCalculationElement calcElement = (XMLPluginCalculationElement)element;
                calcElement.setAccountList(accountList);
            }
        }
        this.model = new XMLPluginSnippetTreeModel(plugin, accountList);
        this.setModel(this.model);
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new XMLPluginTreeCellRenderer());
        this.setRowHeight(22);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setTransferHandler(new DnDHandler());
        this.setupActions();
    }

    private void setupActions() {
        this.editPluginSettings = new AbstractAction(TextPool.getString("buttonPluginSettings")){
            {
                this.putValue("SmallIcon", imagePlugin);
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPluginSettingsPanel panel = new XMLPluginSettingsPanel(XMLPluginTree.this.plugin);
                StandardDialog dialog = new StandardDialog(XMLPluginTree.this.parent, TextPool.getString("titlePluginSettings"), panel);
                dialog.setVisible(true);
                XMLPluginTree.this.model.fireElementChanged(new TreePath(XMLPluginTree.this.plugin));
            }
        };
        this.addSnippetAction = new AbstractAction(TextPool.getString("buttonPluginAddSum")){
            {
                this.putValue("SmallIcon", imageSnippet);
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPluginTree.this.addSnippet();
            }
        };
        this.addElementAction = new AbstractAction(TextPool.getString("buttonPluginAddElement")){
            {
                this.putValue("SmallIcon", imageCalcElement);
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPluginTree.this.addElement();
            }
        };
        this.addSnippetAsElementAction = new AbstractAction(TextPool.getString("buttonPluginAddSumAsElement")){
            {
                this.putValue("SmallIcon", imageSnippetAsCalcElement);
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPluginTree.this.addSnippetAsElement();
            }
        };
        this.editSnippetAction = new AbstractAction(TextPool.getString("buttonPluginEditSum")){
            {
                this.putValue("SmallIcon", imageSnippet);
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPluginTree.this.editSnippet();
            }
        };
        this.editElementAction = new AbstractAction(TextPool.getString("buttonPluginEditElement")){
            {
                this.putValue("SmallIcon", imageCalcElement);
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPluginTree.this.editElement();
            }
        };
        this.deleteSnippetAction = new AbstractAction(TextPool.getString("titlePluginDeleteSum")){
            {
                this.putValue("SmallIcon", imageSnippet);
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPluginTree.this.deleteSnippet();
            }
        };
        this.deleteElementAction = new AbstractAction(TextPool.getString("titlePluginDeleteElement")){
            {
                this.putValue("SmallIcon", imageCalcElement);
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPluginTree.this.deleteElement();
            }
        };
        this.enableActions();
    }

    /*
     * Unable to fully structure code
     */
    private void addSnippet() {
        selected = this.selectedItem;
        if (selected != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            selected = selected.getParentPath();
lbl5:
            // 2 sources

            ** while (selected.getPathCount() > 1 && !(selected.getLastPathComponent() instanceof XMLPluginSnippet))
        }
lbl6:
        // 1 sources

        index = 0;
        if (selected.getLastPathComponent() instanceof XMLPluginSnippet) {
            index = this.model.getIndexOfChild(this.plugin, selected.getLastPathComponent()) + 1;
        }
        panel = new InputSnippetData();
        input = new StandardDialog(this.parent, TextPool.getString("titleXMLSnippetNew"), panel);
        input.setVisible(true);
        displayVariableName = panel.getDisplayName();
        description = panel.getDescription();
        outputToResultTable = panel.getOutputToResultTable();
        if (displayVariableName == null) {
            return;
        }
        try {
            snippet = new XMLPluginSnippet(displayVariableName);
            snippet.setOutputToResultTable(outputToResultTable);
            if (description != null) {
                snippet.setDescription(description);
            }
            this.model.addSnippet(snippet, index);
            newPath = selected;
            if (newPath.getLastPathComponent() instanceof XMLPluginSnippet) {
                newPath = newPath.getParentPath();
            }
            this.setSelectionPath(newPath.pathByAddingChild(snippet));
            this.pluginHasChanged = true;
        }
        catch (NameStartsWithNumberException e) {
            e.printStackTrace();
            return;
        }
        catch (NameContainsIllegalCharactersException e) {
            e.printStackTrace();
            return;
        }
    }

    private void addElement() {
        TreePath selected = this.selectedItem;
        if (selected == null) {
            return;
        }
        XMLPluginSnippet parentSnippet = null;
        AbstractXMLPluginCalculationElement selectedElement = null;
        do {
            if (selected.getLastPathComponent() instanceof AbstractXMLPluginCalculationElement) {
                selectedElement = (AbstractXMLPluginCalculationElement)selected.getLastPathComponent();
            }
            if (!(selected.getLastPathComponent() instanceof XMLPluginSnippet)) continue;
            parentSnippet = (XMLPluginSnippet)selected.getLastPathComponent();
        } while ((selected = selected.getParentPath()) != null && (selectedElement == null || parentSnippet == null));
        if (parentSnippet == null) {
            return;
        }
        int index = parentSnippet.getXMLPluginCalculationElementList().size();
        if (selectedElement != null) {
            index = parentSnippet.getXMLPluginCalculationElementList().indexOf(selectedElement) + 1;
        }
        XMLPluginCalculationElementEditor panel = new XMLPluginCalculationElementEditor(DataCenter.getInstance().getAccountList(), DataCenter.getInstance().getTaxList());
        StandardDialog dialog = new StandardDialog(this.parent, TextPool.getString("titlePluginNewElement"), panel);
        dialog.setVisible(true);
        if (panel.getCalculationElement() != null) {
            this.model.addElement(parentSnippet, panel.getCalculationElement(), index);
            this.pluginHasChanged = true;
        }
    }

    private void addSnippetAsElement() {
        TreePath selected = this.selectedItem;
        if (selected == null) {
            return;
        }
        XMLPluginSnippet parentSnippet = null;
        AbstractXMLPluginCalculationElement selectedElement = null;
        do {
            if (selected.getLastPathComponent() instanceof AbstractXMLPluginCalculationElement) {
                selectedElement = (AbstractXMLPluginCalculationElement)selected.getLastPathComponent();
            }
            if (!(selected.getLastPathComponent() instanceof XMLPluginSnippet)) continue;
            parentSnippet = (XMLPluginSnippet)selected.getLastPathComponent();
        } while ((selected = selected.getParentPath()) != null && (selectedElement == null || parentSnippet == null));
        if (parentSnippet == null) {
            return;
        }
        int index = parentSnippet.getXMLPluginCalculationElementList().size();
        if (selectedElement != null) {
            index = parentSnippet.getXMLPluginCalculationElementList().indexOf(selectedElement) + 1;
        }
        XMLPluginCalculationElementFromSnippetSelector panel = new XMLPluginCalculationElementFromSnippetSelector(this.plugin, parentSnippet);
        StandardDialog dialog = new StandardDialog(this.parent, TextPool.getString("titlePluginSumAsNewElement"), panel);
        dialog.setVisible(true);
        if (panel.getCalculationElement() != null) {
            this.model.addElement(parentSnippet, panel.getCalculationElement(), index);
            this.pluginHasChanged = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void editSnippet() {
        selected = this.selectedItem;
        if (selected != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            selected = selected.getParentPath();
lbl5:
            // 2 sources

            ** while (selected.getPathCount() > 1 && !(selected.getLastPathComponent() instanceof XMLPluginSnippet))
        }
lbl6:
        // 1 sources

        if (selected.getLastPathComponent() instanceof XMLPluginSnippet) {
            snippet = (XMLPluginSnippet)selected.getLastPathComponent();
            panel = new InputSnippetData(snippet);
            input = new StandardDialog(this.parent, TextPool.getString("titleXMLSnippetEdit"), panel);
            input.setVisible(true);
            if (panel.getDisplayName() != null) {
                try {
                    snippet.setDisplayVariableName(panel.getDisplayName());
                    snippet.setDescription(panel.getDescription());
                    snippet.setOutputToResultTable(panel.getOutputToResultTable());
                    this.model.fireElementChanged(selected);
                    this.pluginHasChanged = true;
                }
                catch (NameContainsIllegalCharactersException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void editElement() {
        selected = this.selectedItem;
        if (selected != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            selected = selected.getParentPath();
lbl5:
            // 2 sources

            ** while (selected.getPathCount() > 1 && !(selected.getLastPathComponent() instanceof AbstractXMLPluginCalculationElement))
        }
lbl6:
        // 1 sources

        if (!(selected.getLastPathComponent() instanceof AbstractXMLPluginCalculationElement)) {
            return;
        }
        if (selected.getLastPathComponent() instanceof XMLPluginCalculationElement) {
            element /* !! */  = (XMLPluginCalculationElement)selected.getLastPathComponent();
            editor = new XMLPluginCalculationElementEditor(DataCenter.getInstance().getAccountList(), DataCenter.getInstance().getTaxList(), element /* !! */ );
            dialog = new StandardDialog(this.parent, TextPool.getString("titleXMLCalculationElementEdit"), editor);
            dialog.setVisible(true);
            if (dialog.getResult() == 1) {
                this.model.fireElementChanged(selected);
                this.pluginHasChanged = true;
            }
        }
        if (selected.getLastPathComponent() instanceof XMLPluginSnippetAsCalculationElement) {
            element /* !! */  = (XMLPluginSnippetAsCalculationElement)selected.getLastPathComponent();
            parentSnippet = (XMLPluginSnippet)selected.getParentPath().getLastPathComponent();
            editor = new XMLPluginCalculationElementFromSnippetSelector(this.plugin, parentSnippet, (XMLPluginSnippetAsCalculationElement)element /* !! */ );
            dialog = new StandardDialog(this.parent, TextPool.getString("titleXMLCalculationElementEdit"), editor);
            dialog.setVisible(true);
            if (dialog.getResult() == 1) {
                this.model.fireElementChanged(selected);
                this.pluginHasChanged = true;
            }
        }
    }

    private void deleteSelectedItem() {
        if (this.selectedItem == null) {
            return;
        }
        XMLPluginSnippet deletedSnippet = null;
        String message = null;
        if (this.selectedItem.getLastPathComponent() instanceof XMLPluginSnippet) {
            deletedSnippet = (XMLPluginSnippet)this.selectedItem.getLastPathComponent();
            message = TextPool.getString("msgXMLPluginDeleteSum");
        }
        if (this.selectedItem.getLastPathComponent() instanceof AbstractXMLPluginCalculationElement) {
            message = TextPool.getString("msgXMLPluginDeleteElement");
        }
        if (message == null) {
            return;
        }
        int res = JOptionPane.showConfirmDialog(this.parent, message, TextPool.getString("titleDeletePluginElement"), 0);
        if (res == 0) {
            this.model.deleteElement(this.selectedItem);
        }
        if (deletedSnippet != null) {
            LinkedList<TreePath> pathsToDelete = new LinkedList<TreePath>();
            for (XMLPluginSnippet snippet : this.plugin.getSnippetsList()) {
                for (AbstractXMLPluginCalculationElement element : snippet.getXMLPluginCalculationElementList()) {
                    XMLPluginSnippetAsCalculationElement snippetAsElement;
                    if (!(element instanceof XMLPluginSnippetAsCalculationElement) || (snippetAsElement = (XMLPluginSnippetAsCalculationElement)element).getSnippet() != deletedSnippet) continue;
                    pathsToDelete.add(new TreePath(new Object[]{this.plugin, snippet, snippetAsElement}));
                }
            }
            for (TreePath path : pathsToDelete) {
                this.model.deleteElement(path);
            }
            this.pluginHasChanged = true;
        }
    }

    private void deleteSnippet() {
        this.deleteSelectedItem();
    }

    private void deleteElement() {
        this.deleteSelectedItem();
    }

    private void enableActions() {
        boolean itemSelected = this.isItemSelected();
        boolean rootSelected = this.isRootSelected();
        boolean snippetSelected = this.isSnippetSelected();
        boolean elementSelected = this.isCalculationElementSelected();
        boolean accountSelected = this.isAccountSelected();
        this.addElementAction.setEnabled(itemSelected && (snippetSelected || elementSelected));
        this.addSnippetAsElementAction.setEnabled(itemSelected && (snippetSelected || elementSelected) && this.plugin.getSnippetsList().size() > 0);
        this.addSnippetAction.setEnabled(itemSelected && (rootSelected || snippetSelected));
        this.deleteElementAction.setEnabled(itemSelected && elementSelected);
        this.deleteSnippetAction.setEnabled(itemSelected && snippetSelected);
        this.editSnippetAction.setEnabled(itemSelected && (snippetSelected || elementSelected || accountSelected));
        this.editElementAction.setEnabled(itemSelected && (elementSelected || accountSelected));
    }

    public boolean isItemSelected() {
        return this.selectedItem != null;
    }

    public boolean isRootSelected() {
        return this.isItemSelected() && this.selectedItem.getLastPathComponent() instanceof XMLPlugin;
    }

    public boolean isSnippetSelected() {
        return this.isItemSelected() && this.selectedItem.getLastPathComponent() instanceof XMLPluginSnippet;
    }

    public boolean isCalculationElementSelected() {
        return this.isItemSelected() && this.selectedItem.getLastPathComponent() instanceof AbstractXMLPluginCalculationElement;
    }

    public boolean isAccountSelected() {
        return this.isItemSelected() && this.selectedItem.getLastPathComponent() instanceof Account;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.selectedItem = e.getPath();
        this.enableActions();
    }

    public Action getEditPluginSettingsAction() {
        return this.editPluginSettings;
    }

    public Action getAddSnippetAction() {
        return this.addSnippetAction;
    }

    public Action getAddSnippetAsElementAction() {
        return this.addSnippetAsElementAction;
    }

    public Action getAddElementAction() {
        return this.addElementAction;
    }

    public Action getDeleteSnippetAction() {
        return this.deleteSnippetAction;
    }

    public Action getDeleteElementAction() {
        return this.deleteElementAction;
    }

    public Action getEditSnippetAction() {
        return this.editSnippetAction;
    }

    public Action getEditElementAction() {
        return this.editElementAction;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JTree tree;
        TreePath path;
        if (e.isPopupTrigger() && (path = (tree = (JTree)e.getComponent()).getPathForLocation(e.getX(), e.getY())) != null) {
            tree.setSelectionPath(path);
            this.selectedItem = path;
            this.showPopupMenu(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JTree tree;
        TreePath path;
        if (e.isPopupTrigger() && (path = (tree = (JTree)e.getComponent()).getPathForLocation(e.getX(), e.getY())) != null) {
            tree.setSelectionPath(path);
            this.selectedItem = path;
            this.showPopupMenu(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void showPopupMenu(Component component, int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        if (this.isRootSelected()) {
            menu.add(this.editPluginSettings);
        }
        if (this.isSnippetSelected() || this.isRootSelected()) {
            menu.add(this.addSnippetAction);
        }
        if (this.isSnippetSelected()) {
            menu.add(this.editSnippetAction);
            menu.add(this.deleteSnippetAction);
        }
        if ((this.isSnippetSelected() || this.isRootSelected()) && (this.isSnippetSelected() || this.isCalculationElementSelected())) {
            menu.addSeparator();
        }
        if (this.isSnippetSelected() || this.isCalculationElementSelected()) {
            menu.add(this.addElementAction);
            menu.add(this.addSnippetAsElementAction);
        }
        if (this.isCalculationElementSelected()) {
            menu.add(this.editElementAction);
            menu.add(this.deleteElementAction);
        }
        menu.show(component, x, y);
    }

    public boolean pluginHasChanged() {
        return this.pluginHasChanged;
    }

    class DnDHandler
    extends TransferHandler {
        DnDHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            Transferable transferable = support.getTransferable();
            if (transferable == null) {
                return false;
            }
            Object dragItem = null;
            TreePath[] paths = null;
            try {
                paths = (TreePath[])transferable.getTransferData(DataFlavor.javaFileListFlavor);
                dragItem = paths[0].getLastPathComponent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dragItem == null) {
                return false;
            }
            if (!(dragItem instanceof XMLPluginSnippet || dragItem instanceof AbstractXMLPluginCalculationElement || dragItem instanceof Account)) {
                return false;
            }
            if (support.isDrop()) {
                JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
                if (dropLocation == null) {
                    return false;
                }
                int childIndex = dropLocation.getChildIndex();
                TreePath dropPath = dropLocation.getPath();
                Object dropElement = dropPath.getLastPathComponent();
                if (!(!(dragItem instanceof XMLPluginSnippet) || dropElement instanceof XMLPlugin || dropElement instanceof XMLPluginSnippet && childIndex < 0)) {
                    return false;
                }
                if (dragItem instanceof AbstractXMLPluginCalculationElement && !(dropElement instanceof XMLPluginSnippet) && !(dropElement instanceof AbstractXMLPluginCalculationElement)) {
                    return false;
                }
                if (dragItem instanceof Account) {
                    if (!(dropElement instanceof XMLPluginCalculationElement)) {
                        return false;
                    }
                    XMLPluginCalculationElement element = (XMLPluginCalculationElement)dropElement;
                    Account account = (Account)dragItem;
                    if (element.getAccounts().contains(account.getAccountNumber())) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable transferable = support.getTransferable();
            TreePath[] paths = null;
            try {
                paths = (TreePath[])transferable.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            XMLPluginSnippetTreeModel treeModel = XMLPluginTree.this.model;
            TreePath dragPath = paths[0];
            Object dragItem = dragPath.getLastPathComponent();
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            TreePath dropPath = dl.getPath();
            int childIndex = dl.getChildIndex();
            int oldIndex = XMLPluginTree.this.model.getIndexOfChild(dropPath.getLastPathComponent(), dragItem);
            if (oldIndex >= 0 && oldIndex < childIndex) {
                --childIndex;
            }
            if (dragItem instanceof AbstractXMLPluginCalculationElement) {
                if (dropPath.getLastPathComponent() instanceof XMLPluginSnippet) {
                    treeModel.deleteElement(dragPath);
                    if (childIndex < 0) {
                        childIndex = ((XMLPluginSnippet)dropPath.getLastPathComponent()).getXMLPluginCalculationElementList().size();
                    }
                    treeModel.addElement((XMLPluginSnippet)dropPath.getLastPathComponent(), (AbstractXMLPluginCalculationElement)dragItem, childIndex);
                    XMLPluginTree.this.pluginHasChanged = true;
                    return true;
                }
                if (dropPath.getLastPathComponent() instanceof AbstractXMLPluginCalculationElement) {
                    treeModel.deleteElement(dragPath);
                    if (childIndex < 0) {
                        childIndex = treeModel.getIndexOfChild(dropPath.getParentPath().getLastPathComponent(), dropPath.getLastPathComponent()) + 1;
                    }
                    treeModel.addElement((XMLPluginSnippet)dropPath.getParentPath().getLastPathComponent(), (AbstractXMLPluginCalculationElement)dragItem, childIndex);
                    XMLPluginTree.this.pluginHasChanged = true;
                    return true;
                }
            }
            if (dragItem instanceof XMLPluginSnippet) {
                if (dropPath.getLastPathComponent() instanceof XMLPlugin) {
                    treeModel.deleteElement(dragPath);
                    if (childIndex < 0) {
                        childIndex = ((XMLPlugin)dropPath.getLastPathComponent()).getSnippetsList().size();
                    }
                    treeModel.addSnippet((XMLPluginSnippet)dragItem, childIndex);
                    XMLPluginTree.this.pluginHasChanged = true;
                    return true;
                }
                if (dropPath.getLastPathComponent() instanceof XMLPluginSnippet) {
                    treeModel.deleteElement(dragPath);
                    if (childIndex < 0) {
                        childIndex = treeModel.getIndexOfChild(dropPath.getParentPath().getLastPathComponent(), dropPath.getLastPathComponent()) + 1;
                    }
                    treeModel.addSnippet((XMLPluginSnippet)dragItem, childIndex);
                    XMLPluginTree.this.pluginHasChanged = true;
                    return true;
                }
            }
            if (dragItem instanceof Account) {
                Account account = (Account)dragItem;
                Integer accountNumber = account.getAccountNumber();
                XMLPluginCalculationElement element = (XMLPluginCalculationElement)dragPath.getParentPath().getLastPathComponent();
                element.getAccounts().remove(accountNumber);
                element = (XMLPluginCalculationElement)dropPath.getLastPathComponent();
                element.getAccounts().add(accountNumber);
                Collections.sort(element.getAccounts());
                treeModel.fireElementDeleted(dragPath);
                treeModel.fireElementInserted(dropPath);
                XMLPluginTree.this.pluginHasChanged = true;
                return true;
            }
            if (dragItem instanceof Integer) {
                XMLPluginCalculationElement element = (XMLPluginCalculationElement)dragPath.getParentPath().getLastPathComponent();
                element.getAccounts().remove(dragItem);
                element = (XMLPluginCalculationElement)dropPath.getLastPathComponent();
                element.getAccounts().add((Integer)dragItem);
                Collections.sort(element.getAccounts());
                treeModel.fireElementDeleted(dragPath);
                treeModel.fireElementInserted(dropPath);
                XMLPluginTree.this.pluginHasChanged = true;
                return true;
            }
            return false;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTree tree = (JTree)c;
            TreePath[] values = tree.getSelectionPaths();
            return new TreeTransferData(values);
        }
    }

    class InputSnippetData
    extends AbstractStandardDialogPanel {
        private String displayName;
        private String description;
        private boolean output = true;
        private JTextField inputDisplayName = new JTextField(40);
        private JTextField inputDescription = new JTextField(40);
        private JCheckBox outputToResultTable = new JCheckBox(TextPool.getString("labelXMLPluginSnippetOutputToResultTable"));
        private Action okAction;
        private XMLPluginSnippet editingSnippet;

        public InputSnippetData() {
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelXMLPluginSnippetDisplayName")), 0, 0, 1, 1, 0.0, 0.0);
            GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelXMLPluginSnippetDescription")), 0, 1, 1, 1, 0.0, 0.0);
            GuiTools.addComponent(this, gbl, this.inputDisplayName, 1, 0, 1, 1, 1.0, 0.0);
            GuiTools.addComponent(this, gbl, this.inputDescription, 1, 1, 1, 1, 1.0, 0.0);
            GuiTools.addComponent(this, gbl, this.outputToResultTable, 0, 2, 2, 1, 0.0, 0.0);
            new ValidatorHook(this.inputDisplayName, new Validator(){

                @Override
                public void insert(ValidatorContext context) throws ValidatorException {
                    StringBuilder sb;
                    try {
                        sb = new StringBuilder(context.document.getText(0, context.document.getLength()));
                        sb.insert(context.offset, context.str);
                    }
                    catch (BadLocationException b) {
                        sb = new StringBuilder();
                    }
                    InputSnippetData.this.enableActions(sb.toString());
                }

                @Override
                public void remove(ValidatorContext context) throws ValidatorException {
                    StringBuilder sb;
                    try {
                        sb = new StringBuilder(context.document.getText(0, context.document.getLength()));
                        sb.delete(context.offset, context.offset + context.length);
                    }
                    catch (BadLocationException b) {
                        sb = new StringBuilder();
                    }
                    InputSnippetData.this.enableActions(sb.toString());
                }
            });
        }

        public InputSnippetData(XMLPluginSnippet snippet) {
            this();
            this.editingSnippet = snippet;
            if (snippet.getDisplayVariableName() != null) {
                this.inputDisplayName.setText(snippet.getDisplayVariableName());
            }
            if (snippet.getDescription() != null) {
                this.inputDescription.setText(snippet.getDescription());
            }
            this.output = snippet.doOutputToResultTable();
        }

        private void enableActions(String newDisplayName) {
            if (this.okAction == null) {
                return;
            }
            if (!XMLPluginSnippet.isValidVariableName(newDisplayName)) {
                this.okAction.setEnabled(false);
                return;
            }
            for (XMLPluginSnippet snippet : XMLPluginTree.this.plugin.getSnippetsList()) {
                if (snippet == this.editingSnippet || !snippet.getDisplayVariableName().equals(newDisplayName)) continue;
                this.okAction.setEnabled(false);
                return;
            }
            this.okAction.setEnabled(true);
        }

        @Override
        public void dialogOpens() {
            this.enableActions(this.inputDisplayName.getText());
            this.outputToResultTable.setSelected(this.output);
        }

        @Override
        public void saveDialogData() {
            this.displayName = this.inputDisplayName.getText();
            this.description = this.inputDescription.getText();
            this.output = this.outputToResultTable.isSelected();
        }

        @Override
        public void setOkAction(Action okAction) {
            this.okAction = okAction;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean getOutputToResultTable() {
            return this.output;
        }
    }

    class TreeTransferData
    implements Transferable {
        private TreePath[] pathData;

        public TreeTransferData(TreePath[] pathData) {
            this.pathData = pathData;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.pathData;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return null;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return true;
        }
    }
}

