/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins.gui;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.AbstractXMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.XMLPlugin;
import de.uwemock.eur.calculation.plugins.XMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.XMLPluginSnippet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class XMLPluginSnippetTreeModel
implements TreeModel {
    private ArrayList<TreeModelListener> listener = new ArrayList();
    private XMLPlugin plugin;
    private AccountList accountList;

    public XMLPluginSnippetTreeModel(XMLPlugin plugin, AccountList accountList) {
        this.plugin = plugin;
        this.accountList = accountList;
    }

    public void addSnippet(XMLPluginSnippet snippet) {
        List<XMLPluginSnippet> snippets = this.plugin.getSnippetsList();
        this.addSnippet(snippet, snippets.size());
    }

    public void addSnippet(XMLPluginSnippet snippet, int index) {
        List<XMLPluginSnippet> snippets = this.plugin.getSnippetsList();
        if (index < 0 || index > snippets.size()) {
            index = snippets.size();
        }
        snippets.add(index, snippet);
        this.fireElementInserted(new TreePath(this.getRoot()));
    }

    public void addElement(XMLPluginSnippet snippet, AbstractXMLPluginCalculationElement element) {
        List<AbstractXMLPluginCalculationElement> elements = snippet.getXMLPluginCalculationElementList();
        this.addElement(snippet, element, elements.size());
    }

    public void addElement(XMLPluginSnippet snippet, AbstractXMLPluginCalculationElement element, int index) {
        List<AbstractXMLPluginCalculationElement> elements = snippet.getXMLPluginCalculationElementList();
        if (index < 0 || index > elements.size()) {
            index = elements.size();
        }
        elements.add(index, element);
        this.fireElementInserted(new TreePath(this.getRoot()).pathByAddingChild(snippet));
    }

    public void deleteElement(TreePath path) {
        Object objectToBeDeleted = path.getLastPathComponent();
        if (objectToBeDeleted instanceof XMLPluginSnippet) {
            this.plugin.getSnippetsList().remove(objectToBeDeleted);
        }
        if (objectToBeDeleted instanceof AbstractXMLPluginCalculationElement) {
            XMLPluginSnippet snippet = (XMLPluginSnippet)path.getParentPath().getLastPathComponent();
            snippet.getXMLPluginCalculationElementList().remove(objectToBeDeleted);
        }
        this.fireElementDeleted(path);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof XMLPlugin) {
            XMLPlugin plugin = (XMLPlugin)parent;
            return plugin.getSnippetsList().get(index);
        }
        if (parent instanceof XMLPluginSnippet) {
            XMLPluginSnippet pluginSnippet = (XMLPluginSnippet)parent;
            return pluginSnippet.getXMLPluginCalculationElementList().get(index);
        }
        if (parent instanceof XMLPluginCalculationElement) {
            XMLPluginCalculationElement calculationElement = (XMLPluginCalculationElement)parent;
            List<Integer> accounts = calculationElement.getAccounts();
            Account account = this.accountList.getByAccountNumber(accounts.get(index));
            if (account != null) {
                return account;
            }
            return accounts.get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof XMLPlugin) {
            XMLPlugin plugin = (XMLPlugin)parent;
            return plugin.getSnippetsList().size();
        }
        if (parent instanceof XMLPluginSnippet) {
            XMLPluginSnippet pluginSnippet = (XMLPluginSnippet)parent;
            return pluginSnippet.getXMLPluginCalculationElementList().size();
        }
        if (parent instanceof XMLPluginCalculationElement) {
            XMLPluginCalculationElement calculationElement = (XMLPluginCalculationElement)parent;
            List<Integer> accounts = calculationElement.getAccounts();
            return accounts.size();
        }
        return -1;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof XMLPlugin) {
            XMLPlugin plugin = (XMLPlugin)parent;
            return plugin.getSnippetsList().indexOf(child);
        }
        if (parent instanceof XMLPluginSnippet) {
            XMLPluginSnippet pluginSnippet = (XMLPluginSnippet)parent;
            return pluginSnippet.getXMLPluginCalculationElementList().indexOf(child);
        }
        if (parent instanceof XMLPluginCalculationElement) {
            XMLPluginCalculationElement calculationElement = (XMLPluginCalculationElement)parent;
            List<Integer> accounts = calculationElement.getAccounts();
            if (child instanceof Integer) {
                return accounts.indexOf(child);
            }
            if (child instanceof Account) {
                Account account = (Account)child;
                return accounts.indexOf(account.getAccountNumber());
            }
        }
        return 0;
    }

    @Override
    public Object getRoot() {
        return this.plugin;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof Account || node instanceof Integer;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listener.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listener.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    public void fireElementInserted(TreePath path) {
        TreeModelEvent event = new TreeModelEvent((Object)this, path);
        for (TreeModelListener l : this.listener) {
            l.treeStructureChanged(event);
        }
    }

    public void fireElementChanged(TreePath path) {
        TreeModelEvent event = new TreeModelEvent((Object)this, path);
        for (TreeModelListener l : this.listener) {
            l.treeStructureChanged(event);
        }
    }

    public void fireElementDeleted(TreePath path) {
        TreeModelEvent event = new TreeModelEvent((Object)this, path.getParentPath());
        for (TreeModelListener l : this.listener) {
            l.treeStructureChanged(event);
        }
    }
}

