/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins.gui;

import de.uwemock.eur.calculation.plugins.XMLPlugin;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.validators.BlockEmptyInputValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import java.awt.GridBagLayout;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class XMLPluginSettingsPanel
extends AbstractStandardDialogPanel {
    private XMLPlugin plugin;
    private JTextField pluginTitle = new JTextField(60);
    private JCheckBox pluginAsksForTimeFrame = new JCheckBox(TextPool.getString("labelPluginTimeFrame"));

    public XMLPluginSettingsPanel(XMLPlugin plugin) {
        this.plugin = plugin;
        GridBagLayout extraLayout = new GridBagLayout();
        JPanel extraPanel = new JPanel(extraLayout);
        extraPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleMiscellaneousSettings")));
        GuiTools.addComponent(extraPanel, extraLayout, this.pluginAsksForTimeFrame, 0, 0, 1, 1, 1.0, 0.0);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GuiTools.addComponent(this, gbl, new JLabel(String.valueOf(TextPool.getString("labelPluginTitle")) + ":"), 0, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.pluginTitle, 1, 0, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(this, gbl, extraPanel, 0, 1, 2, 1, 1.0, 0.0);
    }

    @Override
    public void dialogOpens() {
        this.pluginTitle.setText(this.plugin.getPluginTitle());
        this.pluginAsksForTimeFrame.setSelected(this.plugin.doAskForTimeFrame());
    }

    @Override
    public void saveDialogData() {
        this.plugin.setPluginTitle(this.pluginTitle.getText());
        this.plugin.setAskForTimeFrame(this.pluginAsksForTimeFrame.isSelected());
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titlePluginSettings");
    }

    @Override
    public void setOkAction(Action okAction) {
        new ValidatorHook(this.pluginTitle, new BlockEmptyInputValidator(okAction));
    }
}

