/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins.gui;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.AbstractXMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.XMLPlugin;
import de.uwemock.eur.calculation.plugins.XMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.XMLPluginSnippet;
import de.uwemock.eur.calculation.plugins.gui.XMLPluginTree;
import de.uwemock.eur.calculation.plugins.gui.XMLPluginTreeCellRenderer;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.htmltools.HtmlTools;
import de.uwemock.tools.Numbers;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class XMLPluginEditPanel
extends AbstractStandardDialogPanel {
    private Frame parent;
    private AccountList accountList;
    private XMLPlugin plugin;
    private XMLPlugin result;
    private JList statusDisplay;
    private XMLPluginTree pluginTree;
    private Action okAction;

    public XMLPluginEditPanel(Frame parent, AccountList accountList, XMLPlugin plugin) {
        this.parent = parent;
        this.accountList = accountList;
        this.plugin = plugin;
        this.createComponentTree();
    }

    public XMLPluginEditPanel(Frame parent, AccountList accountList, String pluginTitle) {
        this(parent, accountList, new XMLPlugin(pluginTitle));
    }

    private void createComponentTree() {
        JPanel topPanel = new JPanel(new BorderLayout(10, 0));
        topPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleXMLPluginEdit")));
        this.pluginTree = new XMLPluginTree(this.parent, this.plugin, this.accountList);
        this.pluginTree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                XMLPluginEditPanel.this.updatePluginStatus();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                XMLPluginEditPanel.this.updatePluginStatus();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                XMLPluginEditPanel.this.updatePluginStatus();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                XMLPluginEditPanel.this.updatePluginStatus();
            }
        });
        JScrollPane scroller = new JScrollPane(this.pluginTree);
        scroller.setPreferredSize(new Dimension(400, 300));
        topPanel.add("Center", scroller);
        JPanel buttonPanel = new JPanel(new GridLayout(12, 1, 0, 10));
        buttonPanel.add(new JButton(this.pluginTree.getEditPluginSettingsAction()));
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(new JButton(this.pluginTree.getAddSnippetAction()));
        buttonPanel.add(new JButton(this.pluginTree.getEditSnippetAction()));
        buttonPanel.add(new JButton(this.pluginTree.getDeleteSnippetAction()));
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(new JButton(this.pluginTree.getAddElementAction()));
        buttonPanel.add(new JButton(this.pluginTree.getAddSnippetAsElementAction()));
        buttonPanel.add(new JButton(this.pluginTree.getEditElementAction()));
        buttonPanel.add(new JButton(this.pluginTree.getDeleteElementAction()));
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(new JButton(new AbstractAction(TextPool.getString("buttonPrintPlugin")){
            {
                this.putValue("SmallIcon", new ImageIcon(XMLPluginTreeCellRenderer.class.getResource("/icons/printer.png")));
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPluginEditPanel.this.printPlugin();
            }
        }));
        Component[] componentArray = buttonPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JButton) {
                JButton button = (JButton)c;
                button.setHorizontalAlignment(2);
            }
            ++n2;
        }
        topPanel.add("East", buttonPanel);
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titlePluginStatus")));
        this.statusDisplay = new JList(new DefaultListModel());
        this.statusDisplay.setForeground(Color.RED);
        statusPanel.add("Center", new JScrollPane(this.statusDisplay));
        this.setLayout(new BorderLayout());
        this.add("Center", topPanel);
        this.add("South", statusPanel);
    }

    private void updatePluginStatus() {
        LinkedList<String> errors = new LinkedList<String>();
        for (XMLPluginSnippet snippet : this.plugin.getSnippetsList()) {
            if (!XMLPluginSnippet.isRecursive(snippet)) continue;
            errors.add(String.format(TextPool.getString("msgXMLPluginRecursion"), snippet.getDisplayVariableName()));
        }
        this.okAction.setEnabled(errors.size() == 0);
        ArrayList<Integer> accounts = new ArrayList<Integer>(DataCenter.getInstance().getAccountList().size());
        for (Account account : DataCenter.getInstance().getAccountList()) {
            accounts.add(account.getAccountNumber());
        }
        for (XMLPluginSnippet snippet : this.plugin.getSnippetsList()) {
            for (AbstractXMLPluginCalculationElement element : snippet.getXMLPluginCalculationElementList()) {
                if (!(element instanceof XMLPluginCalculationElement)) continue;
                XMLPluginCalculationElement calcElement = (XMLPluginCalculationElement)element;
                accounts.removeAll(calcElement.getAccounts());
            }
        }
        for (Integer accountNumber : accounts) {
            Account account = this.accountList.getByAccountNumber(accountNumber);
            if (account == null || !account.isVisible()) continue;
            errors.add(String.format(TextPool.getString("msgXMLPluginAccountNotUsed"), account.getAccountNumber(), account.getAccountName()));
        }
        DefaultListModel model = (DefaultListModel)this.statusDisplay.getModel();
        model.clear();
        for (Object e : errors) {
            model.addElement(e);
        }
    }

    @Override
    public void dialogOpens() {
        this.updatePluginStatus();
    }

    @Override
    public void saveDialogData() {
        this.result = this.plugin;
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }

    @Override
    public boolean mayBeCancelled() {
        if (this.pluginTree.pluginHasChanged()) {
            int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgUnsavedData"), TextPool.getString("titleDialogClosing"), 0);
            return res == 0;
        }
        return true;
    }

    public XMLPlugin getPlugin() {
        return this.result;
    }

    public void printPlugin() {
        HtmlContext html = new HtmlContext();
        String title = String.valueOf(TextPool.getString("titlePluginPrintOutput")) + " \"" + this.plugin.getPluginTitle() + "\"";
        html.setTitle(title);
        html.addElement("h1", null, null, null, title);
        HtmlTable table = new HtmlTable(html);
        table.setBorder("none");
        table.setCellspacing("0px");
        table.setCellpadding("0px");
        int row = 0;
        for (XMLPluginSnippet snippet : this.plugin.getSnippetsList()) {
            table.setContents(0, row, HtmlTools.bold(snippet.getDisplayVariableName()));
            table.setNoWrap(0, row, true);
            table.setAlign(0, row, "top");
            table.setContents(1, row, "&nbsp;&nbsp;");
            table.setContents(2, row, HtmlTools.bold(snippet.getDescription()));
            table.setColspan(2, row, 5);
            table.setContents(2, row + 1, "=");
            table.setAlign(2, row + 1, "top");
            for (AbstractXMLPluginCalculationElement element : snippet.getXMLPluginCalculationElementList()) {
                table.setContents(3, ++row, element.getPrefix().toString());
                table.setAlign(3, row, "top");
                table.setCssStyle(3, row, "vertical-align:top;");
                if (!element.getFactor().equals(Numbers.BIG_DECIMAL_ONE)) {
                    table.setContents(4, row, element.getFactor().toPlainString());
                    table.setAlign(4, row, "top");
                    table.setContents(4, row, "\u0087");
                    table.setAlign(5, row, "top");
                }
                table.setContents(6, row, element.getPrintOutputString());
                table.setNoWrap(6, row, true);
            }
            ++row;
        }
        html.addElement(table);
        DataCenter.getInstance().showHTML(html.toStringBuffer());
    }
}

