/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins.gui;

import chrriis.dj.swingsuite.JWidePopupComboBox;
import de.uwemock.eur.calculation.plugins.CalcPrefix;
import de.uwemock.eur.calculation.plugins.XMLPlugin;
import de.uwemock.eur.calculation.plugins.XMLPluginSnippet;
import de.uwemock.eur.calculation.plugins.XMLPluginSnippetAsCalculationElement;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.validators.FloatValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import de.uwemock.tools.Numbers;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class XMLPluginCalculationElementFromSnippetSelector
extends AbstractStandardDialogPanel {
    private JComboBox prefixSelection;
    private JTextField factorInput;
    private JWidePopupComboBox snippetSelection;
    private XMLPluginSnippet parentSnippet;
    private XMLPluginSnippetAsCalculationElement tempSnippet;
    private XMLPluginSnippetAsCalculationElement resultSnippet;
    private Action okAction;

    public XMLPluginCalculationElementFromSnippetSelector(XMLPlugin plugin, XMLPluginSnippet parentSnippet) {
        this(plugin, parentSnippet, null);
    }

    public XMLPluginCalculationElementFromSnippetSelector(XMLPlugin plugin, XMLPluginSnippet parentSnippet, XMLPluginSnippetAsCalculationElement snippetCalcElement) {
        this.tempSnippet = snippetCalcElement != null ? snippetCalcElement : new XMLPluginSnippetAsCalculationElement(null);
        this.parentSnippet = parentSnippet;
        this.prefixSelection = new JComboBox<CalcPrefix>(new CalcPrefix[]{CalcPrefix.PLUS, CalcPrefix.MINUS});
        this.factorInput = new JTextField(10);
        new ValidatorHook(this.factorInput, new FloatValidator(3));
        this.snippetSelection = new JWidePopupComboBox(plugin.getSnippetsList().toArray());
        this.snippetSelection.setPreferredWidth(300);
        this.snippetSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLPluginCalculationElementFromSnippetSelector.this.enableOkAction();
            }
        });
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GuiTools.addComponent(this, gbl, this.prefixSelection, 0, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.factorInput, 1, 0, 1, 1, 0.5, 0.0);
        GuiTools.addComponent(this, gbl, new JLabel("*"), 2, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.snippetSelection, 3, 0, 1, 1, 0.5, 0.0);
    }

    private void enableOkAction() {
        this.okAction.setEnabled(this.snippetSelection.getSelectedItem() != this.parentSnippet);
    }

    @Override
    public void dialogOpens() {
        if (this.tempSnippet != null) {
            this.prefixSelection.setSelectedItem((Object)this.tempSnippet.getPrefix());
            this.factorInput.setText(this.tempSnippet.getFactor().toPlainString());
            if (this.tempSnippet.getSnippet() != null) {
                this.snippetSelection.setSelectedItem(this.tempSnippet.getSnippet());
            }
        }
        this.enableOkAction();
    }

    @Override
    public void saveDialogData() {
        XMLPluginSnippet snippet = (XMLPluginSnippet)this.snippetSelection.getSelectedItem();
        this.tempSnippet.setSnippet(snippet);
        this.tempSnippet.setPrefix((CalcPrefix)((Object)this.prefixSelection.getSelectedItem()));
        this.tempSnippet.setFactor(Numbers.getBigDecimalFromString(this.factorInput.getText(), Numbers.BIG_DECIMAL_ONE));
        this.resultSnippet = this.tempSnippet;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }

    public XMLPluginSnippetAsCalculationElement getCalculationElement() {
        return this.resultSnippet;
    }
}

