/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins.gui;

import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.accounts.gui.AccountAddAndRemovePanel;
import de.uwemock.eur.calculation.plugins.AbstractXMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.CalcPrefix;
import de.uwemock.eur.calculation.plugins.XMLPluginCalculationElement;
import de.uwemock.eur.data.Tax;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.data.gui.TaxComboBox;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.ComponentEnabler;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.validators.FloatValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import de.uwemock.tools.Numbers;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class XMLPluginCalculationElementEditor
extends AbstractStandardDialogPanel {
    private AccountList accountList;
    private TaxList taxList;
    private XMLPluginCalculationElement element;
    private XMLPluginCalculationElement result;
    private AccountAddAndRemovePanel accountSelection;
    private TaxComboBox taxSelection;
    private JComboBox outputTypeSelection;
    private JComboBox prefixSelection;
    private JComboBox monthStart;
    private JComboBox monthEnd;
    private JTextField factorInput;
    private JCheckBox rangeNotSelected;
    private Action okAction;

    public XMLPluginCalculationElementEditor(AccountList accountList, TaxList taxList) {
        this(accountList, taxList, null);
    }

    public XMLPluginCalculationElementEditor(AccountList accountList, TaxList taxList, XMLPluginCalculationElement element) {
        if (accountList == null) {
            throw new IllegalArgumentException("No accounts list given in " + this.getClass().getCanonicalName());
        }
        if (taxList == null) {
            throw new IllegalArgumentException("No tax list given in " + this.getClass().getCanonicalName());
        }
        this.accountList = accountList;
        this.taxList = taxList;
        this.element = element != null ? element : new XMLPluginCalculationElement();
        this.createComponentTree();
    }

    private void createComponentTree() {
        this.accountSelection = new AccountAddAndRemovePanel(this.accountList);
        this.taxSelection = new TaxComboBox(this.taxList, true);
        this.outputTypeSelection = new JComboBox<String>(TextPool.getArray("INCLUDING_EXCLUDING_TAX"));
        this.prefixSelection = new JComboBox<CalcPrefix>(new CalcPrefix[]{CalcPrefix.PLUS, CalcPrefix.MINUS});
        this.factorInput = new JTextField(10);
        new ValidatorHook(this.factorInput, new FloatValidator(3));
        this.monthStart = new JComboBox<String>(TextPool.MONTHS);
        this.monthEnd = new JComboBox<String>(TextPool.MONTHS);
        this.rangeNotSelected = new JCheckBox(TextPool.getString("labelXMLPluginCalculationElementRangeNotSelected"));
        ComponentEnabler enabler = new ComponentEnabler(this.rangeNotSelected, false);
        enabler.addComponent(this.monthStart);
        enabler.addComponent(this.monthEnd);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GuiTools.addComponent(this, gbl, this.prefixSelection, 0, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.factorInput, 1, 0, 1, 1, 0.5, 0.0);
        GuiTools.addComponent(this, gbl, new JLabel("*"), 2, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.outputTypeSelection, 3, 0, 1, 1, 0.5, 0.0);
        GuiTools.addComponent(this, gbl, this.taxSelection, 4, 0, 1, 1, 0.5, 0.0);
        GuiTools.addComponent(this, gbl, new JLabel(TextPool.getString("labelXMLPluginCalculationElementRange")), 0, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.monthStart, 1, 1, 1, 1, 0.5, 0.0);
        GuiTools.addComponent(this, gbl, new JLabel("-"), 2, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.monthEnd, 3, 1, 1, 1, 0.5, 0.0);
        GuiTools.addComponent(this, gbl, this.rangeNotSelected, 4, 1, 2, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, this.accountSelection, 0, 2, 6, 1, 1.0, 1.0);
    }

    @Override
    public void dialogOpens() {
        if (this.element != null) {
            this.accountSelection.setSelectedAccounts(this.element.getAccounts());
            this.accountSelection.setOkAction(this.okAction);
            this.accountSelection.dialogOpens();
            this.taxSelection.setSelectedIndex(0);
            for (Tax tax : this.taxList) {
                if (!tax.getPercent().equals(this.element.getTax())) continue;
                this.taxSelection.setSelectedTax(tax);
                break;
            }
            int i = 0;
            while (i < TextPool.INCLUDING_EXCLUDING_TAX_OUTPUTTYPE.length) {
                if (this.element.getOutputType() == TextPool.INCLUDING_EXCLUDING_TAX_OUTPUTTYPE[i]) {
                    this.outputTypeSelection.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
            this.prefixSelection.setSelectedItem((Object)this.element.getPrefix());
            this.factorInput.setText(this.element.getFactor().toPlainString());
            if (this.element.getMonthStart() > 0) {
                this.monthStart.setSelectedIndex(this.element.getMonthStart() - 1);
            }
            if (this.element.getMonthEnd() > 0) {
                this.monthEnd.setSelectedIndex(this.element.getMonthEnd() - 1);
            }
            boolean rangeNotSelected = this.element.getMonthStart() == 0 || this.element.getMonthStart() == 0;
            this.rangeNotSelected.setSelected(rangeNotSelected);
            this.monthStart.setEnabled(!rangeNotSelected);
            this.monthEnd.setEnabled(!rangeNotSelected);
        }
    }

    @Override
    public void saveDialogData() {
        this.accountSelection.saveDialogData();
        this.element.setPrefix((CalcPrefix)((Object)this.prefixSelection.getSelectedItem()));
        this.element.setFactor(Numbers.getBigDecimalFromString(this.factorInput.getText(), Numbers.BIG_DECIMAL_ONE));
        List<Integer> selectedAccounts = this.accountSelection.getSelectedAccounts();
        this.element.setAccounts(selectedAccounts);
        if (this.taxSelection.getSelectedIndex() > 0) {
            this.element.setTax(this.taxSelection.getSelectedTax().getPercent());
        } else {
            this.element.setTax(null);
        }
        if (this.rangeNotSelected.isSelected()) {
            this.element.setMonthStart(0);
            this.element.setMonthEnd(0);
        } else {
            this.element.setMonthStart(this.monthStart.getSelectedIndex() + 1);
            this.element.setMonthEnd(this.monthEnd.getSelectedIndex() + 1);
        }
        int selectedOutputType = this.outputTypeSelection.getSelectedIndex();
        this.element.setOutputType(TextPool.INCLUDING_EXCLUDING_TAX_OUTPUTTYPE[selectedOutputType]);
        this.result = this.element;
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleEditCalculationElement");
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }

    @Override
    public void dispose() {
        this.accountSelection.dispose();
    }

    public AbstractXMLPluginCalculationElement getCalculationElement() {
        return this.result;
    }
}

