/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins.gui;

import de.uwemock.eur.calculation.plugins.EurPlugin;
import de.uwemock.eur.calculation.plugins.RemotePluginLoader;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RemotePluginSelectionPanel
extends AbstractStandardDialogPanel {
    private Frame parent;
    private URL url;
    private RemotePluginLoader[] remotePlugins;
    private List<EurPlugin> result;
    private JList pluginsListDisplay;
    private JTextArea pluginDescriptionDisplay;

    public RemotePluginSelectionPanel(Frame parent, URL url) throws FileNotFoundException {
        this.parent = parent;
        this.url = url;
        this.createComponentTree();
        this.remotePlugins = RemotePluginLoader.getPluginsFromURL(this.url);
        if (this.remotePlugins == null) {
            JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgRemotePluginsConnectionError"), TextPool.getString("titleErrorMessage"), 0);
            throw new FileNotFoundException();
        }
    }

    private void createComponentTree() {
        JPanel listPanel = new JPanel(new BorderLayout());
        this.pluginsListDisplay = new JList();
        listPanel.add("Center", new JScrollPane(this.pluginsListDisplay));
        listPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleRemotePluginsList")));
        JPanel descPanel = new JPanel(new BorderLayout());
        this.pluginDescriptionDisplay = new JTextArea();
        this.pluginDescriptionDisplay.setEditable(false);
        this.pluginDescriptionDisplay.setLineWrap(true);
        this.pluginDescriptionDisplay.setWrapStyleWord(true);
        descPanel.add("Center", new JScrollPane(this.pluginDescriptionDisplay));
        descPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleRemotePluginDescription")));
        JSplitPane splitPane = new JSplitPane(0, true, listPanel, descPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(0.5);
        this.setLayout(new BorderLayout());
        this.add("Center", splitPane);
        this.pluginsListDisplay.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RemotePluginLoader plugin = (RemotePluginLoader)RemotePluginSelectionPanel.this.pluginsListDisplay.getSelectedValue();
                if (plugin != null) {
                    String description = plugin.getDescription();
                    RemotePluginSelectionPanel.this.pluginDescriptionDisplay.setText(description);
                } else {
                    RemotePluginSelectionPanel.this.pluginDescriptionDisplay.setText(null);
                }
            }
        });
        this.setPreferredSize(new Dimension(500, 400));
    }

    @Override
    public void dialogOpens() {
        this.pluginsListDisplay.setModel(new DefaultComboBoxModel<RemotePluginLoader>(this.remotePlugins));
    }

    @Override
    public void saveDialogData() {
        Object[] selectedPlugins = this.pluginsListDisplay.getSelectedValues();
        this.result = new ArrayList<EurPlugin>(selectedPlugins.length);
        int i = 0;
        while (i < selectedPlugins.length) {
            RemotePluginLoader pluginLoader = (RemotePluginLoader)selectedPlugins[i];
            EurPlugin plugin = pluginLoader.getPlugin();
            if (plugin != null) {
                this.result.add(plugin);
            } else {
                String message = String.format(TextPool.getString("msgRemotePluginLoadError"), pluginLoader.getPluginTitle());
                JOptionPane.showMessageDialog(this.parent, message, TextPool.getString("titleErrorMessage"), 0);
            }
            ++i;
        }
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleRemotePlugins");
    }

    public List<EurPlugin> getSelectedPlugins() {
        return this.result;
    }
}

