/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins;

import de.uwemock.eur.calculation.plugins.AbstractXMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.CalcPrefix;
import de.uwemock.eur.calculation.plugins.XMLPluginSnippet;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLPluginSnippetAsCalculationElement
extends AbstractXMLPluginCalculationElement {
    public static final String XML_ELEMENT_ATTR_TYPE = "sum";
    private XMLPluginSnippet snippet;
    private String connectedDisplayVariable;

    public XMLPluginSnippetAsCalculationElement(XMLPluginSnippet snippet) {
        this.snippet = snippet;
    }

    public XMLPluginSnippetAsCalculationElement(String displayVariable) {
        this.connectedDisplayVariable = displayVariable;
    }

    public XMLPluginSnippet getSnippet() {
        return this.snippet;
    }

    public void setSnippet(XMLPluginSnippet snippet) {
        this.snippet = snippet;
    }

    @Override
    public String getCalculationPodString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.getPrefix());
        if (!this.getFactor().equals(Numbers.BIG_DECIMAL_ONE)) {
            result.append(this.getFactor());
            result.append('*');
        }
        result.append(this.snippet.getJavascriptVariableName());
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.getPrefix());
        if (!this.getFactor().equals(Numbers.BIG_DECIMAL_ONE)) {
            result.append(this.getFactor());
            result.append('*');
        }
        if (this.snippet != null) {
            result.append(this.snippet.getDisplayVariableName());
            String description = this.snippet.getDescription();
            if (description != null && !description.isEmpty()) {
                result.append(" (");
                result.append(description);
                result.append(')');
            }
        }
        return result.toString();
    }

    @Override
    public String getPrintOutputString() {
        StringBuilder result = new StringBuilder();
        result.append(this.snippet.getDisplayVariableName());
        String description = this.snippet.getDescription();
        if (description != null && !description.isEmpty()) {
            result.append(" (");
            result.append(description);
            result.append(')');
        }
        return result.toString();
    }

    @Override
    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("element");
        writer.writeAttribute("type", XML_ELEMENT_ATTR_TYPE);
        writer.writeAttribute("prefix", this.getPrefix().toString());
        writer.writeAttribute("factor", this.getFactor().toPlainString());
        writer.writeCharacters(this.snippet.getDisplayVariableName());
        writer.writeEndElement();
    }

    public static AbstractXMLPluginCalculationElement readFromXML(XMLStreamReader reader) throws XMLStreamException {
        String factor;
        if (!XmlTools.isStartElement(reader, "element")) {
            return null;
        }
        if (!XML_ELEMENT_ATTR_TYPE.equals(XmlTools.getOneSingleAttributeValue(reader, "type"))) {
            return null;
        }
        Map<String, String> atts = XmlTools.getAttributes(reader);
        String displayVariableName = reader.getElementText();
        XMLPluginSnippetAsCalculationElement result = new XMLPluginSnippetAsCalculationElement(displayVariableName);
        String prefix = atts.get("prefix");
        if (prefix != null) {
            result.prefix = CalcPrefix.getPrefix(prefix);
        }
        if ((factor = atts.get("factor")) != null) {
            result.factor = Numbers.getBigDecimalFromString(factor, Numbers.BIG_DECIMAL_ONE);
        }
        return result;
    }

    public void connectToSnippet(List<XMLPluginSnippet> snippetsList) {
        if (this.snippet != null) {
            return;
        }
        for (XMLPluginSnippet snippet : snippetsList) {
            if (!this.connectedDisplayVariable.equals(snippet.getDisplayVariableName())) continue;
            this.setSnippet(snippet);
            return;
        }
    }

    @Override
    public Object clone() {
        XMLPluginSnippetAsCalculationElement result = new XMLPluginSnippetAsCalculationElement((XMLPluginSnippet)this.snippet.clone());
        result.prefix = this.prefix;
        result.factor = this.factor;
        return result;
    }
}

