/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins;

import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.AbstractXMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.NameContainsIllegalCharactersException;
import de.uwemock.eur.calculation.plugins.NameStartsWithNumberException;
import de.uwemock.eur.calculation.plugins.XMLPluginSnippetAsCalculationElement;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.tools.LoggingManager;
import de.uwemock.xmltools.XmlTools;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLPluginSnippet
implements Cloneable {
    public static final String XML_PLUGIN_SUM = "sum";
    public static final String XML_PLUGIN_SUM_ATT_DISPLAY_VARIABLE_NAME = "name";
    public static final String XML_PLUGIN_SUM_ATT_OUTPUT_IN_RESULT_TABLE = "output";
    public static final String XML_PLUGIN_SUM_ATT_OUTPUT_IN_RESULT_TABLE_YES = "yes";
    public static final String XML_PLUGIN_SUM_ATT_OUTPUT_IN_RESULT_TABLE_NO = "no";
    public static final String XML_PLUGIN_SUM_DESCRIPTION = "description";
    private String displayVariableName;
    private String javascriptVariableName;
    private boolean outputToResultTable = true;
    private String description;
    private List<AbstractXMLPluginCalculationElement> elements = new ArrayList<AbstractXMLPluginCalculationElement>();

    public XMLPluginSnippet() {
    }

    public XMLPluginSnippet(String displayVariableName) throws NameStartsWithNumberException, NameContainsIllegalCharactersException {
        this.setDisplayVariableName(displayVariableName);
    }

    public List<AbstractXMLPluginCalculationElement> getXMLPluginCalculationElementList() {
        return this.elements;
    }

    public String getDisplayVariableName() {
        return this.displayVariableName;
    }

    public void setDisplayVariableName(String displayVariableName) throws NameContainsIllegalCharactersException {
        if (!XMLPluginSnippet.isValidVariableName(displayVariableName)) {
            throw new NameContainsIllegalCharactersException();
        }
        this.displayVariableName = displayVariableName;
        this.setJavascriptVariableName(displayVariableName);
    }

    public String getJavascriptVariableName() {
        return this.javascriptVariableName;
    }

    private void setJavascriptVariableName(String javascriptVariableName) {
        this.javascriptVariableName = javascriptVariableName.replaceAll(" ", "_");
    }

    public boolean doOutputToResultTable() {
        return this.outputToResultTable;
    }

    public void setOutputToResultTable(boolean outputToResultTable) {
        this.outputToResultTable = outputToResultTable;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPluginSnippetString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.javascriptVariableName);
        buffer.append("=0");
        for (AbstractXMLPluginCalculationElement element : this.elements) {
            buffer.append(element.getCalculationPodString());
        }
        buffer.append(';');
        return buffer.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.displayVariableName);
        if (this.description != null && !this.description.isEmpty()) {
            buffer.append(": ");
            buffer.append(this.description);
        }
        if (!this.outputToResultTable) {
            buffer.append(TextPool.getString("pluginSnippetTextNoOutputToResultTable"));
        }
        return buffer.toString();
    }

    public static boolean isValidVariableName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".indexOf(name.charAt(0)) < 0) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 ".indexOf(c) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_PLUGIN_SUM);
        writer.writeAttribute(XML_PLUGIN_SUM_ATT_DISPLAY_VARIABLE_NAME, this.getDisplayVariableName());
        if (this.doOutputToResultTable()) {
            writer.writeAttribute(XML_PLUGIN_SUM_ATT_OUTPUT_IN_RESULT_TABLE, XML_PLUGIN_SUM_ATT_OUTPUT_IN_RESULT_TABLE_YES);
        } else {
            writer.writeAttribute(XML_PLUGIN_SUM_ATT_OUTPUT_IN_RESULT_TABLE, XML_PLUGIN_SUM_ATT_OUTPUT_IN_RESULT_TABLE_NO);
        }
        XmlTools.writeXmlElement(writer, XML_PLUGIN_SUM_DESCRIPTION, this.getDescription(), null);
        for (AbstractXMLPluginCalculationElement element : this.elements) {
            element.writeToXML(writer);
        }
        writer.writeEndElement();
    }

    public static XMLPluginSnippet readFromXML(XMLStreamReader reader, AccountList accountList, TaxList taxList, List<XMLPluginSnippet> snippetsList) throws XMLStreamException {
        XMLPluginSnippet result;
        if (!XmlTools.isStartElement(reader, XML_PLUGIN_SUM)) {
            return null;
        }
        String displayVariableName = XmlTools.getOneSingleAttributeValue(reader, XML_PLUGIN_SUM_ATT_DISPLAY_VARIABLE_NAME);
        boolean outputToResultTable = XmlTools.getOneSingleAttributeValue(reader, XML_PLUGIN_SUM_ATT_OUTPUT_IN_RESULT_TABLE).equals(XML_PLUGIN_SUM_ATT_OUTPUT_IN_RESULT_TABLE_YES);
        try {
            result = new XMLPluginSnippet(displayVariableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        result.setOutputToResultTable(outputToResultTable);
        while (reader.hasNext()) {
            String description;
            AbstractXMLPluginCalculationElement element;
            reader.next();
            if (XmlTools.isEndElement(reader, XML_PLUGIN_SUM)) break;
            if (XmlTools.isStartElement(reader, "element") && (element = AbstractXMLPluginCalculationElement.readFromXML(reader)) != null) {
                result.elements.add(element);
            }
            if (!XmlTools.isStartElement(reader, XML_PLUGIN_SUM_DESCRIPTION) || (description = reader.getElementText()) == null) continue;
            result.setDescription(description);
        }
        return result;
    }

    public Object clone() {
        XMLPluginSnippet result = new XMLPluginSnippet();
        try {
            result.setDisplayVariableName(this.getDisplayVariableName());
        }
        catch (Exception e) {
            LoggingManager.logException(this.getClass(), e);
        }
        result.setDescription(this.getDescription());
        result.setOutputToResultTable(this.doOutputToResultTable());
        for (AbstractXMLPluginCalculationElement element : this.elements) {
            if (element instanceof XMLPluginSnippetAsCalculationElement) {
                result.elements.add(element);
                continue;
            }
            result.elements.add((AbstractXMLPluginCalculationElement)element.clone());
        }
        return result;
    }

    public static boolean isRecursive(XMLPluginSnippet snippet) {
        LinkedList<XMLPluginSnippet> snippetPath = new LinkedList<XMLPluginSnippet>();
        return XMLPluginSnippet.isRecursive(snippet, snippetPath);
    }

    private static boolean isRecursive(XMLPluginSnippet snippet, List<XMLPluginSnippet> snippetPath) {
        if (snippetPath.contains(snippet)) {
            return true;
        }
        snippetPath.add(snippet);
        for (AbstractXMLPluginCalculationElement element : snippet.elements) {
            XMLPluginSnippetAsCalculationElement snippetAsElement;
            if (!(element instanceof XMLPluginSnippetAsCalculationElement) || !XMLPluginSnippet.isRecursive((snippetAsElement = (XMLPluginSnippetAsCalculationElement)element).getSnippet(), snippetPath)) continue;
            return true;
        }
        return false;
    }
}

