/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.AbstractXMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.CalcPrefix;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.tools.Numbers;
import de.uwemock.tools.ToStringHelper;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLPluginCalculationElement
extends AbstractXMLPluginCalculationElement {
    public static final String XML_ELEMENT_ATTR_TYPE = "simple";
    private static final String XML_ELEMENT_ACCOUNTS_ATTR = "accounts";
    private static final String XML_ELEMENT_TAX_ATTR = "tax";
    private static final String XML_ELEMENT_MONTH_START_ATTR = "startmonth";
    private static final String XML_ELEMENT_MONTH_END_ATTR = "endmonth";
    private static final String XML_ELEMENT_OUTPUTTYPE_ATTR = "outputtype";
    private static final ToStringHelper ACCOUNT_LIST_HELPER = new ToStringHelper(",");
    private AccountList accountList;
    private List<Integer> accounts = new ArrayList<Integer>();
    private BigDecimal tax;
    private int monthStart;
    private int monthEnd;
    private int outputType;

    public BigDecimal getTax() {
        return this.tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public int getMonthStart() {
        return this.monthStart;
    }

    public void setMonthStart(int monthStart) {
        this.monthStart = monthStart;
    }

    public int getMonthEnd() {
        return this.monthEnd;
    }

    public void setMonthEnd(int monthEnd) {
        this.monthEnd = monthEnd;
    }

    public int getOutputType() {
        return this.outputType;
    }

    public void setOutputType(int outputType) {
        if (XMLPluginCalculationElement.outputTypeToString(outputType).isEmpty()) {
            return;
        }
        this.outputType = outputType;
    }

    public List<Integer> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Integer> accounts) {
        this.accounts = accounts;
    }

    public static String outputTypeToString(int outputType) {
        switch (outputType) {
            case 2: {
                return "EXCL";
            }
            case 1: {
                return "INCL";
            }
            case 4: {
                return "TAX";
            }
        }
        return "";
    }

    public String getAccountsString() {
        if (this.accounts != null) {
            return ACCOUNT_LIST_HELPER.toString(this.accounts);
        }
        return "";
    }

    @Override
    public String getCalculationPodString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append((Object)this.prefix);
        if (!this.factor.equals(Numbers.BIG_DECIMAL_ONE)) {
            buffer.append(this.factor.toPlainString());
            buffer.append('*');
        }
        buffer.append("<@ ");
        if (this.accounts != null && this.accounts.size() > 0) {
            buffer.append("ACCOUNT:");
            buffer.append(this.getAccountsString());
            buffer.append(' ');
        }
        if (this.monthStart > 0) {
            buffer.append("MONTH:");
            buffer.append(this.monthStart);
            if (this.monthEnd > 0 && this.monthEnd != this.monthStart) {
                buffer.append('-');
                buffer.append(this.monthEnd);
            }
        }
        if (this.tax != null) {
            buffer.append("TAX:");
            buffer.append(this.tax.toPlainString());
            buffer.append(' ');
        }
        buffer.append("RESULT:");
        buffer.append(XMLPluginCalculationElement.outputTypeToString(this.outputType));
        buffer.append(" @>");
        return buffer.toString();
    }

    @Override
    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEmptyElement("element");
        writer.writeAttribute("type", XML_ELEMENT_ATTR_TYPE);
        writer.writeAttribute(XML_ELEMENT_ACCOUNTS_ATTR, this.getAccountsString());
        writer.writeAttribute(XML_ELEMENT_OUTPUTTYPE_ATTR, XMLPluginCalculationElement.outputTypeToString(this.outputType));
        writer.writeAttribute("prefix", this.getPrefix().toString());
        writer.writeAttribute("factor", this.getFactor().toPlainString());
        if (this.monthStart > 0) {
            writer.writeAttribute(XML_ELEMENT_MONTH_START_ATTR, Integer.toString(this.monthStart));
        }
        if (this.monthEnd > 0) {
            writer.writeAttribute(XML_ELEMENT_MONTH_END_ATTR, Integer.toString(this.monthStart));
        }
        if (this.tax != null) {
            writer.writeAttribute(XML_ELEMENT_TAX_ATTR, this.tax.toPlainString());
        }
    }

    public static AbstractXMLPluginCalculationElement readFromXML(XMLStreamReader reader) {
        String factor;
        String prefix;
        String outputType;
        int month;
        String endMonth;
        int month2;
        String startMonth;
        String taxValue;
        if (!XmlTools.isStartElement(reader, "element")) {
            return null;
        }
        if (!XML_ELEMENT_ATTR_TYPE.equals(XmlTools.getOneSingleAttributeValue(reader, "type"))) {
            return null;
        }
        XMLPluginCalculationElement result = new XMLPluginCalculationElement();
        Map<String, String> atts = XmlTools.getAttributes(reader);
        if (!XML_ELEMENT_ATTR_TYPE.equals(atts.get("type"))) {
            return null;
        }
        String accountsList = atts.get(XML_ELEMENT_ACCOUNTS_ATTR);
        if (accountsList != null) {
            String[] accounts = accountsList.split(",");
            result.accounts = new ArrayList<Integer>();
            String[] stringArray = accounts;
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                String account = stringArray[n2];
                int num = Numbers.getIntFromString(account, -1);
                if (num >= 0) {
                    result.accounts.add(num);
                }
                ++n2;
            }
        }
        if ((taxValue = atts.get(XML_ELEMENT_TAX_ATTR)) != null) {
            result.tax = Numbers.getBigDecimalFromString(taxValue, Numbers.BIG_DECIMAL_ZERO);
        }
        if ((startMonth = atts.get(XML_ELEMENT_MONTH_START_ATTR)) != null && (month2 = Numbers.getIntFromString(startMonth, 0)) > 0) {
            result.monthStart = month2;
        }
        if ((endMonth = atts.get(XML_ELEMENT_MONTH_END_ATTR)) != null && (month = Numbers.getIntFromString(endMonth, result.monthStart)) > 0) {
            result.monthEnd = month;
        }
        if ("EXCL".equals(outputType = atts.get(XML_ELEMENT_OUTPUTTYPE_ATTR))) {
            result.outputType = 2;
        }
        if ("INCL".equals(outputType)) {
            result.outputType = 1;
        }
        if ("TAX".equals(outputType)) {
            result.outputType = 4;
        }
        if ((prefix = atts.get("prefix")) != null) {
            result.prefix = CalcPrefix.getPrefix(prefix);
        }
        if ((factor = atts.get("factor")) != null) {
            result.factor = Numbers.getBigDecimalFromString(factor, Numbers.BIG_DECIMAL_ONE);
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append((Object)this.prefix);
        if (!this.factor.equals(Numbers.BIG_DECIMAL_ONE)) {
            buffer.append(this.factor.toPlainString());
            buffer.append('*');
        }
        switch (this.outputType) {
            case 2: {
                buffer.append(TextPool.getString("pluginElementTextAmountExclTax"));
                break;
            }
            case 1: {
                buffer.append(TextPool.getString("pluginElementTextAmountInclTax"));
                break;
            }
            case 4: {
                buffer.append(TextPool.getString("pluginElementTextAmountTax"));
            }
        }
        if (this.monthStart > 0) {
            buffer.append(TextPool.getString("pluginElementTextFromMonths"));
            buffer.append(TextPool.MONTHS[this.monthStart]);
            if (this.monthEnd > 0) {
                buffer.append('-');
                buffer.append(TextPool.MONTHS[this.monthEnd]);
            }
        }
        if (this.accounts.size() > 1) {
            buffer.append(TextPool.getString("pluginElementTextOnMultipleAccounts"));
        } else if (this.accounts.size() > 0) {
            buffer.append(TextPool.getString("pluginElementTextOnAccount"));
            Integer accountNumber = this.accounts.get(0);
            if (this.accountList != null) {
                Account account = this.accountList.getByAccountNumber(accountNumber);
                if (account != null) {
                    buffer.append(account.toString());
                } else {
                    buffer.append(this.accounts.get(0));
                    buffer.append(" - ");
                    buffer.append(TextPool.getString("labelAccountUnknown"));
                }
            } else {
                buffer.append(this.accounts.get(0));
                buffer.append(" - ");
                buffer.append(TextPool.getString("labelAccountUnknown"));
            }
        }
        buffer.append(", ");
        if (this.tax != null) {
            buffer.append(TextPool.getString("labelTax"));
            buffer.append(' ');
            buffer.append(this.tax.toPlainString());
            buffer.append('%');
        } else {
            buffer.append(TextPool.getString("pluginElementTextAllTaxes"));
        }
        return buffer.toString();
    }

    @Override
    public String getPrintOutputString() {
        String lineBreak = "<br>&nbsp;&nbsp;";
        StringBuilder buffer = new StringBuilder();
        switch (this.outputType) {
            case 2: {
                buffer.append(TextPool.getString("pluginElementTextAmountExclTax"));
                break;
            }
            case 1: {
                buffer.append(TextPool.getString("pluginElementTextAmountInclTax"));
                break;
            }
            case 4: {
                buffer.append(TextPool.getString("pluginElementTextAmountTax"));
            }
        }
        if (this.monthStart > 0) {
            buffer.append(TextPool.getString("pluginElementTextFromMonths"));
            buffer.append(TextPool.MONTHS[this.monthStart]);
            if (this.monthEnd > 0) {
                buffer.append('-');
                buffer.append(TextPool.MONTHS[this.monthEnd]);
            }
        }
        if (this.accounts.size() > 1) {
            buffer.append(TextPool.getString("pluginElementTextOnAccounts"));
            int counter = 0;
            for (Integer account : this.accounts) {
                buffer.append(account);
                buffer.append(',');
                if (++counter % 10 != 0) continue;
                buffer.append("<br>&nbsp;&nbsp;");
            }
            buffer.setLength(buffer.length() - 1);
            if (counter % 10 == 0) {
                buffer.setLength(buffer.length() - "<br>&nbsp;&nbsp;".length());
            }
        } else if (this.accounts.size() > 0) {
            buffer.append(TextPool.getString("pluginElementTextOnAccount"));
            buffer.append(this.accounts.get(0));
        }
        buffer.append(", ");
        if (this.tax != null) {
            buffer.append(TextPool.getString("labelTax"));
            buffer.append(' ');
            buffer.append(this.tax.toPlainString());
            buffer.append('%');
        } else {
            buffer.append(TextPool.getString("pluginElementTextAllTaxes"));
        }
        return buffer.toString();
    }

    public void setAccountList(AccountList accountList) {
        this.accountList = accountList;
    }

    @Override
    public Object clone() {
        XMLPluginCalculationElement result = new XMLPluginCalculationElement();
        for (Integer account : this.accounts) {
            result.accounts.add(account);
        }
        result.prefix = this.prefix;
        result.factor = this.factor;
        result.monthStart = this.monthStart;
        result.monthEnd = this.monthEnd;
        result.outputType = this.outputType;
        result.tax = this.tax;
        return result;
    }
}

