/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins;

import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.AbstractEurPlugin;
import de.uwemock.eur.calculation.plugins.AbstractXMLPluginCalculationElement;
import de.uwemock.eur.calculation.plugins.XMLPluginSnippet;
import de.uwemock.eur.calculation.plugins.XMLPluginSnippetAsCalculationElement;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.kernels.HtmlContentsHelper;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.xmltools.XmlTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLPlugin
extends AbstractEurPlugin {
    public static final String XML_XML_PLUGIN_ATT_TYPE = "xml";
    private static final String XML_XML_PLUGIN_ATT_ASK_FOR_TIMEFRAME = "askfortimeframe";
    private static final String XML_XML_PLUGIN_ATT_ASK_FOR_TIMEFRAME_YES = "yes";
    private static final String XML_XML_PLUGIN_ATT_ASK_FOR_TIMEFRAME_NO = "no";
    private List<XMLPluginSnippet> snippetsList = new ArrayList<XMLPluginSnippet>();
    private String title;
    private boolean askForTimeFrame = false;

    public XMLPlugin(String title) {
        this.title = title;
    }

    public List<XMLPluginSnippet> getSnippetsList() {
        return this.snippetsList;
    }

    @Override
    public String getPluginTitle() {
        return this.title;
    }

    public void setPluginTitle(String title) {
        this.title = title;
    }

    public boolean doAskForTimeFrame() {
        return this.askForTimeFrame;
    }

    public void setAskForTimeFrame(boolean askForTimeFrame) {
        this.askForTimeFrame = askForTimeFrame;
    }

    @Override
    public StringBuffer getPluginContents() {
        HtmlContext htmlContext = new HtmlContext();
        htmlContext.addStyleSheet(null, ".column_number { vertical-align:top; }\n.column_amount { text-align:right; vertical-align:top; font-family:monospace; }\n");
        htmlContext.setTitle(this.getPluginTitle());
        htmlContext.addJavaScriptLib("FormatWrite");
        ArrayList<XMLPluginSnippet> snippetsInCalculationOrder = new ArrayList<XMLPluginSnippet>(this.snippetsList);
        Collections.copy(snippetsInCalculationOrder, this.snippetsList);
        boolean exchanged = true;
        while (exchanged) {
            exchanged = false;
            int i = 0;
            while (i < snippetsInCalculationOrder.size()) {
                XMLPluginSnippet snippet = (XMLPluginSnippet)snippetsInCalculationOrder.get(i);
                for (AbstractXMLPluginCalculationElement abstractXMLPluginCalculationElement : snippet.getXMLPluginCalculationElementList()) {
                    XMLPluginSnippetAsCalculationElement snippetAsElement;
                    if (!(abstractXMLPluginCalculationElement instanceof XMLPluginSnippetAsCalculationElement) || snippetsInCalculationOrder.indexOf((snippetAsElement = (XMLPluginSnippetAsCalculationElement)abstractXMLPluginCalculationElement).getSnippet()) <= i) continue;
                    snippetsInCalculationOrder.remove(snippet);
                    snippetsInCalculationOrder.add(snippet);
                    exchanged = true;
                    break;
                }
                ++i;
            }
        }
        StringBuilder calculationBlock = new StringBuilder();
        for (XMLPluginSnippet snippet : snippetsInCalculationOrder) {
            calculationBlock.append(snippet.getPluginSnippetString());
            calculationBlock.append('\n');
        }
        htmlContext.addJavaScriptLib("JesCalculationBlock", calculationBlock.toString());
        htmlContext.addElement("h1", null, null, null, this.getPluginTitle());
        htmlContext.addElement("h2", null, null, null, String.valueOf(TextPool.getString("labelBusinessYear")) + " <@ YEAR @>");
        if (this.askForTimeFrame) {
            htmlContext.addElement("h3", null, null, null, String.valueOf(TextPool.getString("labelTimeFrame")) + " <@ ASK_FOR_TIMEFRAME @>");
        }
        HtmlTable basicData = new HtmlTable();
        basicData.setCellpadding("0px");
        basicData.setCellspacing("0px");
        basicData.setContents(0, 0, TextPool.getString("htmlTextName"));
        basicData.setContents(1, 0, "&nbsp;&nbsp;");
        basicData.setContents(2, 0, "<@ NAME @>");
        basicData.setContents(0, 1, TextPool.getString("htmlTextCompany"));
        basicData.setContents(2, 1, "<@ COMPANY @>");
        basicData.setContents(0, 2, TextPool.getString("htmlTextAddress"));
        basicData.setContents(2, 2, "<@ ADDRESS @>");
        basicData.setContents(0, 3, TextPool.getString("htmlTextTaxId"));
        basicData.setContents(2, 3, "<@ TAXID @>");
        htmlContext.addElement(basicData);
        htmlContext.addLineBreak();
        HtmlContentsHelper.addSwitchZeros(htmlContext);
        htmlContext.addLineBreak();
        HtmlTable htmlTable = new HtmlTable();
        htmlTable.setBorder("1px solid black");
        htmlTable.setCellspacing("0px");
        htmlTable.setCellpadding("2px");
        int row = 0;
        StringBuilder javascriptOutput = new StringBuilder();
        for (XMLPluginSnippet snippet : this.snippetsList) {
            if (!snippet.doOutputToResultTable()) continue;
            htmlTable.setContents(0, row, snippet.getDisplayVariableName());
            htmlTable.setCssClass(0, row, "column_number");
            htmlTable.setContents(1, row, snippet.getDescription());
            javascriptOutput.setLength(0);
            javascriptOutput.append("<script type=\"text/javascript\"> formatWrite(");
            javascriptOutput.append(snippet.getJavascriptVariableName());
            javascriptOutput.append("); </script>");
            htmlTable.setContents(2, row, javascriptOutput.toString());
            htmlTable.setCssClass(2, row, "column_amount");
            htmlTable.setNoWrap(0, row, true);
            htmlTable.setNoWrap(2, row, true);
            ++row;
        }
        htmlContext.addElement(htmlTable);
        return htmlContext.toStringBuffer();
    }

    @Override
    public String toString() {
        return this.getPluginTitle();
    }

    @Override
    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("plugin");
        writer.writeAttribute("type", XML_XML_PLUGIN_ATT_TYPE);
        writer.writeAttribute(XML_XML_PLUGIN_ATT_ASK_FOR_TIMEFRAME, this.askForTimeFrame ? XML_XML_PLUGIN_ATT_ASK_FOR_TIMEFRAME_YES : XML_XML_PLUGIN_ATT_ASK_FOR_TIMEFRAME_NO);
        writer.writeAttribute("title", this.getPluginTitle());
        for (XMLPluginSnippet snippet : this.snippetsList) {
            snippet.writeToXML(writer);
        }
        writer.writeEndElement();
    }

    public static XMLPlugin readFromXML(XMLStreamReader reader, AccountList accountList, TaxList taxList) throws XMLStreamException {
        if (!XmlTools.isStartElement(reader, "plugin")) {
            return null;
        }
        String type = XmlTools.getOneSingleAttributeValue(reader, "type");
        if (!type.equals(XML_XML_PLUGIN_ATT_TYPE)) {
            return null;
        }
        String title = XmlTools.getOneSingleAttributeValue(reader, "title");
        if (title == null) {
            title = TextPool.getString("labelPluginUnnamed");
        }
        String askForTimeFrame = XmlTools.getOneSingleAttributeValue(reader, XML_XML_PLUGIN_ATT_ASK_FOR_TIMEFRAME);
        XMLPlugin result = new XMLPlugin(title);
        result.askForTimeFrame = XML_XML_PLUGIN_ATT_ASK_FOR_TIMEFRAME_YES.equals(askForTimeFrame);
        while (reader.hasNext()) {
            reader.next();
            if (XmlTools.isEndElement(reader, "plugin")) break;
            XMLPluginSnippet snippet = XMLPluginSnippet.readFromXML(reader, accountList, taxList, result.snippetsList);
            if (snippet == null) continue;
            result.snippetsList.add(snippet);
        }
        for (XMLPluginSnippet snippet : result.snippetsList) {
            for (AbstractXMLPluginCalculationElement element : snippet.getXMLPluginCalculationElementList()) {
                if (!(element instanceof XMLPluginSnippetAsCalculationElement)) continue;
                XMLPluginSnippetAsCalculationElement snippetAsElement = (XMLPluginSnippetAsCalculationElement)element;
                snippetAsElement.connectToSnippet(result.snippetsList);
            }
        }
        return result;
    }

    @Override
    public AbstractEurPlugin getCopy() {
        HashMap<XMLPluginSnippet, XMLPluginSnippet> originalToClonedSnippedMap = new HashMap<XMLPluginSnippet, XMLPluginSnippet>(this.snippetsList.size());
        XMLPlugin result = new XMLPlugin(this.getPluginTitle());
        result.askForTimeFrame = this.askForTimeFrame;
        for (XMLPluginSnippet snippet : this.snippetsList) {
            XMLPluginSnippet clonedSnippet = (XMLPluginSnippet)snippet.clone();
            result.snippetsList.add(clonedSnippet);
            originalToClonedSnippedMap.put(snippet, clonedSnippet);
        }
        for (XMLPluginSnippet snippet : result.snippetsList) {
            List<AbstractXMLPluginCalculationElement> elementList = snippet.getXMLPluginCalculationElementList();
            int i = 0;
            while (i < elementList.size()) {
                AbstractXMLPluginCalculationElement element = elementList.get(i);
                if (element instanceof XMLPluginSnippetAsCalculationElement) {
                    XMLPluginSnippetAsCalculationElement oldSnippetAsElement = (XMLPluginSnippetAsCalculationElement)element;
                    XMLPluginSnippetAsCalculationElement newSnippetAsElement = new XMLPluginSnippetAsCalculationElement((XMLPluginSnippet)originalToClonedSnippedMap.get(oldSnippetAsElement.getSnippet()));
                    newSnippetAsElement.setFactor(oldSnippetAsElement.getFactor());
                    newSnippetAsElement.setPrefix(oldSnippetAsElement.getPrefix());
                    elementList.set(i, newSnippetAsElement);
                }
                ++i;
            }
        }
        return result;
    }

    public static /* bridge */ /* synthetic */ AbstractEurPlugin readFromXML(XMLStreamReader xMLStreamReader, AccountList accountList, TaxList taxList) throws XMLStreamException {
        return XMLPlugin.readFromXML(xMLStreamReader, accountList, taxList);
    }
}

