/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins;

import de.uwemock.eur.calculation.Pod;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.builder.ReceiptProcessor;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class PodsProcessor
implements ReceiptProcessor {
    private List<Pod> pods;
    private Collection<Integer> untouchedAccounts = new TreeSet<Integer>();

    public PodsProcessor(List<Pod> pods) {
        this.pods = pods;
    }

    @Override
    public void processReceipt(Receipt r) {
        if (!r.isDeleted() && r.isPaid()) {
            boolean used = false;
            for (Pod pod : this.pods) {
                if (!pod.processReceipt(r)) continue;
                used = true;
            }
            if (!used) {
                Collection accounts = (Collection)r.getReceiptInfo(14);
                for (Integer account : accounts) {
                    if (r.amountExcludingTaxAddedToAccount(account).equals(Constants.ZERO) && r.amountTaxAddedToAccount(account).equals(Constants.ZERO)) continue;
                    this.untouchedAccounts.add(account);
                }
            }
        }
    }

    public Collection<Integer> getUntouchedAccounts() {
        return this.untouchedAccounts;
    }
}

