/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins;

import de.uwemock.eur.calculation.plugins.EurPlugin;
import de.uwemock.eur.calculation.plugins.PlainHTMLPlugin;
import de.uwemock.eur.calculation.plugins.XMLPlugin;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.tools.LoggingManager;
import de.uwemock.xmltools.XmlTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class PluginLoader {
    private String title;
    private URL resource;

    public PluginLoader(String title, String resource) {
        this.title = title;
        if (resource.startsWith("http://")) {
            try {
                this.resource = new URL(resource);
            }
            catch (MalformedURLException e) {
                LoggingManager.logException(this.getClass(), e);
            }
        } else {
            this.resource = this.getClass().getResource(resource);
        }
    }

    public PluginLoader(String title, URL resource) {
        this.title = title;
        this.resource = resource;
    }

    public EurPlugin getPlugin() {
        if (this.resource != null) {
            StringBuffer contents;
            block33: {
                URLConnection con = null;
                BufferedReader b = null;
                contents = null;
                try {
                    try {
                        String line;
                        con = this.resource.openConnection();
                        int size = con.getContentLength();
                        contents = new StringBuffer(size > 0 ? size : 4096);
                        b = new BufferedReader(new InputStreamReader((InputStream)con.getContent(), "UTF-8"));
                        while ((line = b.readLine()) != null) {
                            contents.append(line);
                            contents.append('\n');
                        }
                    }
                    catch (IOException e) {
                        LoggingManager.logException(this.getClass(), e);
                        if (b != null) {
                            try {
                                b.close();
                            }
                            catch (IOException e2) {
                                LoggingManager.logException(this.getClass(), e2);
                            }
                        }
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    if (b != null) {
                        try {
                            b.close();
                        }
                        catch (IOException e) {
                            LoggingManager.logException(this.getClass(), e);
                        }
                    }
                    throw throwable;
                }
                if (b != null) {
                    try {
                        b.close();
                    }
                    catch (IOException e) {
                        LoggingManager.logException(this.getClass(), e);
                    }
                }
            }
            if (contents == null) {
                return null;
            }
            if ("<?xml".equals(contents.substring(0, 5))) {
                StringReader reader = new StringReader(contents.toString());
                XMLStreamReader xmlReader = null;
                XMLPlugin plugin = null;
                try {
                    try {
                        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                        xmlReader = inputFactory.createXMLStreamReader(reader);
                        while (xmlReader.hasNext()) {
                            xmlReader.next();
                            if (!XmlTools.isStartElement(xmlReader, "plugin") || (plugin = XMLPlugin.readFromXML(xmlReader, DataCenter.getInstance().getAccountList(), DataCenter.getInstance().getTaxList())) == null) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (xmlReader != null) {
                            try {
                                xmlReader.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }
                finally {
                    if (xmlReader != null) {
                        try {
                            xmlReader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                return plugin;
            }
            if ("<html".equals(contents.substring(0, 5))) {
                return new PlainHTMLPlugin(this.title, contents);
            }
        }
        return null;
    }

    public String getPluginTitle() {
        return this.title;
    }

    public String toString() {
        return this.title;
    }
}

