/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins;

import de.uwemock.eur.calculation.plugins.AbstractEurPlugin;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.tools.LoggingManager;
import de.uwemock.xmltools.XmlTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class PlainHTMLPlugin
extends AbstractEurPlugin {
    public static final String XML_PLAIN_PLUGIN_ATT_TYPE = "plain";
    private String title;
    private StringBuffer contents;
    private URL resource;

    public PlainHTMLPlugin(String title, File file) {
        block13: {
            this.title = title;
            long size = file.length();
            this.contents = new StringBuffer((int)size);
            BufferedReader b = null;
            try {
                try {
                    String line;
                    b = new BufferedReader(new FileReader(file));
                    while ((line = b.readLine()) != null) {
                        this.contents.append(line);
                        this.contents.append('\n');
                    }
                }
                catch (IOException iOException) {
                    if (b == null) break block13;
                    try {
                        b.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (b != null) {
                    try {
                        b.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public PlainHTMLPlugin(String title, URL resource) {
        this.title = title;
        this.resource = resource;
    }

    public PlainHTMLPlugin(String title, StringBuffer contents) {
        this.title = title;
        this.contents = contents;
    }

    public static PlainHTMLPlugin getFromResource(String title, String resource) {
        return new PlainHTMLPlugin(title, PlainHTMLPlugin.class.getResource(resource));
    }

    public void getFromResource() {
        block14: {
            if (this.resource == null) {
                return;
            }
            URLConnection con = null;
            BufferedReader b = null;
            try {
                try {
                    String line;
                    con = this.resource.openConnection();
                    int size = con.getContentLength();
                    this.contents = new StringBuffer(size > 0 ? size : 4096);
                    b = new BufferedReader(new InputStreamReader((InputStream)con.getContent()));
                    while ((line = b.readLine()) != null) {
                        this.contents.append(line);
                        this.contents.append('\n');
                    }
                }
                catch (IOException e) {
                    LoggingManager.logException(this.getClass(), e);
                    if (b == null) break block14;
                    try {
                        b.close();
                    }
                    catch (IOException e2) {
                        LoggingManager.logException(this.getClass(), e2);
                    }
                }
            }
            finally {
                if (b != null) {
                    try {
                        b.close();
                    }
                    catch (IOException e) {
                        LoggingManager.logException(this.getClass(), e);
                    }
                }
            }
        }
    }

    @Override
    public StringBuffer getPluginContents() {
        if (this.contents == null && this.resource != null) {
            this.getFromResource();
        }
        return this.contents;
    }

    @Override
    public String getPluginTitle() {
        return this.title;
    }

    @Override
    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("plugin");
        writer.writeAttribute("type", XML_PLAIN_PLUGIN_ATT_TYPE);
        writer.writeAttribute("title", this.getPluginTitle());
        writer.writeCData(this.getPluginContents().toString());
        writer.writeEndElement();
    }

    @Override
    public AbstractEurPlugin getCopy() {
        return new PlainHTMLPlugin(this.getPluginTitle(), new StringBuffer(this.getPluginContents()));
    }

    public static AbstractEurPlugin readFromXML(XMLStreamReader reader) throws XMLStreamException {
        String contents;
        if (!XmlTools.isStartElement(reader, "plugin")) {
            return null;
        }
        String type = XmlTools.getOneSingleAttributeValue(reader, "type");
        if (type != null && !type.equals(XML_PLAIN_PLUGIN_ATT_TYPE)) {
            return null;
        }
        String title = XmlTools.getOneSingleAttributeValue(reader, "title");
        if (title == null) {
            title = TextPool.getString("labelPluginUnnamed");
        }
        if ((contents = reader.getElementText()) == null) {
            return null;
        }
        return new PlainHTMLPlugin(title, new StringBuffer(contents));
    }
}

