/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation.plugins;

import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.EurPlugin;
import de.uwemock.eur.calculation.plugins.PlainHTMLPlugin;
import de.uwemock.eur.calculation.plugins.XMLPlugin;
import de.uwemock.eur.data.TaxList;
import de.uwemock.xmltools.XmlTools;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractEurPlugin
implements EurPlugin {
    public abstract AbstractEurPlugin getCopy();

    public String toString() {
        return this.getPluginTitle();
    }

    public abstract void writeToXML(XMLStreamWriter var1) throws XMLStreamException;

    public static AbstractEurPlugin readFromXML(XMLStreamReader reader, AccountList accountList, TaxList taxList) throws XMLStreamException {
        if (!XmlTools.isStartElement(reader, "plugin")) {
            return null;
        }
        String type = XmlTools.getOneSingleAttributeValue(reader, "type");
        AbstractEurPlugin result = null;
        if (type == null || "plain".equals(type)) {
            result = PlainHTMLPlugin.readFromXML(reader);
        }
        if ("xml".equals(type)) {
            result = XMLPlugin.readFromXML(reader, accountList, taxList);
        }
        return result;
    }
}

