/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation;

import de.uwemock.eur.calculation.ActionPod;
import de.uwemock.eur.calculation.ActionPodType;
import de.uwemock.eur.calculation.Pod;
import de.uwemock.eur.calculation.PodTagFormatException;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.receipt.Receipt;

public class SimplePod
implements Pod,
ActionPod {
    private String tag;
    private String result = "";
    private ActionPodType actionPodType = null;

    SimplePod(String tag) throws PodTagFormatException {
        if (!tag.startsWith("<@")) {
            throw new PodTagFormatException("Tag start '<@' missing))");
        }
        if (!tag.endsWith("@>")) {
            throw new PodTagFormatException("Tag end '@>' missing))");
        }
        this.tag = tag;
        String contents = tag.substring(2, tag.length() - 2).trim().toUpperCase();
        if (contents.equals("NAME")) {
            this.result = DataCenter.getInstance().getOwnerName();
        }
        if (contents.equals("ADDRESS")) {
            this.result = DataCenter.getInstance().getOwnerAddress();
        }
        if (contents.equals("COMPANY")) {
            this.result = DataCenter.getInstance().getOwnerCompany();
        }
        if (contents.equals("TAXID")) {
            this.result = DataCenter.getInstance().getOwnerTaxId();
        }
        if (contents.equals("YEAR")) {
            this.result = Integer.toString(DataCenter.getInstance().getBusinessYear());
        }
        if (contents.equals("CURRENCY")) {
            this.result = DataCenter.getInstance().getCurrency();
        }
        this.actionPodType = ActionPodType.getActionPodType(contents);
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public String getResultString() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean processReceipt(Receipt r) {
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean collectsAccount(int account) {
        return false;
    }

    @Override
    public ActionPodType getActionPodType() {
        return this.actionPodType;
    }

    @Override
    public boolean isActionPodType(ActionPodType type) {
        return this.actionPodType.isActionPodType(type);
    }

    @Override
    public boolean isActionPod() {
        return this.actionPodType != null;
    }
}

