/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation;

import de.uwemock.eur.calculation.CalculationPod;
import de.uwemock.eur.calculation.Pod;
import de.uwemock.eur.calculation.PodTagFormatException;
import de.uwemock.eur.calculation.SimplePod;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PodFactory {
    private PodFactory() {
    }

    public static Pod createPod(String tag) throws PodTagFormatException {
        if (tag.indexOf(":") >= 0) {
            return new CalculationPod(tag);
        }
        return new SimplePod(tag);
    }

    public static List<Pod> createPods(StringBuffer template) throws PodTagFormatException {
        Logger logger = Logger.getLogger(PodFactory.class.getName());
        logger.fine("Creating pods");
        ArrayList<Pod> pods = new ArrayList<Pod>();
        int i = 0;
        while (template.indexOf("<@", i) >= 0) {
            int start = template.indexOf("<@", i);
            int end = template.indexOf("@>", start);
            if (start >= 0 && end >= 0) {
                String tag = template.substring(start, end + 2);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Tag found: " + tag);
                }
                pods.add(PodFactory.createPod(tag));
            }
            i = start + 1;
        }
        return pods;
    }
}

