/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.calculation;

import de.uwemock.datetools.Date;
import de.uwemock.eur.calculation.Pod;
import de.uwemock.eur.calculation.PodTagFormatException;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.Receipt;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;

public class CalculationPod
implements Pod {
    public static final int RESULT_TYPE_INCL_TAX = 1;
    public static final int RESULT_TYPE_EXCL_TAX = 2;
    public static final int RESULT_TYPE_ONLY_TAX = 4;
    private static final int TWO_PART_TAG = 2;
    private String tag;
    private boolean allAccounts = true;
    private boolean allMonths = true;
    private boolean allTaxes = true;
    private ArrayList<Range> accountRanges = new ArrayList();
    private int monthStart = 1;
    private int monthEnd = 12;
    private BigDecimal tax;
    private int resultType = 0;
    private BigDecimal result = Constants.ZERO;

    CalculationPod(String tag) throws PodTagFormatException {
        String[] parts;
        if (!tag.startsWith("<@")) {
            throw new PodTagFormatException("Tag start '<@' missing))");
        }
        if (!tag.endsWith("@>")) {
            throw new PodTagFormatException("Tag end '@>' missing))");
        }
        this.tag = tag;
        String[] stringArray = parts = tag.substring(2, tag.length() - 2).trim().split(" ");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String[] split = part.trim().split(":");
            if (split.length != 2) {
                throw new PodTagFormatException("Missing or multiple colons: " + part.trim());
            }
            String left = split[0].toUpperCase();
            String right = split[1].toUpperCase();
            if (!(left.equals("ACCOUNT") || left.equals("MONTH") || left.equals("TAX") || left.equals("RESULT"))) {
                throw new PodTagFormatException("Unknown calculation parameter: " + left);
            }
            if (left.equals("ACCOUNT")) {
                String[] ranges;
                String[] stringArray2 = ranges = right.split(",");
                int n3 = ranges.length;
                int n4 = 0;
                while (n4 < n3) {
                    int max;
                    int min;
                    String range = stringArray2[n4];
                    int dash = range.indexOf("-");
                    if (dash >= 0) {
                        min = Integer.parseInt(range.substring(0, dash));
                        max = Integer.parseInt(range.substring(dash + 1));
                    } else {
                        min = max = Integer.parseInt(range);
                    }
                    this.accountRanges.add(new Range(min, max));
                    ++n4;
                }
                this.allAccounts = false;
            }
            if (left.equals("MONTH")) {
                int max;
                int min;
                int dash = right.indexOf("-");
                if (dash >= 0) {
                    min = Integer.parseInt(right.substring(0, dash));
                    max = Integer.parseInt(right.substring(dash + 1));
                } else {
                    min = max = Integer.parseInt(right);
                }
                this.monthStart = min;
                this.monthEnd = max;
                this.allMonths = false;
            }
            if (left.equals("TAX")) {
                this.tax = new BigDecimal(right);
                this.allTaxes = false;
            }
            if (left.equals("RESULT")) {
                if (right.equals("INCL")) {
                    this.resultType = 1;
                }
                if (right.equals("EXCL")) {
                    this.resultType = 2;
                }
                if (right.equals("TAX")) {
                    this.resultType = 4;
                }
                if (this.resultType == 0) {
                    throw new PodTagFormatException("Unknown result type: " + right);
                }
            }
            ++n2;
        }
        if (this.resultType == 0) {
            throw new PodTagFormatException("Result type not set!");
        }
    }

    public void setTimeFrame(int timeframe) {
        if (!this.allMonths) {
            return;
        }
        if (timeframe >= 1 && timeframe <= 12) {
            this.monthStart = timeframe;
            this.monthEnd = timeframe;
            this.allMonths = false;
            return;
        }
        if (timeframe == 41) {
            this.monthStart = 1;
            this.monthEnd = 3;
            this.allMonths = false;
            return;
        }
        if (timeframe == 42) {
            this.monthStart = 4;
            this.monthEnd = 6;
            this.allMonths = false;
            return;
        }
        if (timeframe == 43) {
            this.monthStart = 7;
            this.monthEnd = 9;
            this.allMonths = false;
            return;
        }
        if (timeframe == 44) {
            this.monthStart = 10;
            this.monthEnd = 12;
            this.allMonths = false;
            return;
        }
        if (timeframe == 100) {
            this.allMonths = true;
            return;
        }
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public BigDecimal getResult() {
        return this.result;
    }

    @Override
    public String getResultString() {
        return this.result.toPlainString();
    }

    @Override
    public void reset() {
        this.result = Constants.ZERO;
    }

    @Override
    public boolean processReceipt(Receipt r) {
        int month;
        Collection<Integer> relevantAccountsAddedTo;
        int businessYear = DataCenter.getInstance().getBusinessYear();
        boolean hasDepreciation = r.hasDepreciationStrategy();
        DepreciationStrategy ds = null;
        if (hasDepreciation) {
            ds = r.getDepreciationStrategy();
        }
        Collection<Integer> originalAccountsAddedTo = r.getAllAccountNumbers();
        if (!this.allAccounts) {
            relevantAccountsAddedTo = new ArrayList<Integer>();
            for (Integer i : originalAccountsAddedTo) {
                int number = i;
                for (Range range : this.accountRanges) {
                    if (!range.isInRange(number)) continue;
                    relevantAccountsAddedTo.add(i);
                }
            }
            if (relevantAccountsAddedTo.size() == 0) {
                return false;
            }
        } else {
            relevantAccountsAddedTo = originalAccountsAddedTo;
        }
        Date date = r.getDate();
        if (!(this.allMonths || (month = date.getMonth()) >= this.monthStart && month <= this.monthEnd)) {
            return false;
        }
        Collection<Payment> payments = r.getAllPayments();
        BigDecimal amountToAdd = Constants.ZERO;
        block2: for (Payment p : payments) {
            if (!this.allTaxes && !this.tax.equals(p.getPercentTax())) continue;
            for (Integer account : relevantAccountsAddedTo) {
                if (account.intValue() != p.getAccount()) continue;
                if (this.resultType == 1) {
                    amountToAdd = amountToAdd.add(p.getAmountIncludingTax());
                    if (hasDepreciation && businessYear == ds.getStartYear()) {
                        amountToAdd = amountToAdd.add(p.getAmountTax());
                    }
                }
                if (this.resultType == 2) {
                    amountToAdd = amountToAdd.add(p.getAmountExcludingTax());
                }
                if (this.resultType != 4) continue block2;
                if (hasDepreciation) {
                    if (businessYear != ds.getStartYear()) continue block2;
                    amountToAdd = amountToAdd.add(p.getAmountTax());
                    continue block2;
                }
                amountToAdd = amountToAdd.add(p.getAmountTax());
                continue block2;
            }
        }
        if (!amountToAdd.equals(Constants.ZERO)) {
            this.result = this.result.add(amountToAdd);
            return true;
        }
        return false;
    }

    @Override
    public boolean collectsAccount(int account) {
        for (Range range : this.accountRanges) {
            if (!range.isInRange(account)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActionPod() {
        return false;
    }

    private static class Range {
        private int start = 0;
        private int end = 0;

        public Range(int start, int end) {
            if (start <= end) {
                this.start = start;
                this.end = end;
            } else {
                this.start = end;
                this.end = start;
            }
        }

        public boolean isInRange(int x) {
            return x >= this.start && x <= this.end;
        }
    }
}

