/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.accounts.gui;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.tools.Numbers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class AccountTableModel
extends AbstractTableModel {
    public static final int COL_NUMBER = 0;
    public static final int COL_NAME = 1;
    public static final int COL_TYPE = 2;
    public static final int COL_VISIBILITY = 3;
    private static final String[] COLUMNS_ACCOUNT = TextPool.getArray("COLUMNS_ACCOUNT");
    private List<Account> accountList = new ArrayList<Account>();
    Collection<Integer> accountsUsed;
    private boolean changed = false;

    public AccountTableModel(AccountList accountList, Collection<Integer> accountsUsed) {
        this.accountList = accountList;
        this.accountsUsed = accountsUsed;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged() {
        this.changed = true;
    }

    @Override
    public int getColumnCount() {
        return COLUMNS_ACCOUNT.length;
    }

    @Override
    public int getRowCount() {
        if (this.accountList != null) {
            return this.accountList.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Account a;
        if (this.accountList != null && (a = this.accountList.get(rowIndex)) != null) {
            switch (columnIndex) {
                case 0: {
                    return Integer.toString(a.getAccountNumber());
                }
                case 1: {
                    return a.getAccountName();
                }
                case 2: {
                    return a.getAccountType();
                }
                case 3: {
                    return a.isVisible();
                }
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS_ACCOUNT[columnIndex];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        Account a = this.accountList.get(row);
        return !this.isAccountUsed(a) || col == 1 || col == 3 || col == 2 && a.getAccountType() == 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.accountList != null && value != null) {
            Account a = this.getAccount(row);
            if (a == null) {
                return;
            }
            switch (col) {
                case 0: {
                    a.setAccountNumber(Numbers.getIntFromString(value.toString(), a.getAccountNumber()));
                    break;
                }
                case 1: {
                    a.setAccountName(value.toString());
                    break;
                }
                case 2: {
                    if (value.toString().equals(TextPool.getString("accountTypeIncome"))) {
                        a.setAccountType(2);
                    }
                    if (value.toString().equals(TextPool.getString("accountTypeSpending"))) {
                        a.setAccountType(1);
                    }
                    if (value.toString().equals(TextPool.getString("accountTypeIncomeTax"))) {
                        a.setAccountType(6);
                    }
                    if (value.toString().equals(TextPool.getString("accountTypeSpendingTax"))) {
                        a.setAccountType(5);
                    }
                    if (!value.toString().equals(TextPool.getString("accountTypeTax"))) break;
                    a.setAccountType(4);
                    break;
                }
                case 3: {
                    a.setVisible((Boolean)value);
                }
            }
            this.fireTableCellUpdated(row, col);
            this.setChanged();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(c);
    }

    public void addItem(Account account) {
        this.accountList.add(account);
        int i = this.accountList.indexOf(account);
        this.fireTableRowsInserted(i, i);
        this.setChanged();
    }

    public void removeItem(int row) {
        this.accountList.remove(row);
        this.fireTableRowsDeleted(row, row);
        this.setChanged();
    }

    public void setAccountList(AccountList newList, Collection<Integer> accountsUsed) {
        this.setChanged();
        this.accountList = newList;
        this.fireTableDataChanged();
    }

    public Account getAccount(int row) {
        if (row < 0 || row >= this.accountList.size()) {
            return null;
        }
        return this.accountList.get(row);
    }

    private boolean isAccountUsed(int accountNumber) {
        if (this.accountsUsed == null) {
            return true;
        }
        return this.accountsUsed.contains(accountNumber);
    }

    private boolean isAccountUsed(Account account) {
        return this.isAccountUsed(account.getAccountNumber());
    }
}

