/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.accounts.gui;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.accounts.gui.AccountListModel;
import de.uwemock.eur.accounts.gui.AccountRenderer;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AccountSelectionPanel
extends AbstractStandardDialogPanel {
    private JList allAccountsList;
    private JList selectedAccountsList;
    private JButton buttonSelect = new JButton("->");
    private JButton buttonUnselect = new JButton("<-");
    private Action okAction;
    private AccountList accountList;
    private List<Account> selectedAccounts;

    public AccountSelectionPanel(AccountList accountList) {
        this.accountList = (AccountList)accountList.clone();
        this.createComponentTree();
    }

    public AccountSelectionPanel(AccountList accountList, List<Account> selected) {
        this(accountList);
        for (Account account : selected) {
            this.moveAccount(account, this.allAccountsList, this.selectedAccountsList);
        }
    }

    public void createComponentTree() {
        this.allAccountsList = new JList(new AccountListModel(this.accountList));
        this.allAccountsList.setCellRenderer(new AccountRenderer());
        this.allAccountsList.setVisibleRowCount(12);
        Dimension listSize = this.allAccountsList.getPreferredSize();
        this.selectedAccountsList = new JList(new AccountListModel(new AccountList()));
        this.selectedAccountsList.setCellRenderer(new AccountRenderer());
        this.selectedAccountsList.setVisibleRowCount(12);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(Box.createVerticalGlue());
        centerPanel.add(this.buttonSelect);
        centerPanel.add(this.buttonUnselect);
        centerPanel.add(Box.createVerticalGlue());
        this.setLayout(new BorderLayout());
        JScrollPane scroller = new JScrollPane(this.allAccountsList);
        Dimension scrollerSize = scroller.getPreferredSize();
        scroller.setPreferredSize(new Dimension(listSize.width / 2, scrollerSize.height));
        scroller.setHorizontalScrollBarPolicy(32);
        scroller.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleAccountSelectionAllAccounts")));
        this.add((Component)scroller, "West");
        scroller = new JScrollPane(this.selectedAccountsList);
        scroller.setPreferredSize(new Dimension(listSize.width / 2, scrollerSize.height));
        scroller.setHorizontalScrollBarPolicy(32);
        scroller.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleAccountSelectionSelectedAccounts")));
        this.add((Component)scroller, "East");
        this.add((Component)centerPanel, "Center");
        this.buttonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] accounts = AccountSelectionPanel.this.allAccountsList.getSelectedValues();
                int i = 0;
                while (i < accounts.length) {
                    Account account = (Account)accounts[i];
                    AccountSelectionPanel.this.moveAccount(account, AccountSelectionPanel.this.allAccountsList, AccountSelectionPanel.this.selectedAccountsList);
                    ++i;
                }
                AccountSelectionPanel.this.enableButtons();
            }
        });
        this.buttonUnselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] accounts = AccountSelectionPanel.this.selectedAccountsList.getSelectedValues();
                int i = 0;
                while (i < accounts.length) {
                    Account account = (Account)accounts[i];
                    AccountSelectionPanel.this.moveAccount(account, AccountSelectionPanel.this.selectedAccountsList, AccountSelectionPanel.this.allAccountsList);
                    ++i;
                }
                AccountSelectionPanel.this.enableButtons();
            }
        });
        this.allAccountsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AccountSelectionPanel.this.enableButtons();
            }
        });
        this.selectedAccountsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AccountSelectionPanel.this.enableButtons();
            }
        });
        this.doLayout();
    }

    private void enableButtons() {
        this.buttonSelect.setEnabled(this.allAccountsList.getSelectedIndex() >= 0);
        this.buttonUnselect.setEnabled(this.selectedAccountsList.getSelectedIndex() >= 0);
        if (this.okAction != null) {
            this.okAction.setEnabled(this.selectedAccountsList.getModel().getSize() > 0);
        }
    }

    private void moveAccount(Account account, JList from, JList to) {
        DefaultListModel fromModel = (DefaultListModel)from.getModel();
        DefaultListModel toModel = (DefaultListModel)to.getModel();
        int accountNumber = account.getAccountNumber();
        int position = 0;
        int numberItemsInTargetList = toModel.getSize();
        while (position < numberItemsInTargetList && accountNumber > ((Account)toModel.getElementAt(position)).getAccountNumber()) {
            ++position;
        }
        fromModel.removeElement(account);
        toModel.add(position, account);
    }

    @Override
    public void dialogOpens() {
        this.enableButtons();
    }

    @Override
    public void saveDialogData() {
        Object[] selected = this.selectedAccountsList.getSelectedValues();
        this.selectedAccounts = new ArrayList<Account>(selected.length);
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.selectedAccounts.add((Account)o);
            ++n2;
        }
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleAccountSelection");
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }
}

