/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.accounts.gui;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.gui.TextPool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class AccountRenderer
extends JPanel
implements ListCellRenderer {
    private static ImageIcon iconEmpty = new ImageIcon(AccountRenderer.class.getResource("/icons/empty.png"));
    private static ImageIcon iconMoneyIn = new ImageIcon(AccountRenderer.class.getResource("/icons/money_in.png"));
    private static ImageIcon iconMoneyOut = new ImageIcon(AccountRenderer.class.getResource("/icons/money_out.png"));
    private JLabel label0 = new JLabel();
    private JLabel label1 = new JLabel();
    private JLabel label2 = new JLabel();
    private JPanel leftPanel = new JPanel(new BorderLayout(10, 0));
    private AccountList accountList;

    public AccountRenderer() {
        this.setLayout(new BorderLayout(10, 0));
        this.label0.setAlignmentX(0.5f);
        this.label0.setOpaque(false);
        this.label1.setAlignmentX(0.0f);
        this.label1.setOpaque(false);
        this.label2.setAlignmentX(0.0f);
        this.label2.setOpaque(false);
        this.leftPanel.add((Component)this.label0, "West");
        this.leftPanel.add((Component)this.label1, "Center");
        this.add((Component)this.leftPanel, "West");
        this.add((Component)this.label2, "Center");
        this.setOpaque(true);
    }

    public AccountRenderer(AccountList accountList) {
        this();
        this.accountList = accountList;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Account k = null;
        Integer accountNumber = null;
        if (value instanceof Account) {
            k = (Account)value;
        }
        if (value instanceof Integer) {
            accountNumber = (Integer)value;
            if (this.accountList != null) {
                k = this.accountList.getByAccountNumber(accountNumber);
            }
        }
        if (k == null && accountNumber == null) {
            throw new IllegalArgumentException("Value is neither Account nor Integer");
        }
        this.label0.setIcon(null);
        if (k != null) {
            if (k.isIncomeAccount()) {
                this.label0.setIcon(iconMoneyIn);
            }
            if (k.isSpendingsAccount()) {
                this.label0.setIcon(iconMoneyOut);
            }
            if (k.getAccountNumber() > 0) {
                this.label1.setText(Integer.toString(k.getAccountNumber()));
            }
            this.label2.setText(k.getAccountName());
        } else {
            this.label0.setIcon(iconEmpty);
            this.label1.setText(accountNumber.toString());
            this.label2.setText(TextPool.getString("labelAccountUnknown"));
        }
        Color background = list.getBackground();
        Color foreground = list.isEnabled() ? list.getForeground() : Color.LIGHT_GRAY;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            background = Color.BLUE;
            foreground = Color.WHITE;
        } else if (isSelected) {
            background = list.getSelectionBackground();
            foreground = list.isEnabled() ? list.getSelectionForeground() : Color.LIGHT_GRAY;
        }
        this.label0.setBackground(background);
        this.label0.setForeground(foreground);
        this.label1.setBackground(background);
        this.label1.setForeground(foreground);
        this.label2.setBackground(background);
        this.label2.setForeground(foreground);
        this.setBackground(background);
        this.setForeground(foreground);
        this.leftPanel.setBackground(background);
        this.leftPanel.setForeground(foreground);
        return this;
    }
}

