/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.accounts.gui;

import chrriis.dj.swingsuite.JWidePopupComboBox;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.accounts.gui.AccountRenderer;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AutoLengthPopupComboBox;
import java.awt.Dimension;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class AccountComboBox
extends JWidePopupComboBox {
    private AccountList accountList;

    public AccountComboBox() {
        this.initComponent();
    }

    public AccountComboBox(AccountList accountList) {
        super((ComboBoxModel)new DefaultComboBoxModel<Object>(accountList.toArray()));
        this.setAccountList(accountList);
        this.initComponent();
    }

    private void initComponent() {
        this.setRenderer(new AccountRenderer());
        this.setToolTipText(TextPool.getString("tooltipInputAccount"));
        this.setPreferredWidth(400);
        AutoLengthPopupComboBox.extendComboBoxPopup(this);
    }

    public void setAccountList(AccountList accountList) {
        this.setModel(new DefaultComboBoxModel<Object>(accountList.toArray()));
        this.accountList = accountList;
    }

    public Account getSelectedAccount() {
        return (Account)this.getSelectedItem();
    }

    public int getSelectedAccountNumber() {
        return this.getSelectedAccount().getAccountNumber();
    }

    public void setSelectedAccount(Account account) {
        if (this.accountList.contains(account)) {
            this.setSelectedItem(account);
        }
    }

    public void setSelectedAccount(int accountNumber) {
        for (Account a : this.accountList) {
            if (a.getAccountNumber() != accountNumber) continue;
            this.setSelectedAccount(a);
            break;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(this.getPreferredWidth(), d.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

