/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.accounts.gui;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.accounts.gui.AccountRenderer;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AccountAddAndRemovePanel
extends AbstractStandardDialogPanel {
    private JList allAccountsList;
    private JList selectedAccountsList;
    private JButton buttonSelect = new JButton("->");
    private JButton buttonUnselect = new JButton("<-");
    private Action okAction;
    private AccountList accountList;
    private List<Integer> selectedAccounts;

    public AccountAddAndRemovePanel(AccountList accountList) {
        this.accountList = (AccountList)accountList.clone();
        this.createComponentTree();
    }

    public AccountAddAndRemovePanel(AccountList accountList, List<Integer> selected) {
        this(accountList);
        this.setSelectedAccounts(selected);
    }

    public void createComponentTree() {
        DefaultListModel<Integer> allAccountsListModel = new DefaultListModel<Integer>();
        for (Account account : this.accountList) {
            allAccountsListModel.addElement(account.getAccountNumber());
        }
        this.allAccountsList = new JList(allAccountsListModel);
        this.allAccountsList.setCellRenderer(new AccountRenderer(this.accountList));
        this.allAccountsList.setVisibleRowCount(12);
        Dimension listSize = this.allAccountsList.getPreferredSize();
        this.selectedAccountsList = new JList(new DefaultListModel());
        this.selectedAccountsList.setCellRenderer(new AccountRenderer(this.accountList));
        this.selectedAccountsList.setVisibleRowCount(12);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(Box.createVerticalGlue());
        centerPanel.add(this.buttonSelect);
        centerPanel.add(this.buttonUnselect);
        centerPanel.add(Box.createVerticalGlue());
        JScrollPane scroller1 = new JScrollPane(this.allAccountsList);
        Dimension scrollerSize = scroller1.getPreferredSize();
        scroller1.setPreferredSize(new Dimension(listSize.width / 2, scrollerSize.height));
        scroller1.setHorizontalScrollBarPolicy(32);
        scroller1.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleAccountSelectionAllAccounts")));
        JScrollPane scroller2 = new JScrollPane(this.selectedAccountsList);
        scroller2.setPreferredSize(new Dimension(listSize.width / 2, scrollerSize.height));
        scroller2.setHorizontalScrollBarPolicy(32);
        scroller2.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleAccountSelectionSelectedAccounts")));
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GuiTools.addComponent(this, gbl, scroller1, 0, 0, 1, 1, 0.5, 1.0);
        GuiTools.addComponent(this, gbl, centerPanel, 1, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(this, gbl, scroller2, 2, 0, 1, 1, 0.5, 1.0);
        this.buttonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] accounts = AccountAddAndRemovePanel.this.allAccountsList.getSelectedValues();
                int i = 0;
                while (i < accounts.length) {
                    Integer account = (Integer)accounts[i];
                    AccountAddAndRemovePanel.this.moveAccount(account, AccountAddAndRemovePanel.this.allAccountsList, AccountAddAndRemovePanel.this.selectedAccountsList);
                    ++i;
                }
                AccountAddAndRemovePanel.this.enableButtons();
            }
        });
        this.buttonUnselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] accounts = AccountAddAndRemovePanel.this.selectedAccountsList.getSelectedValues();
                int i = 0;
                while (i < accounts.length) {
                    Integer account = (Integer)accounts[i];
                    AccountAddAndRemovePanel.this.moveAccount(account, AccountAddAndRemovePanel.this.selectedAccountsList, AccountAddAndRemovePanel.this.allAccountsList);
                    ++i;
                }
                AccountAddAndRemovePanel.this.enableButtons();
            }
        });
        this.allAccountsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AccountAddAndRemovePanel.this.enableButtons();
            }
        });
        this.selectedAccountsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AccountAddAndRemovePanel.this.enableButtons();
            }
        });
        this.doLayout();
    }

    private void enableButtons() {
        this.buttonSelect.setEnabled(this.allAccountsList.getSelectedIndex() >= 0);
        this.buttonUnselect.setEnabled(this.selectedAccountsList.getSelectedIndex() >= 0);
        if (this.okAction != null) {
            this.okAction.setEnabled(this.selectedAccountsList.getModel().getSize() > 0);
        }
    }

    private void moveAccount(Integer account, JList from, JList to) {
        DefaultListModel fromModel = (DefaultListModel)from.getModel();
        DefaultListModel toModel = (DefaultListModel)to.getModel();
        int accountNumber = account;
        int position = 0;
        int numberItemsInTargetList = toModel.getSize();
        while (position < numberItemsInTargetList && accountNumber > (Integer)toModel.getElementAt(position)) {
            ++position;
        }
        fromModel.removeElement(account);
        toModel.add(position, account);
    }

    public void setSelectedAccounts(List<Integer> selected) {
        if (selected == null) {
            return;
        }
        for (Integer account : selected) {
            this.moveAccount(account, this.allAccountsList, this.selectedAccountsList);
        }
    }

    @Override
    public void dialogOpens() {
        this.enableButtons();
    }

    @Override
    public void saveDialogData() {
        ListModel model = this.selectedAccountsList.getModel();
        this.selectedAccounts = new ArrayList<Integer>(model.getSize());
        int i = 0;
        while (i < model.getSize()) {
            Object o = model.getElementAt(i);
            this.selectedAccounts.add((Integer)o);
            ++i;
        }
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleAccountSelection");
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }

    public List<Integer> getSelectedAccounts() {
        return this.selectedAccounts;
    }
}

