/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.accounts;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.DefaultAccountMap;
import de.uwemock.eur.depreciation.DepreciationStub;
import de.uwemock.eur.gui.AccountListEditor;
import de.uwemock.settings.SettingsCluster;
import de.uwemock.tools.LoggingManager;
import de.uwemock.xmltools.XmlTools;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class AccountList
extends ArrayList<Account> {
    public static final String XML_ACCOUNT_LIST_ACCOUNTS = "accounts";
    private HashMap<Integer, Account> accountMap;
    private DefaultAccountMap defaultAccountMap = new DefaultAccountMap();
    private String accountListTitle;

    public AccountList() {
        this.accountMap = new HashMap();
    }

    public AccountList(String title) {
        this();
        this.accountListTitle = title;
    }

    public String getAccountListTitle() {
        return this.accountListTitle;
    }

    public void setAccountListTitle(String accountListTitle) {
        this.accountListTitle = accountListTitle;
    }

    @Override
    public boolean add(Account account) {
        if (this.accountMap.containsKey(account.getAccountNumber())) {
            return false;
        }
        super.add(account);
        Collections.sort(this);
        this.accountMap.put(account.getAccountNumber(), account);
        return true;
    }

    public Account getByAccountNumber(int index) {
        return this.accountMap.get(index);
    }

    @Override
    public Account remove(int index) {
        Account a = (Account)this.get(index);
        if (a != null) {
            super.remove(index);
            this.accountMap.remove(a.getAccountNumber());
        }
        return a;
    }

    @Override
    public boolean remove(Object account) {
        int index = this.indexOf(account);
        if (index >= 0) {
            return this.remove(index) != null;
        }
        return false;
    }

    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_ACCOUNT_LIST_ACCOUNTS);
        int i = 0;
        while (i < this.size()) {
            ((Account)this.get(i)).writeToXml(writer);
            ++i;
        }
        writer.writeEndElement();
    }

    public static AccountList readFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger(AccountList.class.getName());
        AccountList result = new AccountList();
        while (!XmlTools.isEndElement(reader, XML_ACCOUNT_LIST_ACCOUNTS)) {
            if (XmlTools.isStartElement(reader, "account")) {
                logger.finer("-> Found an account");
                Account newAccount = Account.readFromXML(reader);
                if (newAccount != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("-> -> " + newAccount.toString());
                    }
                    result.add(newAccount);
                }
            }
            reader.next();
        }
        return result;
    }

    public AccountList getFilteredList() {
        AccountList filteredList = new AccountList();
        for (Account a : this) {
            if (!a.isVisible()) continue;
            filteredList.add(a);
        }
        return filteredList;
    }

    @Override
    public String toString() {
        return this.getAccountListTitle();
    }

    public void putDefaultAccount(Class<? extends DepreciationStub> c, Account a) {
        this.defaultAccountMap.putDefaultAccount(c, a);
    }

    public DefaultAccountMap getDefaultAccountMap() {
        return this.defaultAccountMap;
    }

    public void setDefaultAccounts() {
        Set<Class<? extends DepreciationStub>> keys = this.defaultAccountMap.getKnownClasses();
        for (Class clazz : keys) {
            SettingsCluster cluster = null;
            try {
                Method m = clazz.getMethod("getSettingsCluster", new Class[0]);
                cluster = (SettingsCluster)m.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException e) {
                LoggingManager.logException(AccountListEditor.class, e.getTargetException());
            }
            catch (Exception e) {
                LoggingManager.logException(AccountListEditor.class, e);
            }
            if (cluster == null) continue;
            Account defaultAccount = this.defaultAccountMap.getDefaultAccount(clazz);
            cluster.setSettingValue("defaultAccount", defaultAccount.getAccountNumber());
        }
    }

    @Override
    public Object clone() {
        AccountList res = new AccountList();
        for (Account account : this) {
            res.add((Account)account.clone());
        }
        res.defaultAccountMap = this.defaultAccountMap.clone();
        return res;
    }
}

