/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.accounts;

import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Account
implements Comparable<Account>,
Cloneable {
    public static final String XML_ACCOUNT_ACCOUNT = "account";
    public static final String XML_ACCOUNT_ATT_TYPE = "type";
    public static final String XML_ACCOUNT_ATT_INUSE = "inuse";
    public static final String XML_ACCOUNT_ATT_INUSE_YES = "yes";
    public static final String XML_ACCOUNT_ATT_INUSE_NO = "no";
    public static final String XML_ACCOUNT_ATT_TAX_ACCOUNT = "taxaccount";
    public static final String XML_ACCOUNT_ATT_TAX_ACCOUNT_YES = "yes";
    public static final String XML_ACCOUNT_ATT_TAX_ACCOUNT_NO = "no";
    public static final int SPENDINGS_ACCOUNT = 1;
    public static final int INCOME_ACCOUNT = 2;
    public static final int TAX_ACCOUNT = 4;
    private static final String XML_ACCOUNT_ATT_TYPE_INCOME = "income";
    private static final String XML_ACCOUNT_ATT_TYPE_SPENDING = "spending";
    private static final String XML_ACCOUNT_ATT_TYPE_TAX = "tax";
    private static final String XML_ACCOUNT_NUMBER = "number";
    private static final String XML_ACCOUNT_NAME = "name";
    private int accountNumber;
    private String accountName;
    private boolean visible;
    private int accountType;

    public Account(int number, String description) {
        this.setAccountNumber(number);
        this.setAccountName(description);
    }

    public Account(int number, String description, boolean visible) {
        this(number, description);
        this.setVisible(visible);
    }

    public Account(int number, String description, boolean visible, int type) {
        this(number, description, visible);
        this.setAccountType(type);
    }

    public int getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(int accountNumber) {
        assert (accountNumber >= 0) : "Account sets number to value below zero!";
        this.accountNumber = accountNumber;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        assert (accountName != null) : "Account sets null description!";
        assert (accountName.length() > 0) : "Account sets zero length description!";
        this.accountName = accountName;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getAccountType() {
        return this.accountType;
    }

    public boolean isIncomeAccount() {
        return (this.accountType & 2) > 0;
    }

    public boolean isSpendingsAccount() {
        return (this.accountType & 1) > 0;
    }

    public boolean isTaxAccount() {
        return (this.accountType & 4) > 0;
    }

    public void setAccountType(int accountType) {
        if (accountType == (accountType & 7)) {
            this.accountType = accountType;
        }
    }

    @Override
    public int compareTo(Account otherAccount) {
        if (this.accountNumber < otherAccount.accountNumber) {
            return -1;
        }
        if (this.accountNumber > otherAccount.accountNumber) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountName == null ? 0 : this.accountName.hashCode());
        result = 31 * result + this.accountNumber;
        result = 31 * result + this.accountType;
        result = 31 * result + (this.visible ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Account other = (Account)obj;
        if (this.accountName == null ? other.accountName != null : !this.accountName.equals(other.accountName)) {
            return false;
        }
        if (this.accountNumber != other.accountNumber) {
            return false;
        }
        if (this.accountType != other.accountType) {
            return false;
        }
        return this.visible == other.visible;
    }

    public String toString() {
        int number = this.getAccountNumber();
        return String.valueOf(number > 0 ? String.valueOf(number) + " - " : "") + this.getAccountName();
    }

    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        Logger logger = Logger.getLogger("de.uwemock.eur.Account");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Writing Account No. " + this.getAccountNumber());
        }
        writer.writeStartElement(XML_ACCOUNT_ACCOUNT);
        if (this.isIncomeAccount()) {
            writer.writeAttribute(XML_ACCOUNT_ATT_TYPE, XML_ACCOUNT_ATT_TYPE_INCOME);
        }
        if (this.isSpendingsAccount()) {
            writer.writeAttribute(XML_ACCOUNT_ATT_TYPE, XML_ACCOUNT_ATT_TYPE_SPENDING);
        }
        if (this.isTaxAccount()) {
            writer.writeAttribute(XML_ACCOUNT_ATT_TAX_ACCOUNT, "yes");
        } else {
            writer.writeAttribute(XML_ACCOUNT_ATT_TAX_ACCOUNT, "no");
        }
        if (this.isVisible()) {
            writer.writeAttribute(XML_ACCOUNT_ATT_INUSE, "yes");
        } else {
            writer.writeAttribute(XML_ACCOUNT_ATT_INUSE, "no");
        }
        XmlTools.writeXmlElement(writer, XML_ACCOUNT_NUMBER, this.getAccountNumber(), null);
        XmlTools.writeXmlElement(writer, XML_ACCOUNT_NAME, this.getAccountName(), null);
        writer.writeEndElement();
    }

    public static Account readFromXML(XMLStreamReader reader) throws XMLStreamException {
        if (!XmlTools.isStartElement(reader, XML_ACCOUNT_ACCOUNT)) {
            return null;
        }
        boolean newAccountInUse = false;
        int newAccountType = 0;
        int newAccountNumber = 0;
        String newAccountName = null;
        Map<String, String> attr = XmlTools.getAttributes(reader);
        if (attr.containsKey(XML_ACCOUNT_ATT_INUSE)) {
            newAccountInUse = attr.get(XML_ACCOUNT_ATT_INUSE).equals("yes");
        }
        if (attr.containsKey(XML_ACCOUNT_ATT_TAX_ACCOUNT)) {
            newAccountType |= attr.get(XML_ACCOUNT_ATT_TAX_ACCOUNT).equals("yes") ? 4 : 0;
        }
        if (attr.containsKey(XML_ACCOUNT_ATT_TYPE)) {
            String type = attr.get(XML_ACCOUNT_ATT_TYPE);
            if (type.equals(XML_ACCOUNT_ATT_TYPE_INCOME)) {
                newAccountType |= 2;
            }
            if (type.equals(XML_ACCOUNT_ATT_TYPE_SPENDING)) {
                newAccountType |= 1;
            }
            if (type.equals(XML_ACCOUNT_ATT_TYPE_TAX)) {
                newAccountType |= 4;
            }
        }
        while (reader.hasNext()) {
            reader.next();
            if (XmlTools.isEndElement(reader, XML_ACCOUNT_ACCOUNT)) break;
            if (XmlTools.isStartElement(reader, XML_ACCOUNT_NUMBER)) {
                newAccountNumber = Numbers.getIntFromString(reader.getElementText(), 0);
            }
            if (!XmlTools.isStartElement(reader, XML_ACCOUNT_NAME)) continue;
            newAccountName = reader.getElementText();
        }
        if (newAccountType == 0 || newAccountNumber == 0 || newAccountName == null) {
            return null;
        }
        return new Account(newAccountNumber, newAccountName, newAccountInUse, newAccountType);
    }

    public Object clone() {
        Account clone = new Account(this.getAccountNumber(), this.getAccountName(), this.isVisible(), this.getAccountType());
        return clone;
    }
}

