/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.datetools;

import de.uwemock.datetools.DateFormatStrategy;
import de.uwemock.datetools.GermanDateFormat;
import de.uwemock.datetools.GermanShortDateFormat;
import de.uwemock.datetools.ISODateFormat;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.Attribute;
import de.uwemock.xmltools.XmlTools;
import java.lang.ref.SoftReference;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class Date
implements Comparable<Date> {
    public static final String XML_DATE_DATE = "date";
    private static final String XML_DATE_ATT_DAY = "day";
    private static final String XML_DATE_ATT_MONTH = "month";
    private static final String XML_DATE_ATT_YEAR = "year";
    private final int day;
    private final int month;
    private final int year;
    private final int hashCode;
    private final String[] formattedDate = new String[DateFormat.getList().length];
    private static final HashMap<Integer, SoftReference<Date>> dateStorage = new HashMap();

    private Date(int year, int month, int day, Integer hashCode) {
        assert (1 <= day && day <= 31);
        assert (1 <= month && month <= 12);
        assert (1900 <= year);
        this.day = day;
        this.month = month;
        this.year = year;
        this.hashCode = hashCode;
    }

    private Date(int year, int month, int day) {
        this(year, month, day, Date.calculateHashCode(year, month, day));
    }

    public Date(Calendar date) {
        this(date.get(1), date.get(2) + 1, date.get(5));
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        XmlTools.writeXmlElement(writer, XML_DATE_DATE, null, new Attribute(XML_DATE_ATT_YEAR, this.year), new Attribute(XML_DATE_ATT_MONTH, this.month), new Attribute(XML_DATE_ATT_DAY, this.day));
    }

    public static Date readFromXml(XMLStreamReader reader) throws XMLStreamException {
        if (XmlTools.isStartElement(reader, XML_DATE_DATE)) {
            String dateDay = null;
            String dateMonth = null;
            String dateYear = null;
            Map<String, String> attr = XmlTools.getAttributes(reader);
            dateDay = attr.get(XML_DATE_ATT_DAY);
            dateMonth = attr.get(XML_DATE_ATT_MONTH);
            dateYear = attr.get(XML_DATE_ATT_YEAR);
            return new Date(Numbers.getIntFromString(dateYear, 0), Numbers.getIntFromString(dateMonth, 1), Numbers.getIntFromString(dateDay, 1));
        }
        return null;
    }

    public String toString() {
        return this.formatDate(DateFormat.ISO);
    }

    public Calendar toJavaCalendar() {
        Calendar c = Calendar.getInstance();
        c.set(this.year, this.month - 1, this.day);
        return c;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof Date) {
            Date d = (Date)o;
            return this.getYear() == d.getYear() && this.getMonth() == d.getMonth() && this.getDay() == d.getDay();
        }
        return false;
    }

    @Override
    public int compareTo(Date date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        if (this.hashCode < date.hashCode) {
            return -1;
        }
        if (this.hashCode > date.hashCode) {
            return 1;
        }
        return 0;
    }

    public String formatDate(DateFormat format) {
        int numberCode = format.getNumberCode();
        String result = this.formattedDate[numberCode];
        if (result == null) {
            this.formattedDate[numberCode] = result = format.getFormattedDate(this.year, this.month, this.day);
        }
        return result;
    }

    public static int calculateHashCode(int year, int month, int day) {
        return year << 9 | month << 5 | day;
    }

    public static Date getDate(int year, int month, int day) {
        Integer hash = Date.calculateHashCode(year, month, day);
        SoftReference<Date> result = dateStorage.get(hash);
        if (result == null || result.get() == null) {
            result = new SoftReference<Date>(new Date(year, month, day, hash));
            dateStorage.put(hash, result);
        }
        return result.get();
    }

    public static Date getDate(Calendar date) {
        return Date.getDate(date.get(1), date.get(2) + 1, date.get(5));
    }

    public static Date getDate() {
        return Date.getDate(Calendar.getInstance());
    }

    public static enum DateFormat {
        ISO(new ISODateFormat(), 0),
        GERMAN(new GermanDateFormat(), 1),
        GERMAN_SHORT(new GermanShortDateFormat(), 2);

        private final DateFormatStrategy formatStrategy;
        private final int numberCode;
        private static final DateFormat[] allFormats;

        static {
            allFormats = new DateFormat[]{ISO, GERMAN, GERMAN_SHORT};
        }

        private DateFormat(DateFormatStrategy formatStrategy, int numberCode) {
            this.formatStrategy = formatStrategy;
            this.numberCode = numberCode;
        }

        public String toString() {
            return this.formatStrategy.getDescription();
        }

        public String getFormatString() {
            return this.formatStrategy.getFormatString();
        }

        public int getNumberCode() {
            return this.numberCode;
        }

        public static DateFormat[] getList() {
            return allFormats;
        }

        public static DateFormat dateFormatFromNumberCode(int numberCode) {
            DateFormat[] dateFormatArray = allFormats;
            int n = allFormats.length;
            int n2 = 0;
            while (n2 < n) {
                DateFormat format = dateFormatArray[n2];
                if (format.getNumberCode() == numberCode) {
                    return format;
                }
                ++n2;
            }
            return ISO;
        }

        public String getFormattedDate(int year, int month, int day) {
            return this.formatStrategy.getFormattedDate(year, month, day);
        }
    }
}

