/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.csvtools;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class CsvTable {
    private int maxRowNumber;
    private int maxColNumber;
    private HashMap<Integer, Row> rows = new HashMap(1024);
    private String separator = ",";
    private String prefix = "\"";
    private String postfix = "\"";

    private Row getRow(int rowIndex) {
        Integer rowNumber;
        Row row;
        if (rowIndex > this.maxRowNumber) {
            this.maxRowNumber = rowIndex;
        }
        if ((row = this.rows.get(rowNumber = Integer.valueOf(rowIndex))) == null) {
            row = new Row();
            this.rows.put(rowNumber, row);
        }
        return row;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        if (separator != null) {
            this.separator = separator;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (this.separator != null) {
            this.prefix = prefix;
        }
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        if (this.separator != null) {
            this.postfix = postfix;
        }
    }

    public void setContents(int x, int y, String contents) {
        if (x > this.maxColNumber) {
            this.maxColNumber = x;
        }
        Row row = this.getRow(y);
        row.put(x, contents);
    }

    public CharSequence toCsvString() {
        StringBuilder s = new StringBuilder(this.maxRowNumber * this.maxColNumber * 128);
        int y = 0;
        while (y <= this.maxRowNumber) {
            Row row = this.getRow(y);
            s.append(row.createCsvRow(this.maxColNumber + 1, this.separator, this.prefix, this.postfix));
            ++y;
        }
        return s;
    }

    private static class Row {
        private Map<Integer, String> cells = new Hashtable<Integer, String>(128);

        private Row() {
        }

        public void put(int x, String s) {
            if (s != null) {
                this.cells.put(x, s);
            }
        }

        public String get(int x) {
            Integer index = x;
            String c = this.cells.get(index);
            if (c == null) {
                return "";
            }
            return c;
        }

        public CharSequence createCsvRow(int cols, String separator, String prefix, String postfix) {
            StringBuilder s = new StringBuilder(cols * 128);
            int x = 0;
            while (x < cols) {
                if (x > 0) {
                    s.append(separator);
                }
                s.append(prefix);
                s.append(this.get(x));
                s.append(postfix);
                ++x;
            }
            s.append('\n');
            return s;
        }
    }
}

