/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.DateUtil;
import com.toedter.calendar.IDateEditor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSpinnerDateEditor
extends JSpinner
implements IDateEditor,
FocusListener,
ChangeListener {
    private static final long serialVersionUID = 5692204052306085316L;
    protected Date date;
    protected String dateFormatString;
    protected SimpleDateFormat dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);

    public JSpinnerDateEditor() {
        super(new SpinnerDateModel());
        ((JSpinner.DateEditor)this.getEditor()).getTextField().addFocusListener(this);
        DateUtil dateUtil = new DateUtil();
        this.setMinSelectableDate(dateUtil.getMinSelectableDate());
        this.setMaxSelectableDate(dateUtil.getMaxSelectableDate());
        this.addChangeListener(this);
    }

    @Override
    public Date getDate() {
        if (this.date == null) {
            return null;
        }
        return ((SpinnerDateModel)this.getModel()).getDate();
    }

    @Override
    public void setDate(Date date) {
        this.setDate(date, true);
    }

    public void setDate(Date date, boolean updateModel) {
        Date oldDate = this.date;
        this.date = date;
        if (date == null) {
            ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern("");
            ((JSpinner.DateEditor)this.getEditor()).getTextField().setText("");
        } else if (updateModel) {
            if (this.dateFormatString != null) {
                ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern(this.dateFormatString);
            }
            ((SpinnerDateModel)this.getModel()).setValue(date);
        }
        this.firePropertyChange("date", oldDate, date);
    }

    @Override
    public void setDateFormatString(String dateFormatString) {
        try {
            this.dateFormatter.applyPattern(dateFormatString);
        }
        catch (RuntimeException e) {
            this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);
            this.dateFormatter.setLenient(false);
        }
        this.dateFormatString = this.dateFormatter.toPattern();
        this.setToolTipText(this.dateFormatString);
        if (this.date != null) {
            ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern(this.dateFormatString);
        } else {
            ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern("");
        }
        if (this.date != null) {
            String text = this.dateFormatter.format(this.date);
            ((JSpinner.DateEditor)this.getEditor()).getTextField().setText(text);
        }
    }

    @Override
    public String getDateFormatString() {
        return this.dateFormatString;
    }

    @Override
    public JComponent getUiComponent() {
        return this;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2, locale);
        this.setDateFormatString(this.dateFormatter.toPattern());
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        String text = ((JSpinner.DateEditor)this.getEditor()).getTextField().getText();
        if (text.length() == 0) {
            this.setDate(null);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (!b) {
            ((JSpinner.DateEditor)this.getEditor()).getTextField().setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
    }

    @Override
    public Date getMaxSelectableDate() {
        return (Date)((SpinnerDateModel)this.getModel()).getEnd();
    }

    @Override
    public Date getMinSelectableDate() {
        return (Date)((SpinnerDateModel)this.getModel()).getStart();
    }

    @Override
    public void setMaxSelectableDate(Date max) {
        ((SpinnerDateModel)this.getModel()).setEnd(max);
    }

    @Override
    public void setMinSelectableDate(Date min) {
        ((SpinnerDateModel)this.getModel()).setStart(min);
    }

    @Override
    public void setSelectableDateRange(Date min, Date max) {
        this.setMaxSelectableDate(max);
        this.setMinSelectableDate(min);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setDate(((SpinnerDateModel)this.getModel()).getDate(), false);
    }
}

